/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class GammaIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;

    public GammaIntegerCodec(int n) {
        this.offset = n;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n = 1;
        while (!bitInputStream.readBit()) {
            ++n;
        }
        int n2 = bitInputStream.readBits(n - 1);
        int n3 = n2 | 1 << n - 1;
        return n3 - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        if (n + this.offset < 1) {
            throw new IllegalArgumentException("Gamma codec handles only positive values: " + n);
        }
        long l = n + this.offset;
        int n2 = 1 + (int)(Math.log(l) / Math.log(2.0));
        if (n2 > 1) {
            bitOutputStream.write(0L, n2 - 1);
        }
        bitOutputStream.write(l, n2);
        return n2 * 2 - 1;
    }

    @Override
    public final long numberOfBits(Integer n) {
        long l = n + this.offset;
        if (l < 1L) {
            throw new RuntimeException("Invalid valid: " + l);
        }
        int n2 = 1 + (int)(Math.log(l) / Math.log(2.0));
        return n2 * 2 - 1;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

