/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.InputStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ExternalByteArrayCodec
extends AbstractBitCodec<byte[]> {
    private final OutputStream outputStream;
    private final InputStream inputStream;

    public ExternalByteArrayCodec(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream, int n) throws IOException {
        return InputStreamUtils.readFully(this.inputStream, n);
    }

    @Override
    public void readInto(BitInputStream bitInputStream, byte[] byArray, int n, int n2) throws IOException {
        InputStreamUtils.readFully(this.inputStream, byArray, n, n2);
    }

    @Override
    public void skip(BitInputStream bitInputStream) throws IOException {
        this.inputStream.skip(1L);
    }

    @Override
    public void skip(BitInputStream bitInputStream, int n) throws IOException {
        this.inputStream.skip(n);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, byte[] byArray) throws IOException {
        this.outputStream.write(byArray);
        return this.numberOfBits(byArray);
    }

    @Override
    public long numberOfBits(byte[] byArray) {
        return byArray.length * 8;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream) throws IOException {
        throw new RuntimeException("Cannot read byte array of unknown length.");
    }
}

