/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.ChainedDownsamplingIterator;
import htsjdk.samtools.ConstantMemoryDownsamplingIterator;
import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.HighAccuracyDownsamplingIterator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.Iterator;

public class DownsamplingIteratorFactory {
    public static final String HIGH_ACCURACY_DESCRIPTION = "Attempts (but does not guarantee) to provide accuracy up to a specified limit. Accuracy is defined as emitting a proportion of reads as close to the requested proportion as possible. In order to do so this strategy requires memory that is proportional to the number of template names in the incoming stream of reads, and will thus require large amounts of memory when running on large input files.";
    public static final String CONSTANT_MEMORY_DESCRPTION = "Downsamples a stream or file of SAMRecords using a hash-projection strategy such that it can run in constant memory. The downsampling is stochastic, and therefore the actual retained proportion will vary around the requested proportion. Due to working in fixed memory this strategy is good for large inputs, and due to the stochastic nature the accuracy of this strategy is highest with a high number of output records, and diminishes at low output volumes.";
    public static final String CHAINED_DESCRIPTION = "Attempts to provide a compromise strategy that offers some of the advantages of both the ConstantMemory and HighAccuracy strategies. Uses a ConstantMemory strategy to downsample the incoming stream to approximately the desired proportion, and then a HighAccuracy strategy to finish. Works in a single pass, and will provide accuracy close to (but often not as good as) HighAccuracy while requiring memory proportional to the set of reads emitted from the ConstantMemory strategy to the HighAccuracy strategy. Works well when downsampling large inputs to small proportions (e.g. downsampling hundreds of millions of reads and retaining only 2%. Should be accurate 99.9% of the time when the input contains >= 50,000 templates (read names). For smaller inputs, HighAccuracy is recommended instead.";

    public static DownsamplingIterator make(Iterator<SAMRecord> iterator, Strategy strategy, double d, double d2, int n) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy may not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("iterator may not be null");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("proportion must be greater than 0");
        }
        if (d > 1.0) {
            throw new IllegalArgumentException("proportion must be less than 1");
        }
        switch (strategy) {
            case HighAccuracy: {
                return new HighAccuracyDownsamplingIterator(iterator, d, n).setTargetAccuracy(d2);
            }
            case ConstantMemory: {
                return new ConstantMemoryDownsamplingIterator(iterator, d, n);
            }
            case Chained: {
                return new ChainedDownsamplingIterator(iterator, d, n).setTargetAccuracy(d2);
            }
        }
        throw new IllegalStateException("Unexpected value for Strategy enum in switch statement. Bug!!");
    }

    public static DownsamplingIterator make(File file, Strategy strategy, double d, double d2, int n) {
        IOUtil.assertFileIsReadable(file);
        return DownsamplingIteratorFactory.make(SamReaderFactory.makeDefault().open(file), strategy, d, d2, n);
    }

    public static DownsamplingIterator make(SamReader samReader, Strategy strategy, double d, double d2, int n) {
        return DownsamplingIteratorFactory.make(samReader.iterator(), strategy, d, d2, n);
    }

    public static enum Strategy {
        HighAccuracy("Attempts (but does not guarantee) to provide accuracy up to a specified limit. Accuracy is defined as emitting a proportion of reads as close to the requested proportion as possible. In order to do so this strategy requires memory that is proportional to the number of template names in the incoming stream of reads, and will thus require large amounts of memory when running on large input files."),
        ConstantMemory("Downsamples a stream or file of SAMRecords using a hash-projection strategy such that it can run in constant memory. The downsampling is stochastic, and therefore the actual retained proportion will vary around the requested proportion. Due to working in fixed memory this strategy is good for large inputs, and due to the stochastic nature the accuracy of this strategy is highest with a high number of output records, and diminishes at low output volumes."),
        Chained("Attempts to provide a compromise strategy that offers some of the advantages of both the ConstantMemory and HighAccuracy strategies. Uses a ConstantMemory strategy to downsample the incoming stream to approximately the desired proportion, and then a HighAccuracy strategy to finish. Works in a single pass, and will provide accuracy close to (but often not as good as) HighAccuracy while requiring memory proportional to the set of reads emitted from the ConstantMemory strategy to the HighAccuracy strategy. Works well when downsampling large inputs to small proportions (e.g. downsampling hundreds of millions of reads and retaining only 2%. Should be accurate 99.9% of the time when the input contains >= 50,000 templates (read names). For smaller inputs, HighAccuracy is recommended instead.");

        public final String description;

        private Strategy(String string2) {
            this.description = string2;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

