/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.automata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.automata.AutomatonException;
import org.biojava.utils.automata.FiniteAutomaton;
import org.biojava.utils.automata.Nfa;

public class DfaBuilder {
    private Nfa nfa;
    private FiniteAutomaton dfa;
    private boolean converted = false;
    private Map closureSets = new HashMap();

    DfaBuilder(Nfa nfa) throws AutomatonException {
        this.nfa = nfa;
        this.dfa = new FiniteAutomaton("dfa_" + nfa.getName(), nfa.getAlphabet());
        FiniteAutomaton.NodeSet initialSet = nfa.createNodeSet();
        initialSet.addNode(nfa.getStart());
        this.closureSets.put(initialSet, new DfaNode(this.dfa.getStart(), initialSet));
    }

    public FiniteAutomaton getDFA() throws AutomatonException {
        if (!this.converted) {
            this.constructSubsets();
            this.converted = true;
        }
        return this.dfa;
    }

    public void constructSubsets() throws AutomatonException {
        FiniteAutomaton.NodeSet initialSet = this.nfa.createNodeSet();
        initialSet.addNodeSet(this.nfa.getLambdaClosure(this.nfa.getStart()));
        initialSet.addNode(this.nfa.getStart());
        this.constructSubsets(this.getDfaNode(initialSet));
    }

    private void constructSubsets(DfaNode dfaNode) throws AutomatonException {
        FiniteAutomaton.NodeSet closureSet = dfaNode.closureSet;
        HashSet symbolSet = new HashSet();
        for (FiniteAutomaton.Node node : closureSet) {
            symbolSet.addAll(this.nfa.getSymbols(node));
        }
        boolean isLambdaAffected = symbolSet.contains(Nfa.LAMBDA);
        if (isLambdaAffected) {
            symbolSet.remove(Nfa.LAMBDA);
        }
        for (Symbol currSymbol : symbolSet) {
            DfaNode dfaDestNode;
            FiniteAutomaton.NodeSet closureForSymbol = this.nfa.createNodeSet();
            for (FiniteAutomaton.Node node : closureSet) {
                FiniteAutomaton.NodeSet currNodeSet = this.nfa.getClosure(node, currSymbol);
                closureForSymbol.addNodeSet(currNodeSet);
                closureForSymbol.addNodeSet(this.nfa.getLambdaClosure(node));
            }
            if (closureForSymbol.isEmpty()) continue;
            if (this.closureSets.containsKey(closureForSymbol)) {
                dfaDestNode = this.getDfaNode(closureForSymbol);
                this.dfa.addTransition(dfaNode.node, dfaDestNode.node, currSymbol);
                continue;
            }
            dfaDestNode = this.getDfaNode(closureForSymbol);
            this.dfa.addTransition(dfaNode.node, dfaDestNode.node, currSymbol);
            this.constructSubsets(dfaDestNode);
        }
    }

    private DfaNode getDfaNode(FiniteAutomaton.NodeSet nfaNodes) {
        DfaNode dfaNode = (DfaNode)this.closureSets.get(nfaNodes);
        if (dfaNode == null) {
            dfaNode = new DfaNode(nfaNodes);
            this.closureSets.put(nfaNodes, dfaNode);
        }
        return dfaNode;
    }

    private class DfaNode {
        FiniteAutomaton.NodeSet closureSet;
        FiniteAutomaton.Node node;

        private DfaNode(FiniteAutomaton.NodeSet closureSet) {
            this.closureSet = closureSet;
            this.node = DfaBuilder.this.dfa.addNode(this.isTerminal());
        }

        private DfaNode(FiniteAutomaton.Node node, FiniteAutomaton.NodeSet closureSet) {
            this.closureSet = closureSet;
            this.node = node;
        }

        private boolean isTerminal() {
            for (FiniteAutomaton.Node currNode : this.closureSet) {
                if (!currNode.isTerminal()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer output = new StringBuffer();
            output.append(this.node.toString());
            output.append("\n");
            output.append(this.closureSet.toString());
            output.append("\n");
            return output.toString();
        }
    }
}

