/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.math.Fmath;
import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import flanagan.physchem.DonnanConcn;

class DonnanMinim
implements MinimisationFunction {
    public int numOfIons = 0;
    public double[] concnA = null;
    public double[] concnB = null;
    public double[] molesT = null;
    public double[] complex = null;
    public double[] excessConcnA = null;
    public double[] excessConcnB = null;
    public double[] excessComplex = null;
    public double[] assocConsts = null;
    public int[] indexK = null;
    public int nonZeroAssocK = 0;
    public double[] radii = null;
    public double[] charges = null;
    public double ionophoreConcn = 0.0;
    public double ionophoreRad = 0.0;
    public double volumeA = 0.0;
    public double volumeB = 0.0;
    public double interfacialArea = 0.0;
    public double epsilonA = 0.0;
    public double epsilonB = 0.0;
    public double epsilonSternA = 0.0;
    public double epsilonSternB = 0.0;
    public double temp = 298.15;
    public double[] partCoeff = null;
    public double[] partCoeffPot = null;
    public double diffPotentialA = 0.0;
    public double diffPotentialB = 0.0;
    public double sternPotential = 0.0;
    public double sternCap = 0.0;
    public double sternDeltaA = 0.0;
    public double sternDeltaB = 0.0;
    public double chargeValue = 0.0;
    public boolean chargeSame = true;
    public double interfacialChargeDensity = 0.0;
    public double interfacialCharge = 0.0;
    public boolean includeIc = true;
    private double[] start = null;
    private double[] step = null;
    private double[] param = null;

    public DonnanMinim(int noIons) {
        this.numOfIons = noIons;
        this.start = new double[this.numOfIons];
        this.step = new double[this.numOfIons];
        this.param = new double[this.numOfIons];
    }

    @Override
    public double function(double[] x) {
        double chargeBsum = 0.0;
        this.ionConcns(x[0]);
        for (int i = 0; i < this.numOfIons; ++i) {
            chargeBsum += (this.concnB[i] + this.complex[i]) * this.charges[i];
        }
        return chargeBsum * chargeBsum;
    }

    public void ionConcns(double potential) {
        for (int ii = 0; ii < this.numOfIons; ++ii) {
            this.partCoeffPot[ii] = this.partCoeff[ii] * Math.exp(-potential * this.charges[ii] * -1.60217646263E-19 / (1.380650324E-23 * this.temp));
        }
        if (!this.includeIc) {
            if (this.nonZeroAssocK < 2) {
                this.calcConcnsSingleK(potential);
            } else {
                this.calcConcnsMultiK(potential);
            }
        } else {
            this.calcConcnsMultiK(potential);
        }
    }

    public void calcConcnsSingleK(double potential) {
        for (int ii = 0; ii < this.numOfIons; ++ii) {
            if (this.assocConsts[ii] == 0.0 || this.ionophoreConcn == 0.0) {
                if (this.molesT[ii] == 0.0) {
                    this.concnB[ii] = 0.0;
                    this.concnA[ii] = 0.0;
                    this.complex[ii] = 0.0;
                    continue;
                }
                this.concnB[ii] = this.molesT[ii] / (this.volumeA * this.partCoeffPot[ii] + this.volumeB);
                this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                this.complex[ii] = 0.0;
                continue;
            }
            double bb = this.volumeB + this.volumeA * this.partCoeffPot[ii] + this.volumeB * this.assocConsts[ii] * this.ionophoreConcn - this.assocConsts[ii] * this.molesT[ii];
            double aa = this.assocConsts[ii] * (this.volumeB + this.volumeA * this.partCoeffPot[ii]);
            double cc = -this.molesT[ii];
            double root = bb * bb - 4.0 * aa * cc;
            if (root < 0.0) {
                System.out.println("Class: DonnanMinim\nMethod: ionConcns\nthe square root term (b2-4ac) of the quadratic = " + root);
                System.out.println("this term was set to zero as the negative value MAY have arisen from rounding errors");
                root = 0.0;
            }
            double qq = -0.5 * (bb + Fmath.sign(bb) * Math.sqrt(root));
            double root1 = qq / aa;
            double root2 = cc / qq;
            double limit = this.molesT[ii] / (this.volumeA * this.partCoeffPot[ii] + this.volumeB);
            if (root1 >= 0.0 && root1 <= limit) {
                if (root2 < 0.0 || root2 > limit) {
                    this.concnB[ii] = root1;
                    this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                    this.complex[ii] = this.assocConsts[ii] * this.ionophoreConcn * this.concnB[ii] / (1.0 + this.assocConsts[ii] * this.concnB[ii]);
                    continue;
                }
                System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                System.out.println("error1: no physically meaningfull root");
                System.out.println("root1 = " + root1 + " root2 = " + root2 + " limit = " + limit);
                System.exit(0);
                continue;
            }
            if (root2 >= 0.0 && root2 <= limit) {
                if (root1 < 0.0 || root1 > limit) {
                    this.concnB[ii] = root2;
                    this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                    this.complex[ii] = this.assocConsts[ii] * this.ionophoreConcn * this.concnB[ii] / (1.0 + this.assocConsts[ii] * this.concnB[ii]);
                    continue;
                }
                System.out.println("Class: DonnanMinim\nMethod: ionConcns");
                System.out.println("error2: no physically meaningfull root");
                System.out.println("root1 = " + root1 + " root2 = " + root2 + " limit = " + limit);
                System.exit(0);
                continue;
            }
            System.out.println("Class: DonnanMinim\nMethod: ionConcns");
            System.out.println("error3: no physically meaningfull root");
            System.out.println("root1 = " + root1 + " root2 = " + root2 + " limit = " + limit);
            System.exit(0);
        }
    }

    public void calcConcnsMultiK(double potential) {
        for (int ii = 0; ii < this.numOfIons; ++ii) {
            if (this.molesT[ii] == 0.0) {
                this.concnB[ii] = 0.0;
                this.concnA[ii] = 0.0;
                this.complex[ii] = 0.0;
                this.excessConcnA[ii] = 0.0;
                this.excessConcnB[ii] = 0.0;
                this.excessComplex[ii] = 0.0;
            } else {
                this.concnB[ii] = this.molesT[ii] / (this.volumeA * this.partCoeffPot[ii] + this.volumeB);
                this.concnA[ii] = this.concnB[ii] * this.partCoeffPot[ii];
                this.complex[ii] = 0.0;
                this.excessConcnA[ii] = 0.0;
                this.excessConcnB[ii] = 0.0;
                this.excessComplex[ii] = 0.0;
            }
            this.start[ii] = this.concnB[ii];
            this.step[ii] = 0.05 * this.start[ii];
        }
        Minimisation minConcn = new Minimisation();
        DonnanConcn functC = new DonnanConcn();
        functC.numOfIons = this.numOfIons;
        functC.concnA = this.concnA;
        functC.concnB = this.concnB;
        functC.molesT = this.molesT;
        functC.complex = this.complex;
        functC.excessConcnA = this.excessConcnA;
        functC.excessConcnB = this.excessConcnB;
        functC.excessComplex = this.excessComplex;
        functC.assocConsts = this.assocConsts;
        functC.indexK = this.indexK;
        functC.nonZeroAssocK = this.nonZeroAssocK;
        functC.radii = this.radii;
        functC.charges = this.charges;
        functC.ionophoreConcn = this.ionophoreConcn;
        functC.ionophoreRad = this.ionophoreRad;
        functC.volumeA = this.volumeA;
        functC.volumeB = this.volumeB;
        functC.interfacialArea = this.interfacialArea;
        functC.epsilonA = this.epsilonA;
        functC.epsilonB = this.epsilonB;
        functC.epsilonSternA = this.epsilonSternA;
        functC.epsilonSternB = this.epsilonSternB;
        functC.temp = this.temp;
        functC.partCoeffPot = this.partCoeffPot;
        functC.sternCap = this.sternCap;
        functC.sternDeltaA = this.sternDeltaA;
        functC.sternDeltaB = this.sternDeltaB;
        functC.chargeValue = this.chargeValue;
        functC.chargeSame = this.chargeSame;
        functC.interfacialCharge = this.interfacialCharge;
        functC.interfacialChargeDensity = this.interfacialChargeDensity;
        functC.potential = potential;
        functC.includeIc = this.includeIc;
        minConcn.nelderMead(functC, this.start, this.step, 1.0E-20, 10000);
        this.param = minConcn.getParamValues();
        for (int i = 0; i < this.numOfIons; ++i) {
            this.concnB[i] = this.param[i];
            this.concnA[i] = this.concnB[i] * this.partCoeffPot[i];
        }
        this.interfacialCharge = functC.interfacialCharge;
        this.interfacialChargeDensity = functC.interfacialChargeDensity;
    }
}

