/*
 * Decompiled with CFR 0.152.
 */
package flanagan.integration;

import flanagan.integration.DerivFunction;
import flanagan.integration.DerivnFunction;
import flanagan.math.Conv;

public class RungeKutta {
    private double x0 = Double.NaN;
    private double xn = Double.NaN;
    private double y0 = Double.NaN;
    private double[] yy0 = null;
    private int nODE = 0;
    private double step = Double.NaN;
    private double relTol = 1.0E-5;
    private double absTol = 0.001;
    private int maxIter = -1;
    private int nIter = 0;
    private static int nStepsMultiplier = 1000;
    private static double safetyFactor = 0.9;
    private static double incrementFactor = -0.2;
    private static double decrementFactor = -0.25;

    public void setInitialValueOfX(double x0) {
        this.x0 = x0;
    }

    public void setFinalValueOfX(double xn) {
        this.xn = xn;
    }

    public void setInitialValueOfY(double y0) {
        this.setInitialValuesOfY(y0);
    }

    public void setInitialValueOfY(double[] yy0) {
        this.setInitialValuesOfY(yy0);
    }

    public void setInitialValuesOfY(double y0) {
        this.y0 = y0;
        this.yy0 = new double[1];
        this.yy0[0] = y0;
        this.nODE = 1;
    }

    public void setInitialValuesOfY(double[] yy0) {
        this.yy0 = yy0;
        this.nODE = yy0.length;
        if (this.nODE == 1) {
            this.y0 = yy0[0];
        }
    }

    public void setStepSize(double step) {
        this.step = step;
    }

    public void setToleranceScalingFactor(double relTol) {
        this.relTol = relTol;
    }

    public void setToleranceAdditionFactor(double absTol) {
        this.absTol = absTol;
    }

    public void setMaximumIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    public int getNumberOfIterations() {
        return this.nIter;
    }

    public static void resetNstepsMultiplier(int multiplier) {
        nStepsMultiplier = multiplier;
    }

    public double fourthOrder(DerivFunction g) {
        int nsteps;
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (Double.isNaN(this.y0)) {
            throw new IllegalArgumentException("No initial y value has been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double k1 = 0.0;
        double k2 = 0.0;
        double k3 = 0.0;
        double k4 = 0.0;
        double x = 0.0;
        double y = this.y0;
        double ns = (this.xn - this.x0) / this.step;
        ns = Math.rint(ns);
        this.nIter = nsteps = (int)ns;
        double stepUsed = (this.xn - this.x0) / ns;
        for (int i = 0; i < nsteps; ++i) {
            x = this.x0 + (double)i * stepUsed;
            k1 = stepUsed * g.deriv(x, y);
            k2 = stepUsed * g.deriv(x + stepUsed / 2.0, y + k1 / 2.0);
            k3 = stepUsed * g.deriv(x + stepUsed / 2.0, y + k2 / 2.0);
            k4 = stepUsed * g.deriv(x + stepUsed, y + k3);
            y += k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
        }
        return y;
    }

    public static double fourthOrder(DerivFunction g, double x0, double y0, double xn, double h) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        return rk.fourthOrder(g);
    }

    public double[] fourthOrder(DerivnFunction g) {
        int nsteps;
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (this.yy0 == null) {
            throw new IllegalArgumentException("No initial y values have been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double[] k1 = new double[this.nODE];
        double[] k2 = new double[this.nODE];
        double[] k3 = new double[this.nODE];
        double[] k4 = new double[this.nODE];
        double[] y = new double[this.nODE];
        double[] yd = new double[this.nODE];
        double[] dydx = new double[this.nODE];
        double x = 0.0;
        double ns = (this.xn - this.x0) / this.step;
        ns = Math.rint(ns);
        this.nIter = nsteps = (int)ns;
        double stepUsed = (this.xn - this.x0) / ns;
        for (int i = 0; i < this.nODE; ++i) {
            y[i] = this.yy0[i];
        }
        for (int j = 0; j < nsteps; ++j) {
            int i;
            x = this.x0 + (double)j * stepUsed;
            dydx = g.derivn(x, y);
            for (i = 0; i < this.nODE; ++i) {
                k1[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + k1[i] / 2.0;
            }
            dydx = g.derivn(x + stepUsed / 2.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k2[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + k2[i] / 2.0;
            }
            dydx = g.derivn(x + stepUsed / 2.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k3[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + k3[i];
            }
            dydx = g.derivn(x + stepUsed, yd);
            for (i = 0; i < this.nODE; ++i) {
                k4[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                int n = i;
                y[n] = y[n] + (k1[i] / 6.0 + k2[i] / 3.0 + k3[i] / 3.0 + k4[i] / 6.0);
            }
        }
        return y;
    }

    public static double[] fourthOrder(DerivnFunction g, double x0, double[] y0, double xn, double h) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValuesOfY(y0);
        rk.setStepSize(h);
        return rk.fourthOrder(g);
    }

    public double cashKarp(DerivFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (Double.isNaN(this.y0)) {
            throw new IllegalArgumentException("No initial y value has been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double k1 = 0.0;
        double k2 = 0.0;
        double k3 = 0.0;
        double k4 = 0.0;
        double k5 = 0.0;
        double k6 = 0.0;
        double y = this.y0;
        double y5 = 0.0;
        double y6 = 0.0;
        double yd = 0.0;
        double dydx = 0.0;
        double x = this.x0;
        double err = 0.0;
        double delta = 0.0;
        double tol = 0.0;
        int counter = 0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x < this.xn) {
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dydx = g.deriv(x, y);
            k1 = stepUsed * dydx;
            yd = y + k1 / 5.0;
            dydx = g.deriv(x + stepUsed / 5.0, yd);
            k2 = stepUsed * dydx;
            yd = y + (3.0 * k1 + 9.0 * k2) / 40.0;
            dydx = g.deriv(x + 3.0 * stepUsed / 10.0, yd);
            k3 = stepUsed * dydx;
            yd = y + (3.0 * k1 - 9.0 * k2 + 12.0 * k3) / 10.0;
            dydx = g.deriv(x + 3.0 * stepUsed / 5.0, yd);
            k4 = stepUsed * dydx;
            yd = y - 11.0 * k1 / 54.0 + 5.0 * k2 / 2.0 - 70.0 * k3 / 27.0 + 35.0 * k4 / 27.0;
            dydx = g.deriv(x + stepUsed, yd);
            k5 = stepUsed * dydx;
            yd = y + 1631.0 * k1 / 55296.0 + 175.0 * k2 / 512.0 + 575.0 * k3 / 13824.0 + 44275.0 * k4 / 110592.0 + 253.0 * k5 / 4096.0;
            k6 = stepUsed * (dydx = g.deriv(x + 7.0 * stepUsed / 8.0, yd));
            y6 = y + 37.0 * k1 / 378.0 + 250.0 * k3 / 621.0 + 125.0 * k4 / 594.0 + 512.0 * k6 / 1771.0;
            err = Math.abs(y6 - (y5 = y + 2825.0 * k1 / 27648.0 + 18575.0 * k3 / 48384.0 + 13525.0 * k4 / 55296.0 + 277.0 * k5 / 14336.0 + k6 / 4.0));
            tol = err / (Math.abs(y5) * this.relTol + this.absTol);
            if (tol <= 1.0) {
                x += stepUsed;
                delta = safetyFactor * Math.pow(tol, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta > 1.0) {
                    stepUsed *= delta;
                }
                if (x + stepUsed > this.xn) {
                    stepUsed = this.xn - x;
                }
                y = y5;
                continue;
            }
            delta = safetyFactor * Math.pow(tol, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double cashKarp(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.cashKarp(g);
    }

    public static double cashKarp(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol) {
        int maxIter = (int)((double)nStepsMultiplier * (xn - x0) / h);
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.cashKarp(g);
    }

    public double[] cashKarp(DerivnFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (this.yy0 == null) {
            throw new IllegalArgumentException("No initial y values have been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double[] k1 = new double[this.nODE];
        double[] k2 = new double[this.nODE];
        double[] k3 = new double[this.nODE];
        double[] k4 = new double[this.nODE];
        double[] k5 = new double[this.nODE];
        double[] k6 = new double[this.nODE];
        double[] y = new double[this.nODE];
        double[] y6 = new double[this.nODE];
        double[] y5 = new double[this.nODE];
        double[] yd = new double[this.nODE];
        double[] dydx = new double[this.nODE];
        double err = 0.0;
        double maxerr = 0.0;
        double delta = 0.0;
        double tol = 1.0;
        int counter = 0;
        for (int i = 0; i < this.nODE; ++i) {
            y[i] = this.yy0[i];
        }
        double x = this.x0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x < this.xn) {
            int i;
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dydx = g.derivn(x, y);
            for (i = 0; i < this.nODE; ++i) {
                k1[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + k1[i] / 5.0;
            }
            dydx = g.derivn(x + stepUsed / 5.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k2[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + (3.0 * k1[i] + 9.0 * k2[i]) / 40.0;
            }
            dydx = g.derivn(x + 3.0 * stepUsed / 10.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k3[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + (3.0 * k1[i] - 9.0 * k2[i] + 12.0 * k3[i]) / 10.0;
            }
            dydx = g.derivn(x + 3.0 * stepUsed / 5.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k4[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] - 11.0 * k1[i] / 54.0 + 5.0 * k2[i] / 2.0 - 70.0 * k3[i] / 27.0 + 35.0 * k4[i] / 27.0;
            }
            dydx = g.derivn(x + stepUsed, yd);
            for (i = 0; i < this.nODE; ++i) {
                k5[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + 1631.0 * k1[i] / 55296.0 + 175.0 * k2[i] / 512.0 + 575.0 * k3[i] / 13824.0 + 44275.0 * k4[i] / 110592.0 + 253.0 * k5[i] / 4096.0;
            }
            dydx = g.derivn(x + 7.0 * stepUsed / 8.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k6[i] = stepUsed * dydx[i];
            }
            maxerr = 0.0;
            for (i = 0; i < this.nODE; ++i) {
                y5[i] = y[i] + 2825.0 * k1[i] / 27648.0 + 18575.0 * k3[i] / 48384.0 + 13525.0 * k4[i] / 55296.0 + 277.0 * k5[i] / 14336.0 + k6[i] / 4.0;
                y6[i] = y[i] + 37.0 * k1[i] / 378.0 + 250.0 * k3[i] / 621.0 + 125.0 * k4[i] / 594.0 + 512.0 * k6[i] / 1771.0;
                err = Math.abs(y6[i] - y5[i]);
                tol = Math.abs(y5[i]) * this.relTol + this.absTol;
                maxerr = Math.max(maxerr, err / tol);
            }
            if (maxerr <= 1.0) {
                x += stepUsed;
                delta = safetyFactor * Math.pow(maxerr, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta > 1.0) {
                    stepUsed *= delta;
                }
                if (x + stepUsed > this.xn) {
                    stepUsed = this.xn - x;
                }
                y = Conv.copy(y5);
                continue;
            }
            delta = safetyFactor * Math.pow(maxerr, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double[] cashKarp(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValuesOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.cashKarp(g);
    }

    public static double[] cashKarp(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol) {
        double nsteps = (xn - x0) / h;
        int maxIter = (int)nsteps * nStepsMultiplier;
        return RungeKutta.cashKarp(g, x0, y0, xn, h, absTol, relTol, maxIter);
    }

    public double fehlberg(DerivFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (Double.isNaN(this.y0)) {
            throw new IllegalArgumentException("No initial y value has been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double k1 = 0.0;
        double k2 = 0.0;
        double k3 = 0.0;
        double k4 = 0.0;
        double k5 = 0.0;
        double k6 = 0.0;
        double x = this.x0;
        double y = this.y0;
        double y5 = 0.0;
        double y6 = 0.0;
        double err = 0.0;
        double delta = 0.0;
        double tol = 0.0;
        int counter = 0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x < this.xn) {
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            k1 = stepUsed * g.deriv(x, y);
            y6 = y + 16.0 * k1 / 135.0 + 6656.0 * (k3 = stepUsed * g.deriv(x + 3.0 * stepUsed / 8.0, y + (3.0 * k1 + 9.0 * (k2 = stepUsed * g.deriv(x + stepUsed / 4.0, y + k1 / 4.0))) / 32.0)) / 12825.0 + 28561.0 * (k4 = stepUsed * g.deriv(x + 12.0 * stepUsed / 13.0, y + (1932.0 * k1 - 7200.0 * k2 + 7296.0 * k3) / 2197.0)) / 56430.0 - 9.0 * (k5 = stepUsed * g.deriv(x + stepUsed, y + 439.0 * k1 / 216.0 - 8.0 * k2 + 3680.0 * k3 / 513.0 - 845.0 * k4 / 4104.0)) / 50.0 + 2.0 * (k6 = stepUsed * g.deriv(x + 0.5 * stepUsed, y - 8.0 * k1 / 27.0 + 2.0 * k2 - 3544.0 * k3 / 2565.0 + 1859.0 * k4 / 4104.0 - 11.0 * k5 / 40.0)) / 55.0;
            err = Math.abs(y6 - (y5 = y + 25.0 * k1 / 216.0 + 1408.0 * k3 / 2565.0 + 2197.0 * k4 / 4104.0 - k5 / 5.0));
            tol = err / (Math.abs(y5) * this.relTol + this.absTol);
            if (tol <= 1.0) {
                x += stepUsed;
                delta = safetyFactor * Math.pow(tol, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta < 1.0) {
                    stepUsed *= delta;
                }
                if (x + stepUsed > this.xn) {
                    stepUsed = this.xn - x;
                }
                y = y5;
                continue;
            }
            delta = safetyFactor * Math.pow(tol, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double fehlberg(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValueOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.fehlberg(g);
    }

    public static double fehlberg(DerivFunction g, double x0, double y0, double xn, double h, double absTol, double relTol) {
        double nsteps = (xn - x0) / h;
        int maxIter = (int)nsteps * nStepsMultiplier;
        return RungeKutta.fehlberg(g, x0, y0, xn, h, absTol, relTol, maxIter);
    }

    public double[] fehlberg(DerivnFunction g) {
        if (Double.isNaN(this.x0)) {
            throw new IllegalArgumentException("No initial x value has been entered");
        }
        if (Double.isNaN(this.xn)) {
            throw new IllegalArgumentException("No final x value has been entered");
        }
        if (this.yy0 == null) {
            throw new IllegalArgumentException("No initial y values have been entered");
        }
        if (Double.isNaN(this.step)) {
            throw new IllegalArgumentException("No step size has been entered");
        }
        double[] k1 = new double[this.nODE];
        double[] k2 = new double[this.nODE];
        double[] k3 = new double[this.nODE];
        double[] k4 = new double[this.nODE];
        double[] k5 = new double[this.nODE];
        double[] k6 = new double[this.nODE];
        double[] y = new double[this.nODE];
        double[] y6 = new double[this.nODE];
        double[] y5 = new double[this.nODE];
        double[] yd = new double[this.nODE];
        double[] dydx = new double[this.nODE];
        double err = 0.0;
        double maxerr = 0.0;
        double delta = 0.0;
        double tol = 1.0;
        int counter = 0;
        for (int i = 0; i < this.nODE; ++i) {
            y[i] = this.yy0[i];
        }
        double x = this.x0;
        if (this.maxIter == -1) {
            this.maxIter = (int)((double)nStepsMultiplier * (this.xn - this.x0) / this.step);
        }
        double stepUsed = this.step;
        while (x < this.xn) {
            int i;
            if (++counter > this.maxIter) {
                throw new ArithmeticException("Maximum number of iterations exceeded");
            }
            dydx = g.derivn(x, y);
            for (i = 0; i < this.nODE; ++i) {
                k1[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + k1[i] / 4.0;
            }
            dydx = g.derivn(x + stepUsed / 4.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k2[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + (3.0 * k1[i] + 9.0 * k2[i]) / 32.0;
            }
            dydx = g.derivn(x + 3.0 * stepUsed / 8.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k3[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + (1932.0 * k1[i] - 7200.0 * k2[i] + 7296.0 * k3[i]) / 2197.0;
            }
            dydx = g.derivn(x + 12.0 * stepUsed / 13.0, yd);
            for (i = 0; i < this.nODE; ++i) {
                k4[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] + 439.0 * k1[i] / 216.0 - 8.0 * k2[i] + 3680.0 * k3[i] / 513.0 - 845.0 * k4[i] / 4104.0;
            }
            dydx = g.derivn(x + stepUsed, yd);
            for (i = 0; i < this.nODE; ++i) {
                k5[i] = stepUsed * dydx[i];
            }
            for (i = 0; i < this.nODE; ++i) {
                yd[i] = y[i] - 8.0 * k1[i] / 27.0 + 2.0 * k2[i] - 3544.0 * k3[i] / 2565.0 + 1859.0 * k4[i] / 4104.0 - 11.0 * k5[i] / 40.0;
            }
            dydx = g.derivn(x + 0.5 * stepUsed, yd);
            for (i = 0; i < this.nODE; ++i) {
                k6[i] = stepUsed * dydx[i];
            }
            maxerr = 0.0;
            for (i = 0; i < this.nODE; ++i) {
                y5[i] = y[i] + 25.0 * k1[i] / 216.0 + 1408.0 * k3[i] / 2565.0 + 2197.0 * k4[i] / 4104.0 - k5[i] / 5.0;
                y6[i] = y[i] + 16.0 * k1[i] / 135.0 + 6656.0 * k3[i] / 12825.0 + 28561.0 * k4[i] / 56430.0 - 9.0 * k5[i] / 50.0 + 2.0 * k6[i] / 55.0;
                err = Math.abs(y6[i] - y5[i]);
                tol = y5[i] * this.relTol + this.absTol;
                maxerr = Math.max(maxerr, err / tol);
            }
            if (maxerr <= 1.0) {
                x += stepUsed;
                delta = safetyFactor * Math.pow(maxerr, incrementFactor);
                if (delta > 4.0) {
                    stepUsed *= 4.0;
                } else if (delta > 1.0) {
                    stepUsed *= delta;
                }
                if (x + stepUsed > this.xn) {
                    stepUsed = this.xn - x;
                }
                y = Conv.copy(y5);
                continue;
            }
            delta = safetyFactor * Math.pow(maxerr, decrementFactor);
            if (delta < 0.1) {
                stepUsed *= 0.1;
                continue;
            }
            stepUsed *= delta;
        }
        this.nIter = counter;
        return y;
    }

    public static double[] fehlberg(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol, int maxIter) {
        RungeKutta rk = new RungeKutta();
        rk.setInitialValueOfX(x0);
        rk.setFinalValueOfX(xn);
        rk.setInitialValuesOfY(y0);
        rk.setStepSize(h);
        rk.setToleranceScalingFactor(relTol);
        rk.setToleranceAdditionFactor(absTol);
        rk.setMaximumIterations(maxIter);
        return rk.fehlberg(g);
    }

    public static double[] fehlberg(DerivnFunction g, double x0, double[] y0, double xn, double h, double absTol, double relTol) {
        double nsteps = (xn - x0) / h;
        int maxIter = (int)nsteps * nStepsMultiplier;
        return RungeKutta.fehlberg(g, x0, y0, xn, h, absTol, relTol, maxIter);
    }
}

