/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import java.util.List;

public class TsTvStats
implements SamplingStats<VcfEntry> {
    static int[] GENOTYPE_SINGLE_ALT_CHANGE = new int[]{1};
    List<String> sampleNames;
    Boolean homozygous;
    long[] countTs;
    long[] countTv;

    public TsTvStats() {
        this.homozygous = null;
    }

    public TsTvStats(Boolean homozygous) {
        this.homozygous = homozygous;
    }

    @Override
    public boolean hasData() {
        return this.countTs != null;
    }

    public boolean isTransition(String ref, String alt) {
        if (ref.equals("A") && alt.equals("G")) {
            return true;
        }
        if (ref.equals("G") && alt.equals("A")) {
            return true;
        }
        if (ref.equals("C") && alt.equals("T")) {
            return true;
        }
        return ref.equals("T") && alt.equals("C");
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        block11: {
            boolean homo;
            block10: {
                if (this.sampleNames == null) {
                    this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
                }
                if (!vcfEntry.isVariant() || !vcfEntry.isSnp()) {
                    return;
                }
                int genotypes = vcfEntry.getVcfGenotypes().size();
                if (this.countTs == null) {
                    int size = Math.max(genotypes, 1);
                    this.countTs = new long[size];
                    this.countTv = new long[size];
                }
                if (genotypes <= 0) break block10;
                int sampleNum = 0;
                for (VcfGenotype vcfGenotype : vcfEntry) {
                    if (vcfGenotype.isVariant() && (this.homozygous == null || vcfGenotype.isHomozygous() == this.homozygous.booleanValue())) {
                        String[] alts = vcfEntry.getAlts();
                        int[] gens = vcfGenotype.getGenotype();
                        if (gens == null) {
                            gens = GENOTYPE_SINGLE_ALT_CHANGE;
                        }
                        for (int gen : gens) {
                            String alt;
                            if (gen <= 0) continue;
                            String ref = vcfEntry.getRef();
                            if (this.isTransition(ref, alt = alts[gen - 1])) {
                                int n = sampleNum;
                                this.countTs[n] = this.countTs[n] + 1L;
                                continue;
                            }
                            int n = sampleNum;
                            this.countTv[n] = this.countTv[n] + 1L;
                        }
                    }
                    ++sampleNum;
                }
                break block11;
            }
            boolean bl = homo = vcfEntry.getAlts().length <= 1;
            if (this.homozygous != null && homo != this.homozygous) break block11;
            String ref = vcfEntry.getRef();
            for (String alt : vcfEntry.getAlts()) {
                if (ref.equals(alt)) continue;
                if (this.isTransition(ref, alt)) {
                    this.countTs[0] = this.countTs[0] + 1L;
                    continue;
                }
                this.countTv[0] = this.countTv[0] + 1L;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            int i;
            sb.append("Sample        :\t");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(sname + "\t");
                }
            }
            sb.append("Total");
            sb.append("\n");
            long sumTs = 0L;
            sb.append("Transitions   :\t");
            for (int i2 = 0; i2 < this.countTs.length; ++i2) {
                sb.append(this.countTs[i2] + "\t");
                sumTs += this.countTs[i2];
            }
            sb.append(sumTs);
            sb.append("\n");
            long sumTv = 0L;
            sb.append("Transversions :\t");
            for (i = 0; i < this.countTv.length; ++i) {
                sb.append(this.countTv[i] + "\t");
                sumTv += this.countTv[i];
            }
            sb.append(sumTv);
            sb.append("\n");
            sb.append("Ts/Tv         :\t");
            for (i = 0; i < this.countTv.length; ++i) {
                double tstv = (double)this.countTs[i] / (double)this.countTv[i];
                sb.append(String.format("%.3f\t", tstv));
            }
            double tstv = (double)sumTs / (double)sumTv;
            sb.append(String.format("%.3f\t", tstv));
            sb.append("\n");
        }
        return sb.toString();
    }
}

