/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.LossOfFunction;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.LinkedList;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sf.samtools.util.RuntimeEOFException;

public class TestCasesLof
extends TestCase {
    public static boolean debug = false;
    public static final int NUM_DEL_TEST = 10;
    Config config;
    Random random = new Random(20121030L);

    Marker cdsMarker(Transcript tr) {
        int start = tr.isStrandPlus() ? tr.getCdsStart() : tr.getCdsEnd();
        int end = tr.isStrandPlus() ? tr.getCdsEnd() : tr.getCdsStart();
        return new Marker(tr.getParent(), start, end, 1, "");
    }

    LinkedList<ChangeEffect> changeEffects(SeqChange seqChange, ChangeEffect.EffectType effectType, Marker marker) {
        ChangeEffect changeEffect = new ChangeEffect(seqChange);
        changeEffect.set(marker, effectType, "");
        LinkedList<ChangeEffect> changeEffects = new LinkedList<ChangeEffect>();
        changeEffects.add(changeEffect);
        return changeEffects;
    }

    void checkLof(Transcript tr) {
        if (!tr.isProteinCoding()) {
            return;
        }
        this.checkLofSplice(tr);
        this.checkLofStartLost(tr);
        this.checkLofExonDeleted(tr);
        this.checkLofFrameShift(tr);
    }

    void checkLofExonDeleted(Transcript tr) {
        this.checkLofExonDeletedFirstExon(tr);
        this.checkLofExonDeletedHalf(tr);
    }

    void checkLofExonDeletedFirstExon(Transcript tr) {
        Exon ex = tr.getFirstCodingExon();
        SeqChange seqChange = new SeqChange(tr.getChromosome(), ex.getStart(), ex.getEnd(), "");
        seqChange.setChangeType(SeqChange.ChangeType.DEL);
        LinkedList<ChangeEffect> changeEffects = this.changeEffects(seqChange, ChangeEffect.EffectType.EXON_DELETED, ex);
        LossOfFunction lof = new LossOfFunction(changeEffects);
        boolean islof = lof.isLof();
        Assert.assertEquals((boolean)true, (boolean)islof);
    }

    void checkLofExonDeletedHalf(Transcript tr) {
        Marker cds = this.cdsMarker(tr);
        for (int i = 0; i < 10; ++i) {
            int delStart = this.random.nextInt(tr.size() - 1) + tr.getStart();
            int delEnd = this.random.nextInt(tr.getEnd() - delStart) + delStart + 1;
            SeqChange seqChange = new SeqChange(tr.getChromosome(), delStart, delEnd, "");
            seqChange.setChangeType(SeqChange.ChangeType.DEL);
            Marker codingDel = cds.intersect(seqChange);
            if (codingDel == null) continue;
            int numBases = 0;
            for (Exon ex : tr) {
                numBases += codingDel.intersectSize(ex);
            }
            double perc = (double)numBases / (double)tr.cds().length();
            boolean delIsLof = perc > 0.5;
            LinkedList<ChangeEffect> changeEffects = this.changeEffects(seqChange, ChangeEffect.EffectType.TRANSCRIPT, tr);
            LossOfFunction lof = new LossOfFunction(changeEffects);
            boolean islof = lof.isLof();
            Assert.assertEquals((boolean)delIsLof, (boolean)islof);
        }
    }

    void checkLofFrameShift(Transcript tr) {
        Marker cds = this.cdsMarker(tr);
        int codingBase = 0;
        for (Exon ex : tr.sortedStrand()) {
            int start = tr.isStrandPlus() ? ex.getStart() : ex.getEnd();
            int step = tr.isStrandPlus() ? 1 : -1;
            int pos = start;
            while (ex.intersects(pos)) {
                SeqChange seqChange = new SeqChange(tr.getChromosome(), pos, pos, "");
                seqChange.setChangeType(this.random.nextBoolean() ? SeqChange.ChangeType.INS : SeqChange.ChangeType.DEL);
                LinkedList<ChangeEffect> changeEffects = this.changeEffects(seqChange, ChangeEffect.EffectType.FRAME_SHIFT, ex);
                ChangeEffect changeEffect = changeEffects.get(0);
                changeEffect.setCodons("", "", codingBase / 3, codingBase % 3);
                int aaLen = changeEffect.getAaLength();
                boolean isFsLof = false;
                if (cds.intersects(pos)) {
                    double perc = (double)(codingBase / 3) / (double)aaLen;
                    isFsLof = 0.05 <= perc && perc <= 0.95;
                    ++codingBase;
                }
                LossOfFunction lof = new LossOfFunction(changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals((boolean)isFsLof, (boolean)islof);
                pos += step;
            }
        }
    }

    void checkLofSplice(Transcript tr) {
        int exonNum = 0;
        for (Exon ex : tr.sortedStrand()) {
            this.checkSpliceDonor(tr, ex, exonNum);
            this.checkSpliceAcceptor(tr, ex, exonNum);
            ++exonNum;
        }
    }

    void checkLofStartLost(Transcript tr) {
        int pos = tr.getCdsStart();
        SeqChange seqChange = new SeqChange(tr.getChromosome(), pos, pos, "");
        Exon exon = null;
        for (Exon ex : tr) {
            if (!ex.intersects(pos)) continue;
            exon = ex;
        }
        if (exon == null) {
            throw new RuntimeEOFException("Cannot find first exon for transcript " + tr.getId());
        }
        LinkedList<ChangeEffect> changeEffects = this.changeEffects(seqChange, ChangeEffect.EffectType.START_LOST, exon);
        LossOfFunction lof = new LossOfFunction(changeEffects);
        boolean islof = lof.isLof();
        Assert.assertEquals((boolean)true, (boolean)islof);
    }

    void checkSpliceAcceptor(Transcript tr, Exon ex, int exonNum) {
        int step = tr.isStrandPlus() ? -1 : 1;
        int intronNum = exonNum - 1;
        if (ex.getRank() > 1) {
            int posDonor = tr.isStrandPlus() ? ex.getStart() : ex.getEnd();
            posDonor += step;
            int maxSize = Math.min(tr.intronSize(intronNum), 2);
            if (debug) {
                Gpr.debug("Intron size: " + tr.intronSize(intronNum));
            }
            if (maxSize <= 0) {
                throw new RuntimeEOFException("Max splice size is " + maxSize);
            }
            int pos = posDonor;
            int i = 0;
            while (i < maxSize) {
                SeqChange seqChange = new SeqChange(tr.getChromosome(), pos, pos, "");
                Marker marker = this.findMarker(seqChange, ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR, null, ex);
                LinkedList<ChangeEffect> changeEffects = this.changeEffects(seqChange, ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR, marker);
                if (debug) {
                    Gpr.debug("SeqChange:" + seqChange);
                }
                LossOfFunction lof = new LossOfFunction(changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals((boolean)true, (boolean)islof);
                ++i;
                pos += step;
            }
        }
    }

    void checkSpliceDonor(Transcript tr, Exon ex, int exonNum) {
        int step = tr.isStrandPlus() ? 1 : -1;
        int maxRank = tr.numChilds();
        int intronNum = exonNum;
        if (ex.getRank() < maxRank) {
            int posDonor = tr.isStrandPlus() ? ex.getEnd() : ex.getStart();
            posDonor += step;
            int maxSize = Math.min(tr.intronSize(intronNum), 2);
            if (debug) {
                Gpr.debug("Intron size: " + tr.intronSize(intronNum));
            }
            if (maxSize <= 0) {
                throw new RuntimeEOFException("Max splice size is " + maxSize);
            }
            int pos = posDonor;
            int i = 0;
            while (i < maxSize) {
                SeqChange seqChange = new SeqChange(tr.getChromosome(), pos, pos, "");
                Marker marker = this.findMarker(seqChange, ChangeEffect.EffectType.SPLICE_SITE_DONOR, null, ex);
                LinkedList<ChangeEffect> changeEffects = this.changeEffects(seqChange, ChangeEffect.EffectType.SPLICE_SITE_DONOR, marker);
                if (debug) {
                    Gpr.debug("SeqChange:" + seqChange);
                }
                LossOfFunction lof = new LossOfFunction(changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals((boolean)true, (boolean)islof);
                ++i;
                pos += step;
            }
        }
    }

    Marker findMarker(SeqChange seqChange, ChangeEffect.EffectType effectType, Transcript tr, Exon exon) {
        Markers markers = this.config.getSnpEffectPredictor().intersects(seqChange);
        for (Marker m : markers) {
            Exon mex = (Exon)m.findParent(Exon.class);
            Transcript mtr = (Transcript)m.findParent(Transcript.class);
            if (m.getType() != effectType || mex == null || mtr == null) continue;
            if (exon != null) {
                if (!mex.getId().equals(exon.getId())) continue;
                return m;
            }
            if (tr != null) {
                if (!mtr.getId().equals(tr.getId())) continue;
                return m;
            }
            return m;
        }
        throw new RuntimeEOFException("Cannot find '" + (Object)((Object)effectType) + "' " + (exon != null ? "for exon " + exon.getId() : "") + ", seqChange: " + seqChange);
    }

    public void test_01() {
        String genomeVer = "testHg3766Chr1";
        Gpr.debug("Loading database '" + genomeVer + "'");
        this.config = new Config(genomeVer, "snpEff.config");
        this.config.loadSnpEffectPredictor();
        Gpr.debug("Building forest");
        this.config.getSnpEffectPredictor().buildForest();
        Gpr.debug("Testing");
        int i = 1;
        for (Gene gene : this.config.getGenome().getGenes()) {
            Gpr.showMark(i++, 1);
            for (Transcript tr : gene) {
                if (debug) {
                    System.err.println(tr);
                }
                this.checkLof(tr);
            }
        }
    }
}

