/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerUtil;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

public class TestCasesIntervals
extends TestCase {
    int maxLen = 100;
    boolean verbose = true;
    boolean compareCdsTestsEnable = false;
    Random rand;
    Genome genome;

    public TestCasesIntervals() {
        this.initRand();
        String genomeName = "testCaseHg";
        this.genome = new Genome(genomeName);
        for (int i = 1; i < 22; ++i) {
            this.genome.add(new Chromosome(this.genome, 0, 0, 1, "" + i));
        }
        this.genome.add(new Chromosome(this.genome, 0, 0, 1, "X"));
        this.genome.add(new Chromosome(this.genome, 0, 0, 1, "Y"));
    }

    boolean anyResultMatches(String transcriptId, SeqChange seqChange, List<ChangeEffect> resultsList, boolean useSimple, StringBuilder resultsSoFar) {
        boolean ok = false;
        for (ChangeEffect chEff : resultsList) {
            String resStr = chEff.toStringSimple(!useSimple);
            if (this.verbose) {
                System.out.println(seqChange + "\t'" + resStr + "'");
            }
            String effTrId = chEff.getMarker().findParent(Transcript.class).getId();
            if (transcriptId != null && !transcriptId.equals(effTrId)) continue;
            if (!seqChange.getId().equals(resStr)) {
                if (this.verbose) {
                    Gpr.debug("SeqChange: " + seqChange + "\tResult: '" + chEff + "'");
                }
                resultsSoFar.append(seqChange + "\t'" + resStr + "'\n");
                continue;
            }
            ok = true;
            break;
        }
        return ok;
    }

    public void compareToFile(String result, String fileName) {
        String file = Gpr.readFile(fileName).trim();
        if (!(result = result.trim()).equals(file)) {
            String errMsg = "Results and file '" + fileName + "' do not match:\n--- Results ---\n" + result + "\n--- File '" + fileName + "' ---\n" + file + "\n--- End ---\n";
            System.err.println(errMsg);
            throw new RuntimeException(errMsg);
        }
    }

    public void DnaSequenceBaseAt(int len) {
        char[] bases = new char[len];
        for (int i = 0; i < bases.length; ++i) {
            char base;
            bases[i] = base = GprSeq.BASES[(int)(Math.random() * 4.0)];
        }
        String sequence = new String(bases);
        DnaSequence DnaSequence2 = new DnaSequence(sequence);
        System.out.println("DnaSequence (len:" + len + ") : " + DnaSequence2);
        for (int i = 0; i < bases.length; ++i) {
            char base = Character.toUpperCase(DnaSequence2.getBase(i));
            if (base == bases[i]) continue;
            throw new RuntimeException("Bases do not match! Base:" + base + "\tOriginal sequence: " + bases[i]);
        }
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    public Markers intersects(Markers interval1, Marker intervals) {
        Markers ints = new Markers();
        for (Marker i : interval1) {
            if (!i.intersects(intervals)) continue;
            ints.add(i);
        }
        return ints;
    }

    public Markers randomIntervals(int numIntervals, int maxStart, int maxLength, int numChromo) {
        Markers ints = new Markers();
        for (int ch = 1; ch <= numChromo; ++ch) {
            for (int i = 0; i < numIntervals; ++i) {
                int start = this.rand.nextInt(maxStart);
                int end = Math.min(start + this.rand.nextInt(maxLength), maxStart - 1);
                Marker interval = new Marker(this.genome.getChromosome("" + ch), start, end, 1, "");
                ints.add(interval);
            }
        }
        return ints;
    }

    public void test_00() {
        this.initRand();
        for (int len = 1; len < 1000; ++len) {
            this.DnaSequenceBaseAt(len);
        }
    }

    public void test_01() {
        this.initRand();
        Markers intervals = MarkerUtil.readTxt("tests/interval_data_100.txt", this.genome, 0);
        this.compareToFile(intervals.toStringTxt(), "tests/test_01.txt");
    }

    public void test_02() {
        this.initRand();
        Markers intervals = this.randomIntervals(10, this.maxLen, 10, 5);
        intervals.sort(false, false);
        this.compareToFile(intervals.toStringTxt(), "tests/test_02.txt");
    }

    public void test_03() {
        this.initRand();
        Markers intervals = this.randomIntervals(100, this.maxLen, 25, 2);
        intervals.sort(true, false);
        this.compareToFile(intervals.toStringTxt(), "tests/test_03.txt");
    }

    public void test_04() {
        this.initRand();
        Markers intervals = this.randomIntervals(20, this.maxLen, 10, 2);
        Markers merge = intervals.merge();
        if (this.verbose) {
            System.out.println("Merge :\n" + merge.toStringAsciiArt(this.maxLen));
        }
        this.compareToFile(merge.toStringTxt(), "tests/test_04.txt");
    }

    public void test_05() {
        this.initRand();
        Markers intervals = this.randomIntervals(5, this.maxLen, 10, 2);
        Markers intervals2 = this.randomIntervals(5, this.maxLen, 10, 2);
        Markers add = new Markers();
        add.add(intervals);
        add.add(intervals2);
        this.compareToFile(add.toStringTxt(), "tests/test_05.txt");
        if (this.verbose) {
            intervals.sort(false, false);
            intervals2.sort(false, false);
            add.sort(false, false);
            System.out.println("Intervals 1:\n" + intervals.toStringAsciiArt(this.maxLen));
            System.out.println("Intervals 2:\n" + intervals2.toStringAsciiArt(this.maxLen));
            System.out.println("Union :\n" + add.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_06() {
        for (int numInts = 10; numInts < 1000; numInts *= 2) {
            Markers intervals = this.randomIntervals(numInts, this.maxLen, 20, 2);
            IntervalForest forest = new IntervalForest(intervals);
            if (this.verbose) {
                intervals.sort(false, false);
                System.out.println(intervals.toStringAsciiArt(this.maxLen));
                forest.build();
                System.out.println(forest);
            }
            Markers intervals2 = this.randomIntervals(numInts, this.maxLen, 20, 2);
            for (Marker i : intervals2) {
                Markers intersectBf;
                Markers intersect = forest.query(i);
                if (intersect.equals(intersectBf = this.intersects(intervals, i))) continue;
                intersect.sort(false, false);
                intersectBf.sort(false, false);
                String errMsg = "Interval: " + i + "\n\tIntersects  : " + intersect + "\n\tIntersectsBf: " + intersectBf;
                System.err.println(errMsg);
                throw new RuntimeException(errMsg);
            }
        }
    }

    public void test_07_01() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 10, 90, 1, ""));
        Markers minus = intervals.minus(intervals2);
        TestCasesIntervals.assertEquals((int)0, (int)minus.size());
        if (this.verbose) {
            System.out.println(minus.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_07_02() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 9, 91, 1, ""));
        Markers minus = intervals.minus(intervals2);
        TestCasesIntervals.assertEquals((int)0, (int)minus.size());
        if (this.verbose) {
            System.out.println(minus.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_07_03() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 9, 50, 1, ""));
        Markers minus = intervals.minus(intervals2);
        TestCasesIntervals.assertEquals((int)1, (int)minus.size());
        Marker minusInt = minus.iterator().next();
        TestCasesIntervals.assertEquals((int)51, (int)minusInt.getStart());
        TestCasesIntervals.assertEquals((int)90, (int)minusInt.getEnd());
        if (this.verbose) {
            System.out.println(minus.toStringAsciiArt(this.maxLen));
        }
    }

    public void test_07_04() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 51, 91, 1, ""));
        Markers minus = intervals.minus(intervals2);
        if (this.verbose) {
            System.out.println(minus.toStringAsciiArt(this.maxLen));
        }
        TestCasesIntervals.assertEquals((int)1, (int)minus.size());
        Marker minusInt = minus.iterator().next();
        TestCasesIntervals.assertEquals((int)10, (int)minusInt.getStart());
        TestCasesIntervals.assertEquals((int)50, (int)minusInt.getEnd());
    }

    public void test_07_05() {
        Chromosome chr = this.genome.getChromosome("1");
        Markers intervals = new Markers();
        intervals.add(new Marker(chr, 10, 90, 1, ""));
        Markers intervals2 = new Markers();
        intervals2.add(new Marker(chr, 40, 60, 1, ""));
        Markers minus = intervals.minus(intervals2);
        if (this.verbose) {
            System.out.println(minus.toStringAsciiArt(this.maxLen));
        }
        TestCasesIntervals.assertEquals((int)2, (int)minus.size());
        Iterator<Marker> it = minus.iterator();
        Marker minusInt = it.next();
        TestCasesIntervals.assertEquals((int)10, (int)minusInt.getStart());
        TestCasesIntervals.assertEquals((int)39, (int)minusInt.getEnd());
        minusInt = it.next();
        TestCasesIntervals.assertEquals((int)61, (int)minusInt.getStart());
        TestCasesIntervals.assertEquals((int)90, (int)minusInt.getEnd());
    }
}

