/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.fileIterator.FileIterator;
import ca.mcgill.mcb.pcingola.ped.PedEntry;
import ca.mcgill.mcb.pcingola.ped.PlinkMap;
import ca.mcgill.mcb.pcingola.ped.Sex;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;

public class PedFileIterator
extends FileIterator<PedEntry> {
    PlinkMap plinkMap = new PlinkMap();

    public PedFileIterator(String fileName, String mapFileName) {
        super(fileName);
        this.plinkMap.read(mapFileName);
    }

    public PlinkMap getPlinkMap() {
        return this.plinkMap;
    }

    PedEntry parseLine(String line) {
        String[] fields = line.split("\\s");
        int fieldNum = 0;
        String familyId = fields[fieldNum++];
        String id = fields[fieldNum++];
        String fatherId = fields[fieldNum++];
        String motherId = fields[fieldNum++];
        int sexnum = Gpr.parseIntSafe(fields[fieldNum++]);
        Sex sex = Sex.Unknown;
        if (sexnum == 1) {
            sex = Sex.Male;
        } else if (sexnum == 2) {
            sex = Sex.Female;
        }
        String phenotype = fields[fieldNum++];
        if (phenotype.equals("0") || phenotype.equals("-9")) {
            phenotype = "";
        }
        String[] genotypes = new String[fields.length - fieldNum];
        int j = 0;
        int i = fieldNum;
        while (i < fields.length) {
            genotypes[j] = fields[i];
            ++i;
            ++j;
        }
        return new PedEntry(this.plinkMap, familyId, id, fatherId, motherId, sex, phenotype, genotypes);
    }

    @Override
    protected PedEntry readNext() {
        try {
            if (this.reader.ready()) {
                this.line = this.reader.readLine();
                if (this.line != null) {
                    ++this.lineNum;
                    PedEntry pedEntry = this.parseLine(this.line);
                    if (pedEntry != null) {
                        return pedEntry;
                    }
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }
}

