/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.filter.ChangeEffectFilter;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import java.util.ArrayList;

public abstract class OutputFormatter {
    boolean supressOutput = false;
    boolean showHeader = true;
    int sectionNum = 0;
    int outOffset = 1;
    String commandLineStr;
    String version;
    String chrStr;
    Marker section;
    ChangeEffectFilter changeEffectResutFilter = null;
    ArrayList<ChangeEffect> changeEffects = new ArrayList();

    public void add(ChangeEffect changeEffect) {
        if (this.changeEffectResutFilter == null || !this.changeEffectResutFilter.filter(changeEffect)) {
            this.changeEffects.add(changeEffect);
        }
    }

    public OutputFormatter clone() {
        OutputFormatter newOutputFormatter = null;
        try {
            newOutputFormatter = (OutputFormatter)this.getClass().newInstance();
            newOutputFormatter.supressOutput = this.supressOutput;
            newOutputFormatter.showHeader = this.showHeader;
            newOutputFormatter.sectionNum = this.sectionNum;
            newOutputFormatter.outOffset = this.outOffset;
            newOutputFormatter.commandLineStr = this.commandLineStr;
            newOutputFormatter.version = this.version;
            newOutputFormatter.chrStr = this.chrStr;
            newOutputFormatter.section = this.section;
            newOutputFormatter.changeEffectResutFilter = this.changeEffectResutFilter;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newOutputFormatter;
    }

    public String endSection(Marker marker) {
        StringBuilder sb = null;
        if (!this.supressOutput) {
            String header;
            sb = new StringBuilder();
            if (this.showHeader && this.sectionNum == 0 && !(header = this.toStringHeader()).isEmpty()) {
                sb.append(header);
                sb.append("\n");
            }
            sb.append(this.toString());
        }
        ++this.sectionNum;
        this.changeEffects.clear();
        if (this.supressOutput) {
            return null;
        }
        return sb.toString();
    }

    public void printSection(Marker marker) {
        String outStr = this.endSection(marker);
        if (outStr != null && !outStr.isEmpty()) {
            System.out.println(outStr);
        }
    }

    public void setChangeEffectResutFilter(ChangeEffectFilter changeEffectResutFilter) {
        this.changeEffectResutFilter = changeEffectResutFilter;
    }

    public void setChrStr(String chrStr) {
        this.chrStr = chrStr;
    }

    public void setCommandLineStr(String commandLineStr) {
        this.commandLineStr = commandLineStr;
    }

    public void setOutOffset(int outOffset) {
        this.outOffset = outOffset;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public void setSupressOutput(boolean supressOutput) {
        this.supressOutput = supressOutput;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void startSection(Marker marker) {
        this.section = marker;
    }

    public String toString() {
        throw new RuntimeException("Method toString() must be overridden!");
    }

    protected abstract String toStringHeader();
}

