/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.ArrayList;
import java.util.List;

public class CodonChangeMnp
extends CodonChange {
    int cdsStart;
    int cdsEnd;

    public CodonChangeMnp(SeqChange seqChange, Transcript transcript, ChangeEffect changeEffect) {
        super(seqChange, transcript, changeEffect);
        this.returnNow = false;
        this.requireNetCdsChange = true;
    }

    int cdsBaseNumber(int pos, boolean usePrevBaseIntron) {
        if (pos < this.cdsStart) {
            return this.transcript.isStrandPlus() ? 0 : this.transcript.cds().length() - 1;
        }
        if (pos > this.cdsEnd) {
            return this.transcript.isStrandPlus() ? this.transcript.cds().length() - 1 : 0;
        }
        return this.transcript.cdsBaseNumber(pos, usePrevBaseIntron);
    }

    @Override
    List<ChangeEffect> codonChange() {
        ArrayList<ChangeEffect> changes = new ArrayList<ChangeEffect>();
        if (!this.transcript.intersects(this.seqChange)) {
            return changes;
        }
        this.cdsStart = this.transcript.isStrandPlus() ? this.transcript.getCdsStart() : this.transcript.getCdsEnd();
        int n = this.cdsEnd = this.transcript.isStrandPlus() ? this.transcript.getCdsEnd() : this.transcript.getCdsStart();
        if (this.cdsStart > this.seqChange.getEnd()) {
            return changes;
        }
        if (this.cdsEnd < this.seqChange.getStart()) {
            return changes;
        }
        int scStart = this.cdsBaseNumber(this.seqChange.getStart(), false);
        int scEnd = this.cdsBaseNumber(this.seqChange.getEnd(), true);
        if (this.transcript.isStrandPlus()) {
            scStart = this.cdsBaseNumber(this.seqChange.getStart(), false);
            scEnd = this.cdsBaseNumber(this.seqChange.getEnd(), true);
        } else {
            scEnd = this.cdsBaseNumber(this.seqChange.getStart(), true);
            scStart = this.cdsBaseNumber(this.seqChange.getEnd(), false);
        }
        int scLen = scEnd - scStart;
        if (scLen < 0) {
            return changes;
        }
        int scStart3 = this.round3(scStart, false);
        int scEnd3 = this.round3(scEnd, true);
        if (scEnd3 == scStart3) {
            scEnd3 += 3;
        }
        String padN = "";
        int diff = scEnd3 - (this.transcript.cds().length() - 1);
        if (diff > 0) {
            scEnd3 = this.transcript.cds().length() - 1;
            if (diff == 1) {
                padN = "N";
            } else if (diff == 2) {
                padN = "NN";
            } else {
                throw new RuntimeException("Sanity check failed. Number of 'N' pading is :" + diff + ". This should not happen!");
            }
        }
        this.codonsOld = this.transcript.cds().substring(scStart3, scEnd3 + 1);
        String prepend = this.codonsOld.substring(0, scStart - scStart3);
        String append = "";
        if (scEnd3 > scEnd) {
            append = this.codonsOld.substring(this.codonsOld.length() - (scEnd3 - scEnd));
        }
        this.codonsNew = prepend + this.netCdsChange() + append;
        this.codonsOld = this.codonsOld + padN;
        this.codonsNew = this.codonsNew + padN;
        ChangeEffect changeEffectNew = this.changeEffect.clone();
        changeEffectNew.set(this.transcript, ChangeEffect.EffectType.CODON_CHANGE, "");
        changeEffectNew.setCodons(this.codonsOld, this.codonsNew, this.codonNum, this.codonIndex);
        changes.add(changeEffectNew);
        return changes;
    }

    @Override
    protected String netCdsChange() {
        if (this.seqChange.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Exon exon : this.transcript.sortedStrand()) {
                String seq = this.seqChange.netChange(exon);
                sb.append(exon.isStrandPlus() ? seq : GprSeq.reverseWc(seq));
            }
            return sb.toString();
        }
        return this.seqChange.netChange(this.transcript.getStrand());
    }

    int round3(int num, boolean end) {
        if (end) {
            if (num % 3 == 2) {
                return num;
            }
            return num / 3 * 3 + 2;
        }
        if (num % 3 == 0) {
            return num;
        }
        return num / 3 * 3;
    }
}

