/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.tree.IntervalForest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Markers
implements Iterable<Marker>,
Serializable {
    private static final long serialVersionUID = 259791388087691277L;
    protected ArrayList<Marker> markers;
    protected String name = "";

    public Markers() {
        this.markers = new ArrayList();
    }

    public Markers(Collection otherMarkers) {
        this.markers = new ArrayList();
        this.addAll(otherMarkers);
    }

    public Markers(Markers otherMarkers) {
        this.markers = new ArrayList();
        this.addAll(otherMarkers.getMarkers());
    }

    public Markers(String name) {
        this.name = name;
        this.markers = new ArrayList();
    }

    public Markers add(Marker marker) {
        this.markers.add(marker);
        return this;
    }

    public Markers add(Markers intervalsMarkerIntervaloAdd) {
        this.markers.addAll(intervalsMarkerIntervaloAdd.markers);
        return this;
    }

    public Markers addAll(Collection<? extends Marker> mm) {
        for (Marker marker : mm) {
            this.markers.add(marker);
        }
        return this;
    }

    public boolean equals(Markers intervals) {
        if (intervals == null) {
            return false;
        }
        if (this.size() != intervals.size()) {
            return false;
        }
        this.sort(false, false);
        intervals.sort(false, false);
        Iterator<Marker> it1 = this.iterator();
        Iterator<Marker> it2 = intervals.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Interval i2;
            Interval i1 = it1.next();
            if (i1.equals(i2 = (Interval)it2.next())) continue;
            return false;
        }
        return true;
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    public String getName() {
        return this.name;
    }

    public Markers intersect() {
        Markers intersectOfOverlaps = new Markers();
        IntervalForest forest = new IntervalForest(this);
        HashSet<Marker> done = new HashSet<Marker>();
        for (Marker mi : this) {
            if (done.contains(mi)) continue;
            Markers query = forest.query(mi);
            Marker intersect = new Marker(mi.getParent(), mi.getStart(), mi.getEnd(), mi.getStrand(), "");
            done.add(mi);
            for (Marker m : query) {
                if (intersect != null && (intersect.getStart() < m.getStart() || intersect.getEnd() > m.getEnd())) {
                    intersect = intersect.intersect(m);
                }
                done.add(m);
            }
            if (intersect == null) continue;
            intersectOfOverlaps.add(intersect);
        }
        return intersectOfOverlaps;
    }

    public boolean isEmpty() {
        return this.markers.isEmpty();
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.markers.iterator();
    }

    public Markers merge() {
        Markers intsSorted = new Markers();
        intsSorted.add(this);
        intsSorted.sort(false, false);
        Markers intsMerged = new Markers();
        String tag = "";
        String chromoName = "";
        Chromosome chromo = null;
        int start = -1;
        int end = -1;
        for (Marker i : intsSorted) {
            Marker im;
            Chromosome ichromo = i.getChromosome();
            String ichromoName = ichromo.getId();
            if (!chromoName.equals(ichromoName)) {
                if (start >= 0 && end >= 0) {
                    im = new Marker(chromo, start, end, 1, tag);
                    intsMerged.add(im);
                }
                chromoName = ichromoName;
                chromo = ichromo;
                end = -1;
                start = -1;
                tag = "";
            }
            if (i.start > end) {
                if (start >= 0 && end >= 0) {
                    im = new Marker(chromo, start, end, 1, tag);
                    intsMerged.add(im);
                }
                end = -1;
                start = -1;
                tag = "";
            }
            if (start < 0) {
                start = i.start;
            }
            end = Math.max(end, i.end);
            if (tag.length() <= 0) {
                tag = i.id;
                continue;
            }
            tag = tag + " " + i.id;
        }
        if (start >= 0 && end >= 0) {
            Marker im = new Marker(chromo, start, end, 1, tag);
            intsMerged.add(im);
        }
        return intsMerged;
    }

    public Markers minus(Marker interval) {
        Markers ints = new Markers();
        for (Marker i : this) {
            if (i.intersects(interval)) {
                if (interval.getStart() <= i.getStart() && i.getEnd() <= interval.getEnd()) continue;
                if (interval.getStart() <= i.getStart() && interval.getEnd() < i.getEnd()) {
                    ints.add(new Marker(i.getParent(), interval.getEnd() + 1, i.getEnd(), i.getStrand(), i.getId()));
                    continue;
                }
                if (i.getStart() < interval.getStart() && i.getEnd() <= interval.getEnd()) {
                    ints.add(new Marker(i.getParent(), i.getStart(), interval.getStart() - 1, i.getStrand(), i.getId()));
                    continue;
                }
                if (i.getStart() < interval.getStart() && interval.getEnd() < i.getEnd()) {
                    ints.add(new Marker(i.getParent(), i.getStart(), interval.getStart() - 1, i.getStrand(), i.getId()));
                    ints.add(new Marker(i.getParent(), interval.getEnd() + 1, i.getEnd(), i.getStrand(), i.getId()));
                    continue;
                }
                throw new RuntimeException("Interval intersection not analysed. This should nbever happen!");
            }
            ints.add(i);
        }
        return ints;
    }

    public Markers minus(Markers intervals) {
        Markers result = new Markers();
        result.add(this);
        for (Marker j : intervals) {
            result = result.minus(j);
        }
        return result;
    }

    public Interval rand() {
        int idx = (int)(Math.random() * (double)this.markers.size());
        return this.markers.get(idx);
    }

    public int size() {
        return this.markers.size();
    }

    public Markers sort(boolean byEnd, boolean reverse) {
        if (byEnd) {
            Collections.sort(this.markers, new IntervalComparatorByEnd(reverse));
        } else {
            Collections.sort(this.markers, new IntervalComparatorByStart(reverse));
        }
        return this;
    }

    public String toString() {
        int num = 1;
        StringBuilder sb = new StringBuilder();
        for (Marker i : this) {
            sb.append("\t" + num++ + ":\t" + i.getChromosomeName() + "\t" + i.getStart() + "\t" + i.getEnd() + "\t" + i.getClass().getSimpleName() + "\t" + i.getId() + "\n");
        }
        return sb.toString();
    }

    public String toStringAsciiArt(int maxLen) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (int i = 0; i < maxLen; ++i) {
            sep = sep + "=";
        }
        String ch = "";
        for (Marker i : this) {
            if (!i.getChromosomeName().equals(ch)) {
                sb.append("|" + sep + "|\n");
                ch = i.getChromosomeName();
            }
            sb.append("|" + i.toStringAsciiArt(maxLen) + "|\t" + i.getChromosomeName() + ": [" + i.start + " - " + i.end + "] ");
            if (i.id != null && i.id.length() > 0) {
                sb.append("'" + i.id + "'");
            }
            sb.append("\n");
        }
        sb.append("|" + sep + "|\n");
        return sb.toString();
    }

    public String toStringTxt() {
        StringBuilder sb = new StringBuilder();
        for (Marker i : this) {
            sb.append(i.getChromosomeName() + "\t" + i.getStart() + "\t" + i.getEnd() + "\t" + i.getId() + "\n");
        }
        return sb.toString();
    }

    public Markers union() {
        Markers unionOfOverlaps = new Markers();
        IntervalForest forest = new IntervalForest(this);
        HashSet<Marker> done = new HashSet<Marker>();
        for (Marker mi : this) {
            if (done.contains(mi)) continue;
            Markers query = forest.query(mi);
            Marker union = new Marker(mi.getParent(), mi.getStart(), mi.getEnd(), mi.getStrand(), "");
            done.add(mi);
            for (Marker m : query) {
                if (union != null && union.getStart() > m.getStart() || union.getEnd() < m.getEnd()) {
                    union = union.union(m);
                }
                done.add(m);
            }
            if (union == null) continue;
            unionOfOverlaps.add(union);
        }
        return unionOfOverlaps;
    }

    public Markers unique() {
        HashSet<Marker> set = new HashSet<Marker>();
        set.addAll(this.markers);
        this.markers = new ArrayList();
        this.markers.addAll(set);
        return this;
    }
}

