/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.fileIterator.FastaFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genes;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class Genome
extends Marker
implements Serializable,
Iterable<Chromosome> {
    private static final long serialVersionUID = -330362012383572257L;
    long length = -1L;
    String species;
    String version;
    String fastaDir;
    ArrayList<String> chromosomeNames;
    ArrayList<String> chromosomeNamesSorted = null;
    String[] chromoFastaFiles;
    HashMap<String, Chromosome> chromosomes;
    Genes genes;
    Boolean codingInfo = null;

    public static Genome createFromFaidx(String genomeName, String faidxFile) {
        String[] lines;
        Genome genome = new Genome(genomeName);
        for (String line : lines = Gpr.readFile(faidxFile).split("\n")) {
            String[] vals = line.split("\t");
            String chrName = vals[0];
            int len = Gpr.parseIntSafe(vals[1]);
            Chromosome chromosome = new Chromosome(genome, 0, len, 1, chrName);
            genome.add(chromosome);
        }
        return genome;
    }

    public Genome() {
        this.version = "";
        this.type = ChangeEffect.EffectType.GENOME;
        this.chromosomeNames = new ArrayList();
        this.chromosomes = new HashMap();
        this.genes = new Genes(this);
    }

    public Genome(String version) {
        super(null, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, version);
        this.version = version;
        this.type = ChangeEffect.EffectType.GENOME;
        this.chromosomeNames = new ArrayList();
        this.chromosomes = new HashMap();
        this.genes = new Genes(this);
    }

    public Genome(String version, Properties properties) {
        super(null, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, version);
        this.version = version;
        this.type = ChangeEffect.EffectType.GENOME;
        this.genes = new Genes(this);
        this.species = properties.getProperty(version + ".genome");
        if (this.species == null) {
            throw new RuntimeException("Property: '" + version + ".genome' not found");
        }
        this.species = this.species.trim();
        this.chromosomeNames = new ArrayList();
        String[] chromosomeNames = this.propertyToStringArray(properties, version + ".chromosomes");
        this.fastaDir = properties.getProperty(version + ".fasta_dir") != null ? properties.getProperty(version + ".fasta_dir").trim() : "";
        this.chromoFastaFiles = properties.getProperty(version + ".chromo_fasta_files") != null ? this.propertyToStringArray(properties, version + ".chromo_fasta_files") : new String[0];
        this.chromosomes = new HashMap();
        for (String chName : chromosomeNames) {
            this.add(new Chromosome(this, 0, 0, 0, chName));
        }
    }

    public Genome(String species, String version) {
        super(null, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, version);
        this.species = species;
        this.version = version;
        this.type = ChangeEffect.EffectType.GENOME;
        this.chromosomeNames = new ArrayList();
        this.chromoFastaFiles = new String[0];
        this.chromosomes = new HashMap();
    }

    public synchronized void add(Chromosome chromo) {
        this.chromosomeNames.add(chromo.getId());
        this.chromosomes.put(chromo.getId(), chromo);
    }

    public List<String> chromosomeNamesSorted() {
        if (this.chromosomeNamesSorted != null) {
            return this.chromosomeNamesSorted;
        }
        ArrayList<Chromosome> chromosArr = new ArrayList<Chromosome>(this.chromosomes.size());
        chromosArr.addAll(this.chromosomes.values());
        Collections.sort(chromosArr);
        this.chromosomeNamesSorted = new ArrayList();
        for (int i = 0; i < chromosArr.size(); ++i) {
            this.chromosomeNamesSorted.add(((Chromosome)chromosArr.get(i)).getId());
        }
        return this.chromosomeNamesSorted;
    }

    synchronized Chromosome createChromosome(String chromoName) {
        Chromosome chr = this.getChromosome(chromoName);
        if (chr != null) {
            return chr;
        }
        chr = new Chromosome(this, 0, 0, 1, chromoName);
        this.add(chr);
        return chr;
    }

    public String[] getChromoFastaFiles() {
        return this.chromoFastaFiles;
    }

    public Chromosome getChromosome(String chromoName) {
        String ch = Chromosome.simpleName(chromoName);
        return this.chromosomes.get(ch);
    }

    public String[] getChromosomeNames() {
        return this.chromosomeNames.toArray(new String[0]);
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomes.values();
    }

    public List<Chromosome> getChromosomesSortedSize() {
        ArrayList<Chromosome> chrs = new ArrayList<Chromosome>();
        chrs.addAll(this.chromosomes.values());
        Collections.sort(chrs, new Comparator<Chromosome>(){

            @Override
            public int compare(Chromosome chr1, Chromosome chr2) {
                int cmp = chr2.size() - chr1.size();
                if (cmp != 0) {
                    return cmp;
                }
                return chr1.getId().compareTo(chr2.getId());
            }
        });
        return chrs;
    }

    public String getFastaDir() {
        return this.fastaDir;
    }

    public Genes getGenes() {
        return this.genes;
    }

    public List<Gene> getGenesSorted() {
        ArrayList<Gene> genesSorted = new ArrayList<Gene>();
        genesSorted.addAll(this.genes.values());
        Collections.sort(genesSorted, new Comparator<Gene>(){

            @Override
            public int compare(Gene gene1, Gene gene2) {
                return gene1.getId().compareTo(gene2.getId());
            }
        });
        return genesSorted;
    }

    public List<Gene> getGenesSortedPos() {
        ArrayList<Gene> genesSorted = new ArrayList<Gene>();
        genesSorted.addAll(this.genes.values());
        Collections.sort(genesSorted);
        return genesSorted;
    }

    public Chromosome getOrCreateChromosome(String chromoName) {
        Chromosome chr = this.getChromosome(chromoName);
        if (chr == null) {
            chr = this.createChromosome(chromoName);
        }
        return chr;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasChromosome(String chromo) {
        for (String ch : this.chromosomeNames) {
            if (!ch.equals(chromo)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCodingInfo() {
        if (this.codingInfo == null) {
            int countCoding = 0;
            for (Gene gene : this.genes) {
                if (!gene.isProteinCoding()) continue;
                ++countCoding;
            }
            this.codingInfo = countCoding != 0;
        }
        return this.codingInfo;
    }

    public boolean isMostExonsHaveSequence() {
        int exonSeq = 0;
        int exonNoSeq = 0;
        for (Gene g : this.getGenes()) {
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    if (e.getSequence().isEmpty()) {
                        ++exonNoSeq;
                        continue;
                    }
                    ++exonSeq;
                }
            }
        }
        return exonSeq < exonNoSeq;
    }

    @Override
    public Iterator<Chromosome> iterator() {
        return this.chromosomes.values().iterator();
    }

    public long length() {
        if (this.length <= 0L) {
            this.length = 0L;
            for (Chromosome chr : this.chromosomes.values()) {
                this.length += (long)(chr.getEnd() - chr.getStart() + 1);
            }
        }
        return this.length;
    }

    String[] propertyToStringArray(Properties properties, String attr) {
        String value = properties.getProperty(attr);
        if (value == null) {
            return new String[0];
        }
        String[] values = value.split("[\\s+,]");
        LinkedList<String> list = new LinkedList<String>();
        for (String val : values) {
            if (val.length() <= 0) continue;
            list.add(val);
        }
        return list.toArray(new String[0]);
    }

    public boolean readGenomeSequence(String fastaFile) {
        FastaFileIterator ffi = new FastaFileIterator(fastaFile);
        for (String seq : ffi) {
            String chrName = ffi.getName();
            Chromosome chromosome = this.getChromosome(chrName);
            if (chromosome != null) {
                chromosome.setSequence(seq);
                continue;
            }
            chromosome = new Chromosome(this, 0, seq.length(), 1, chrName);
            chromosome.setSequence(seq);
            this.add(chromosome);
        }
        return true;
    }

    public void remove(Chromosome chromo) {
        this.chromosomeNames.remove(chromo.getId());
        this.chromosomes.remove(chromo.getId());
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.version = markerSerializer.getNextField();
        this.species = markerSerializer.getNextField();
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.add((Chromosome)m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.version + "\t" + this.species + "\t" + markerSerializer.save(this.chromosomes.values());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int exonSeq = 0;
        int exonNoSeq = 0;
        int countGenes = 0;
        int countGenesProteinCoding = 0;
        int countTranscripts = 0;
        int countTranscriptsProteinCoding = 0;
        int countExons = 0;
        int countCds = 0;
        Genes genes = this.getGenes();
        for (Gene g : genes) {
            ++countGenes;
            if (g.isProteinCoding()) {
                ++countGenesProteinCoding;
            }
            for (Transcript tr : g) {
                if (tr.isProteinCoding()) {
                    ++countTranscriptsProteinCoding;
                }
                int numCds = tr.getCds().size();
                int numExons = tr.subintervals().size();
                ++countTranscripts;
                countExons += numExons;
                countCds += numCds;
                for (Exon e : tr) {
                    if (e.getSequence().isEmpty()) {
                        ++exonNoSeq;
                        continue;
                    }
                    ++exonSeq;
                }
            }
        }
        double avgTrPerGene = (double)countTranscripts / (double)countGenes;
        double avgExonPerTr = (double)countExons / (double)countTranscripts;
        sb.append("# Genome name                : '" + this.species + "'" + "\n");
        sb.append("# Genome version             : '" + this.version + "'\n");
        sb.append("# Has protein coding info    : " + this.hasCodingInfo() + "\n");
        sb.append("# Genes                      : " + countGenes + "\n");
        sb.append("# Protein coding genes       : " + countGenesProteinCoding + "\n");
        sb.append("# Transcripts                : " + countTranscripts + "\n");
        sb.append(String.format("# Avg. transcripts per gene  : %.2f", avgTrPerGene) + "\n");
        sb.append("# Protein coding transcripts : " + countTranscriptsProteinCoding + "\n");
        sb.append("# Cds                        : " + countCds + "\n");
        sb.append("# Exons                      : " + countExons + "\n");
        sb.append("# Exons with sequence        : " + exonSeq + "\n");
        sb.append("# Exons without sequence     : " + exonNoSeq + "\n");
        sb.append(String.format("# Avg. exons per transcript  : %.2f", avgExonPerTr) + "\n");
        sb.append("# Number of chromosomes      : " + this.getChromosomes().size() + "\n");
        sb.append("# Chromosomes names [sizes]  : ");
        for (Chromosome chr : this.getChromosomesSortedSize()) {
            sb.append("'" + chr.getId() + "' [" + chr.size() + "]\t");
        }
        return sb.toString();
    }
}

