/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SageUtil {
    private static Logger sLogger = Logger.getLogger(SageUtil.class);
    private static final String PRP_SAGE_ENVIRONMENT = "SAGE_ENVIRONMENT";

    public static void setupSage(Properties globalProperties) {
        String env = "null";
        if (globalProperties.containsKey(PRP_SAGE_ENVIRONMENT)) {
            String envStr = globalProperties.getProperty(PRP_SAGE_ENVIRONMENT);
            if (envStr.equalsIgnoreCase("dev")) {
                env = "dev";
            } else if (envStr.equalsIgnoreCase("prod")) {
                env = envStr;
            }
        }
        sLogger.debug((Object)String.format("JVM system property %s=%s", "edu_mayo_bsu_sage_env", env));
        System.setProperty("edu_mayo_bsu_sage_env", env);
    }

    public static Map<String, Object> toSageMap(CommandLine line) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        block4: for (Option opt : line.getOptions()) {
            String key = "OPT_" + opt.getOpt();
            switch (opt.getArgs()) {
                case -1: 
                case 0: {
                    m.put(key, "true");
                    continue block4;
                }
                case 1: {
                    m.put(key, line.getOptionValue(opt.getOpt()));
                    continue block4;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    for (String value : line.getOptionValues(opt.getOpt())) {
                        sb.append(value);
                        sb.append('|');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    m.put(key, sb.toString());
                }
            }
        }
        String[] args = line.getArgs();
        for (int i = 1; i <= args.length; ++i) {
            String key = "ARG_" + i;
            m.put(key, args[i - 1]);
        }
        return m;
    }
}

