/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class PropertiesUtil {
    public static Properties loadProps(String classpathLocation) throws IOException {
        Properties props = new Properties();
        InputStream inStream = ClassLoader.getSystemClassLoader().getResourceAsStream(classpathLocation);
        if (inStream == null) {
            throw new FileNotFoundException(String.format("Could not find %s on classpath", classpathLocation));
        }
        props.load(inStream);
        return props;
    }

    public static Properties loadPropsFromResourceBundle(ResourceBundle bundle) {
        Properties props = new Properties();
        for (String key : bundle.keySet()) {
            String val = bundle.getString(key);
            props.put(key, val);
        }
        return props;
    }

    public static Properties mergeProperties(Properties ... props) {
        Properties merged = new Properties();
        for (Properties p : props) {
            for (String name : p.stringPropertyNames()) {
                String value = p.getProperty(name);
                merged.setProperty(name, value);
            }
        }
        return merged;
    }

    public static ResourceBundle getBundle(String pluginClassName) throws ClassNotFoundException {
        Class<?> pluginClass = Class.forName(pluginClassName);
        return ResourceBundle.getBundle("cli." + pluginClass.getSimpleName(), Locale.getDefault());
    }
}

