/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.test;

import com.google.common.io.Files;
import edu.mayo.pipes.util.test.PipeTestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.junit.Assert;

public class FileCompareUtils {
    public static final String EOL = System.getProperty("line.separator");

    public static void assertFileEquals(String fileExpected, String fileActual) throws Exception {
        List linesExpected = Files.readLines((File)new File(fileExpected), (Charset)Charset.forName("UTF-8"));
        List linesActual = Files.readLines((File)new File(fileActual), (Charset)Charset.forName("UTF-8"));
        PipeTestUtils.assertListsEqual(linesExpected, linesActual);
        Assert.assertEquals((String)"There should be the same number of variants in the output as were in the input.  ", (long)Files.readLines((File)new File(fileExpected), (Charset)Charset.forName("UTF-8")).size(), (long)Files.readLines((File)new File(fileActual), (Charset)Charset.forName("UTF-8")).size());
    }

    public static void saveToFile(ArrayList<String> lines, String filePath) throws IOException {
        StringBuilder str = new StringBuilder();
        for (String line : lines) {
            str.append(line);
            str.append(EOL);
        }
        Files.write((byte[])str.toString().getBytes(), (File)new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadFile(String filePath) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader fin = null;
        try {
            fin = FileCompareUtils.isZippedInput(filePath) ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filePath)))) : new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            String line = null;
            while ((line = fin.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return lines;
    }

    public static boolean isZippedInput(String filePath) {
        boolean isZip = false;
        try {
            FileInputStream fin = new FileInputStream(filePath);
            PushbackInputStream pb = new PushbackInputStream(fin, 2);
            byte[] signature = new byte[2];
            pb.read(signature);
            pb.unread(signature);
            isZip = signature[0] == 31 && signature[1] == -117;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return isZip;
    }
}

