/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.exceptions.InvalidJSONException;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class DrillPipe
extends AbstractPipe<History, History> {
    protected static Logger sLogger = Logger.getLogger(DrillPipe.class);
    private boolean keepJSON = false;
    private String[] drillPaths;
    private ArrayList<JsonPath> compiledPaths;
    private int drillColumn = -1;
    protected AddMetadataLines addMetadataLines = new AddMetadataLines();

    public DrillPipe(boolean keepJSON, String[] paths) {
        this.keepJSON = keepJSON;
        this.drillPaths = paths;
        this.setupPaths();
    }

    public DrillPipe(boolean keepJSON, String[] paths, int drillColumn) {
        this.keepJSON = keepJSON;
        this.drillPaths = paths;
        this.drillColumn = drillColumn;
        this.setupPaths();
    }

    private void setupPaths() {
        this.compiledPaths = new ArrayList();
        for (int i = 0; i < this.drillPaths.length; ++i) {
            JsonPath jsonPath = JsonPath.compile((String)this.drillPaths[i], (Filter[])new Filter[0]);
            this.compiledPaths.add(jsonPath);
        }
    }

    protected History processNextStart() throws NoSuchElementException, InvalidJSONException {
        if (this.starts.hasNext()) {
            String json;
            History history = (History)this.starts.next();
            int size = history.size();
            if (this.drillColumn > 0) {
                this.drillColumn = this.drillColumn - size - 1;
            } else if (this.drillColumn == 0) {
                throw new InvalidPipeInputException("Invalid Column input", (Pipe)this);
            }
            if (size == 1) {
                this.drillColumn = -1;
            }
            if (!(json = ((String)history.remove(size + this.drillColumn)).trim()).startsWith("{")) {
                int reportColumn = history.size() + this.drillColumn;
                throw new InvalidJSONException("A column input to Drill that should be JSON was not JSON, I can't Drill non-JSON columns: " + reportColumn + " : " + json);
            }
            int numPaths = this.compiledPaths.size();
            for (int i = 0; i < numPaths; ++i) {
                try {
                    JsonPath jsonPath = this.compiledPaths.get(i);
                    Object o = jsonPath.read(json);
                    if (o == null) continue;
                    history.add(o.toString());
                    continue;
                }
                catch (InvalidPathException e) {
                    history.add(".");
                }
            }
            if (this.keepJSON) {
                history.add(json);
            }
            return history;
        }
        throw new NoSuchElementException();
    }
}

