/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createCatalogProps;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import edu.mayo.pipes.history.ColumnMetaData;
import java.util.ArrayList;

public class ColumnTypeCounter {
    public static final String[] DELIMITERS = new String[]{",", ";"};
    private ColumnMetaData mColMeta = new ColumnMetaData();
    private int mCountJsonArray = 0;
    private ArrayList<String> mExamples = new ArrayList();

    public ColumnTypeCounter(String colName, String description) {
        this.mColMeta.setColumnName(colName);
        this.mColMeta.setDescription(description);
    }

    public void addValue(String value) {
        if (".".equals(value)) {
            return;
        }
        ColumnMetaData.Type type = this.getType(value);
        if (type == null) {
            return;
        }
        this.mColMeta.setType(type);
    }

    public ColumnMetaData getColumnMetaData() {
        if (this.mColMeta.getType() == null) {
            this.mColMeta.setType(ColumnMetaData.Type.String);
        }
        if (this.mColMeta.getType().equals((Object)ColumnMetaData.Type.Boolean)) {
            this.mColMeta.setCount("0");
        } else if (this.mCountJsonArray > 0) {
            this.mColMeta.setCount(".");
        } else {
            this.mColMeta.setCount("1");
        }
        return this.mColMeta;
    }

    private ColumnMetaData.Type getType(String value) {
        ColumnMetaData.Type type = null;
        JsonElement jsonElem = new JsonParser().parse(value);
        if (jsonElem.isJsonObject()) {
            type = ColumnMetaData.Type.JSON;
        } else if (jsonElem.isJsonArray()) {
            type = this.getTypeFromJsonArray((JsonArray)jsonElem);
            ++this.mCountJsonArray;
        } else {
            type = jsonElem.isJsonPrimitive() ? this.getTypeFromJsonPrimitive((JsonPrimitive)jsonElem) : ColumnMetaData.Type.String;
        }
        return type;
    }

    private ColumnMetaData.Type getTypeFromJsonArray(JsonArray jsonArray) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        JsonElement elem = jsonArray.get(0);
        ColumnMetaData.Type type = null;
        type = elem.isJsonObject() ? ColumnMetaData.Type.JSON : (elem.isJsonPrimitive() ? this.getTypeFromJsonPrimitive((JsonPrimitive)elem) : ColumnMetaData.Type.String);
        return type;
    }

    private ColumnMetaData.Type getTypeFromJsonPrimitive(JsonPrimitive prim) {
        ColumnMetaData.Type type = null;
        if (prim.isBoolean()) {
            type = ColumnMetaData.Type.Boolean;
        } else if (prim.isNumber()) {
            if (this.isInt(prim.toString())) {
                type = ColumnMetaData.Type.Integer;
            } else if (this.isFloat(prim.toString())) {
                type = ColumnMetaData.Type.Float;
            }
        } else {
            type = ColumnMetaData.Type.String;
        }
        return type;
    }

    private boolean isFloat(String val) {
        try {
            Float.parseFloat(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isInt(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

