/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.buildcatalog.BuildCatalog;
import edu.mayo.bior.buildcatalog.BuildStepKey;
import edu.mayo.cli.CommandPlugin;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class BuildCatalogCommand
implements CommandPlugin {
    private static final Logger sLogger = Logger.getLogger(BuildCatalogCommand.class);
    private static final char OPTION_BUILD_INFO_FILE = 'b';
    private static final char OPTION_START_AT_STEP = 's';

    public void init(Properties props) {
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        File buildInfoFile;
        String buildInfoFilePath = "";
        if (cl.hasOption('b') && !(buildInfoFile = new File(buildInfoFilePath = cl.getOptionValue('b'))).canRead()) {
            throw new IllegalArgumentException("Error: Specified build information file does not exist: " + buildInfoFile);
        }
        BuildStepKey stepToStartAt = BuildStepKey.MAKE_JSON;
        if (cl.hasOption('s')) {
            String startStepStr = cl.getOptionValue('s');
            stepToStartAt = this.getStep(startStepStr);
        }
        BuildCatalog biorBuildCatalog = new BuildCatalog();
        biorBuildCatalog.build(buildInfoFilePath, stepToStartAt);
    }

    private BuildStepKey getStep(String startStepStr) {
        try {
            return BuildStepKey.valueOf(startStepStr);
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Step not recognized: " + startStepStr + ".\nValid steps are:\n");
            for (BuildStepKey key : BuildStepKey.values()) {
                msg.append("    " + key.toString() + "\n");
            }
            throw new IllegalArgumentException(msg.toString());
        }
    }
}

