/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.mayo.bior.catalogvalidator.CatalogEntryGoldenJson;
import edu.mayo.bior.catalogvalidator.SeqLookup;
import edu.mayo.bior.catalogvalidator.UniqOrderedMessageLogger;
import edu.mayo.bior.catalogvalidator.VerifyCatalogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.lf5.LogLevel;

public class VerifyHumanVariantCatalog {
    private static final Pattern DNA_NUCLEOTIDES = Pattern.compile("^[ACGTN]{1,}+$");
    private boolean do_seq_val = false;
    private SeqLookup mSequenceLookup = null;
    private int mNumberRefAllelesMatch = 0;
    private int mNumberRefAllelesNotMatch = 0;
    private UniqOrderedMessageLogger mlogger = null;

    public VerifyHumanVariantCatalog(TreeMap<String, Integer> chrSizeMap, String chromosomeRefSeqToLoad, String refFASTAFileName, UniqOrderedMessageLogger logger) {
        this.mlogger = logger;
        try {
            this.mSequenceLookup = new SeqLookup(chromosomeRefSeqToLoad, refFASTAFileName, chrSizeMap);
            this.mlogger.logMessage("Genome reference sequence loaded to verify '_refAllele' values for chromsome: " + chromosomeRefSeqToLoad, LogLevel.INFO);
            this.do_seq_val = true;
        }
        catch (Exception e) {
            this.do_seq_val = false;
            this.mlogger.logMessage("Unable to successfully initialize reference sequence lookup utility for chromosome: " + chromosomeRefSeqToLoad + ". Will not be verifying '_refAllele' values.  Exception: " + e.getMessage(), LogLevel.WARN);
            e.printStackTrace();
        }
    }

    public CatalogEntryGoldenJson validateGoldenJson_Variant(JsonObject catalogRowJson, CatalogEntryGoldenJson goldenJsonVariant) {
        CatalogEntryGoldenJson variant = null;
        variant = goldenJsonVariant == null ? new CatalogEntryGoldenJson() : goldenJsonVariant;
        try {
            String refAllele = this.validateGoldenJsonRefAllele(catalogRowJson);
            if (refAllele == null || VerifyCatalogUtils.isEmptyJsonValue(refAllele)) {
                this.mlogger.logMessage("_refAllele not set successfully for variant for chr: " + variant.getChr() + " position: " + variant.getMinBP(), LogLevel.ERROR);
            } else {
                variant.setRefAllele(refAllele);
                variant.setStrand(VerifyCatalogUtils.validateGoldenJsonStrand(catalogRowJson, this.mlogger));
                if (this.do_seq_val) {
                    String reflookupRefAllele = this.mSequenceLookup.lookup(variant.getMinBP(), variant.getMaxBP());
                    if (!VerifyCatalogUtils.isEmpty(reflookupRefAllele)) {
                        if (!refAllele.toUpperCase().equals(reflookupRefAllele.toUpperCase())) {
                            ++this.mNumberRefAllelesNotMatch;
                            this.mlogger.logMessage("_refAllele [" + refAllele + "] does not match reference sequence value [" + reflookupRefAllele + "] for:  chr=" + variant.getChr() + " position=" + variant.getMinBP(), LogLevel.ERROR);
                        } else {
                            ++this.mNumberRefAllelesMatch;
                        }
                    } else {
                        this.mlogger.logMessage("Allele lookup against reference sequence returned null result for chr=" + variant.getChr() + " minBP=" + variant.getMinBP() + " maxBP=" + variant.getMaxBP(), LogLevel.ERROR);
                    }
                }
            }
            JsonPrimitive minBPPrim = VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_minBP");
            variant.setMinBP(minBPPrim.getAsInt());
            JsonPrimitive maxBPPrim = VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_maxBP");
            variant.setMaxBP(maxBPPrim.getAsInt());
            variant.setAltAlleles(this.validateGoldenJsonAltAllele(catalogRowJson, refAllele));
            int jsonGoldenVariantLength = variant.getMaxBP() - variant.getMinBP() + 1;
            if (refAllele != null && refAllele.length() != jsonGoldenVariantLength) {
                this.mlogger.logMessage("_refAllele length [" + refAllele.length() + "] is not equal Json position length [" + jsonGoldenVariantLength + "]. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.ERROR);
            } else if (refAllele == null) {
                this.mlogger.logMessage("_refAllele null. not checking json golden position length [" + jsonGoldenVariantLength + "]. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.ERROR);
            }
        }
        catch (Exception e) {
            this.mlogger.logMessage("Unable to create variant object from golden attributes. row: " + catalogRowJson.toString(), LogLevel.ERROR);
            e.printStackTrace();
        }
        return variant;
    }

    public int getNumberRefAllelesMatchReferenceSequence() {
        return this.mNumberRefAllelesMatch;
    }

    public int getNumberRefAllelesNotMatchReferenceSequence() {
        return this.mNumberRefAllelesNotMatch;
    }

    protected String validateGoldenJsonRefAllele(JsonObject catalogRowJson) throws Exception {
        String golden_refAllele = null;
        JsonPrimitive refAllelePrim = VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_refAllele");
        if (refAllelePrim == null || !refAllelePrim.isString()) {
            this.mlogger.logMessage("_refAllele golden value is not a JSON String, or is not a Json Primitive String. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARN);
            return null;
        }
        golden_refAllele = refAllelePrim.getAsString();
        if (VerifyCatalogUtils.isEmptyJsonValue(golden_refAllele)) {
            this.mlogger.logMessage("_refAllele value is emtpy; not expected in human variant catalog. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARN);
        } else {
            if (!VerifyHumanVariantCatalog.validDNANucleotides(golden_refAllele)) {
                this.mlogger.logMessage("ERROR: _refAllele value [" + golden_refAllele + "] contains an invalid nucleotide value. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.ERROR);
            }
            String ref = null;
            if (catalogRowJson.get("REF") != null) {
                ref = catalogRowJson.get("REF").getAsString();
            } else if (catalogRowJson.get("ref") != null) {
                ref = catalogRowJson.get("ref").getAsString();
            }
            if (!VerifyCatalogUtils.isEmptyJsonValue(ref) && !ref.equals(golden_refAllele)) {
                this.mlogger.logMessage("WARNING: The _refAllele value [" + golden_refAllele + "] is not equal to the JSON REF value [" + ref + "].", LogLevel.WARN);
            }
        }
        return golden_refAllele;
    }

    protected List<String> validateGoldenJsonAltAllele(JsonObject catalogRowJson, String goldenRefAllele) throws Exception {
        ArrayList<String> altAlleleList = new ArrayList<String>();
        if (!catalogRowJson.get("_altAlleles").isJsonArray()) {
            this.mlogger.logMessage("ERROR: _altAlleles is not a JsonArray data type, but should be. Json object as string: " + catalogRowJson.get("_altAlleles").toString(), LogLevel.ERROR);
            return altAlleleList;
        }
        JsonArray altAlleles = catalogRowJson.getAsJsonArray("_altAlleles");
        String alt = null;
        if (catalogRowJson.get("ALT") != null) {
            alt = catalogRowJson.get("ALT").getAsString();
        } else if (catalogRowJson.get("alt") != null) {
            JsonElement jsonAlt = catalogRowJson.get("alt");
            if (jsonAlt == null) {
                System.err.println("Couldn't get JSON element for row: " + catalogRowJson.toString());
            } else {
                alt = jsonAlt.getAsString();
            }
        }
        Iterator iterator = altAlleles.iterator();
        while (iterator.hasNext()) {
            String eachAltAllele = ((JsonElement)iterator.next()).getAsString();
            if (eachAltAllele.length() == 0) {
                this.mlogger.logMessage("ERROR: One of the _altAllele values [" + eachAltAllele + "] is empty value. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.ERROR);
                continue;
            }
            if (!VerifyHumanVariantCatalog.validDNANucleotides(eachAltAllele)) {
                this.mlogger.logMessage("ERROR: One of the _altAllele values [" + eachAltAllele + "] is not valid nucleotide value. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.ERROR);
            }
            if (goldenRefAllele != null && goldenRefAllele.equals(eachAltAllele)) {
                this.mlogger.logMessage("ERROR: One of the _altAllele values is equal to the _refAllele. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.ERROR);
            } else if (goldenRefAllele == null) {
                this.mlogger.logMessage("WARNING: Couldn't verify that the _altAllele value is not equal to the _refAllele. _refAllele is null. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARN);
            }
            if (!eachAltAllele.equals(alt)) {
                this.mlogger.logMessage("WARNING: One of the _altAllele values [" + eachAltAllele + "] not equal to the JSON ALT value [" + alt + "]. JSON for row= " + catalogRowJson.toString(), LogLevel.WARN);
            }
            if (altAlleleList.add(eachAltAllele)) continue;
            this.mlogger.logMessage("WARNING: One of the _altAllele values [" + eachAltAllele + "] is repeated multiple times. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARN);
        }
        return altAlleleList;
    }

    protected static boolean validDNANucleotides(String dnaSeq) {
        Matcher m = DNA_NUCLEOTIDES.matcher(dnaSeq);
        return m.find();
    }

    private VerifyHumanVariantCatalog() {
    }
}

