/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import edu.mayo.bior.catalog.HumanBuildAssembly;
import edu.mayo.bior.catalogvalidator.CatalogDataSource;
import edu.mayo.bior.catalogvalidator.CatalogEntryGoldenJson;
import edu.mayo.bior.catalogvalidator.CatalogTabixEntry;
import edu.mayo.bior.catalogvalidator.FileUtils;
import edu.mayo.bior.catalogvalidator.UniqOrderedMessageLogger;
import edu.mayo.bior.catalogvalidator.VerifierExecutionException;
import edu.mayo.bior.catalogvalidator.VerifierInputException;
import edu.mayo.bior.catalogvalidator.VerifyCatalogUtils;
import edu.mayo.bior.catalogvalidator.VerifyHumanVariantCatalog;
import edu.mayo.bior.catalogvalidator.WholeCatalogValidationThread;
import edu.mayo.bior.util.validation.CatalogFileValidator;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LogLevel;

public class VerifyCatalogBase {
    protected File mCatalogFile = null;
    protected String mCatalogDir = null;
    protected String mCatalogPrefix = null;
    protected final String mCatalogListFileName = BASEDIR_TEST + "/bsi/catalogs/bior/v1/CATALOG_LIST.txt";
    private CatalogDataSource mCatalogDataSource = null;
    protected String hg37_ChrSizes = BASEDIR_TEST + "/bsi/refdata-new/ucsc_genome/human/hg19/downloaded/2015_07_07/hg19.chrom.sizes";
    protected String hg37_ChrOrder = BASEDIR_TEST + "/bsi/refdata-new/ucsc_genome/human/hg19/processed/2015_07_07/chroms/chrs_in_order";
    protected String hg37_Refseq = BASEDIR_TEST + "/bsi/refdata-new/ucsc_genome/human/hg19/processed/2015_07_07/chroms/ucsc_hg19.fa";
    protected String hg38_ChrSizes = BASEDIR_TEST + "/bsi/refdata-new/ucsc_genome/human/hg38/downloaded/2015_07_22/hg38.chrom.sizes";
    protected String hg38_ChrOrder = BASEDIR_TEST + "/bsi/refdata-new/ucsc_genome/human/hg38/processed/2015_07_22/chroms/chrs_in_order";
    protected String hg38_Refseq = BASEDIR_TEST + "/bsi/refdata-new/ucsc_genome/human/hg38/processed/2015_07_22/chroms/ucsc_hg38.fa";
    private File mColumnsTsvFile = null;
    private HashMap<String, ColumnMetaData> mCatalogColumns = null;
    private TreeMap<String, String> mBIORIndexMap_colNameToFilePath = null;
    private TreeMap<String, Integer> mChrSizeMap = null;
    private String mRefseqFileNm = null;
    private List<String> mExpectedChrOrderList = null;
    private List<String> mCatalogColsNotFoundInSomeJsonRows = new ArrayList<String>();
    private List<String> mJsonKeysNotFoundInColumnsTsv = new ArrayList<String>();
    private VAL_TYPE mValType = VAL_TYPE.STRICT;
    protected Logger apacheLogger = Logger.getLogger(VerifyCatalogBase.class);
    private UniqOrderedMessageLogger mLogger = new UniqOrderedMessageLogger();
    public static String BASEDIR_TEST = "/data5/";
    private HashMap<String, Integer> mNumberOfTimesKeySeenInCatalog = new HashMap();
    private HashMap<String, Integer> mMaxValuesForKey = new HashMap();

    public int verify(String catalogFilePath, VAL_TYPE valLevel, Logger logger) throws VerifierInputException, VerifierExecutionException {
        boolean areOrderCheckingErrors;
        int returnStatus = -1;
        this.mCatalogFile = new File(catalogFilePath);
        this.setCatalogNamePrefix(this.mCatalogFile);
        this.mValType = valLevel;
        File logfilePath = new File(new File(".").getAbsolutePath() + "/" + this.getCatalogNamePrefix() + "_verifyCatalogLog.txt");
        BufferedWriter logWtr = null;
        try {
            logWtr = new BufferedWriter(new FileWriter(logfilePath));
        }
        catch (IOException io) {
            throw new VerifierExecutionException("Exception raised creating writer for log file: " + logfilePath.getAbsolutePath());
        }
        System.out.println("Checking common catalog characteristics for: " + catalogFilePath);
        this.verifyCatalogCommonCharacteristics();
        System.out.println("Assessing whether catalog is positional: " + catalogFilePath);
        Boolean isPositionalCatalog = null;
        try {
            isPositionalCatalog = this.isPositionalCatalog(this.mCatalogFile, this.mExpectedChrOrderList);
        }
        catch (VerifierExecutionException exec) {
            try {
                logWtr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw exec;
        }
        WholeCatalogValidationThread orderCheckThread = null;
        if (isPositionalCatalog.booleanValue()) {
            System.out.println("Kicking off whole-file order & index verification for: " + catalogFilePath);
            orderCheckThread = this.startCatalogOrderCheckingThread(isPositionalCatalog, logWtr);
            try {
                orderCheckThread.join(0L);
            }
            catch (InterruptedException e) {
                throw new VerifierExecutionException("Exception raised while trying to join whole-file order checking thread to current thread. Exception: " + e.getMessage());
            }
        }
        System.out.println("Kicking off row-by-row verification for: " + catalogFilePath);
        this.verifyCatalogRows(isPositionalCatalog);
        System.out.println("Writing logged information for catalog: " + catalogFilePath);
        try {
            this.getLogger().writeOrderedMessages(logWtr);
        }
        catch (IOException io) {
            throw new VerifierExecutionException("Exception writing log statements to file: " + logfilePath + " Exception: " + io.getMessage());
        }
        this.reportColumnUsage();
        returnStatus = orderCheckThread != null ? ((areOrderCheckingErrors = orderCheckThread.areErrorsLogged()) || this.getLogger().areErrorsLogged() ? 1 : 0) : (this.getLogger().areErrorsLogged() ? 1 : 0);
        return returnStatus;
    }

    protected void verifyCatalogCommonCharacteristics() throws VerifierInputException {
        this.verifyCatalogFile(this.mCatalogFile);
        this.verifySupportingCatalogFilesExist(this.mCatalogFile);
        if (this.mColumnsTsvFile != null) {
            if (this.mColumnsTsvFile.exists()) {
                try {
                    ColumnMetaDataOperations colMetaOps = new ColumnMetaDataOperations();
                    this.mCatalogColumns = colMetaOps.load(this.mColumnsTsvFile.getCanonicalPath());
                    List warningMsgs = colMetaOps.validateContents(this.mColumnsTsvFile);
                    if (warningMsgs.size() > 0) {
                        for (String warning : warningMsgs) {
                            this.logMessage(warning, LogLevel.WARNING);
                        }
                    }
                    if (this.mCatalogColumns.keySet().size() == 1) {
                        this.logMessage("No columns were read from the columns.tsv for catalog: " + this.mCatalogFile.getAbsolutePath() + "\n", LogLevel.ERROR);
                    }
                }
                catch (IOException e) {
                    this.logMessage("Exception raised reading in columns.tsv file name: " + this.mColumnsTsvFile + "\n", LogLevel.ERROR);
                }
            } else {
                this.logMessage("Specified columns.tsv file does not exist: " + this.mColumnsTsvFile.getAbsolutePath() + "\n", LogLevel.ERROR);
            }
        } else {
            this.logMessage("No columns.tsv file was specified; mColumnsTsvFile is null. Cannot create CatalogColumnsMap object.", LogLevel.ERROR);
        }
        File dataSourcePropFile = new File(this.getCatalogDir() + File.separator + this.getCatalogNamePrefix() + ".datasource.properties");
        this.mCatalogDataSource = this.verifyDataSource(this.mCatalogFile, dataSourcePropFile, this.mCatalogListFileName, this.mValType);
        if (this.mCatalogDataSource != null) {
            if (this.mCatalogDataSource.getHumanBuildValue() != null) {
                if (this.mCatalogDataSource.getHumanBuildValue().name().equals(HumanBuildAssembly.GRCh37.name())) {
                    this.mRefseqFileNm = this.hg37_Refseq;
                    this.initHumanReferenceInfo(this.mCatalogFile, this.hg37_ChrSizes, this.hg37_ChrOrder, this.getLogger());
                } else if (this.mCatalogDataSource.getHumanBuildValue().name().equals(HumanBuildAssembly.GRCh38.name())) {
                    this.mRefseqFileNm = this.hg38_Refseq;
                    this.initHumanReferenceInfo(this.mCatalogFile, this.hg38_ChrSizes, this.hg38_ChrOrder, this.getLogger());
                } else {
                    this.logMessage("Unsure of human genome build. Value found in data source properties file was: [" + this.mCatalogDataSource.getHumanBuildValue().name() + ". Not setting chromosome reference info, and will not be checking these chomosome, position, or reference allele values in catalog.", LogLevel.WARNING);
                }
            } else {
                this.logMessage("Unsure of human genome build value. Not setting chromosome reference info, and will not be checking these chomosome, position, or reference allele values in catalog.", LogLevel.WARNING);
            }
        } else {
            this.logMessage("Failed to instantiate and verify data source properties. Unable to set some catalog characteristics.", LogLevel.ERROR);
        }
        this.mBIORIndexMap_colNameToFilePath = this.verifyBIORIndexFilenames(this.mCatalogFile);
        if (this.mBIORIndexMap_colNameToFilePath == null) {
            this.logMessage("Catalog has no H2 indexes configured: " + this.mCatalogFile, LogLevel.INFO);
        }
        File blacklistFile = new File(this.getCatalogDir() + File.separator + this.getCatalogNamePrefix() + ".columns.tsv.blacklist");
        this.verifyBlackList(blacklistFile, this.mCatalogColumns);
    }

    private void verifyCatalogRows(boolean isPositionalCatalog) {
        VerifyHumanVariantCatalog humanVariantHelper = null;
        this.logMessage("Starting catalog row-by-row checks. Date: " + new SimpleDateFormat("MM.dd.yyyy 'at' HH:mm:ss z").format(Calendar.getInstance().getTime()), LogLevel.INFO);
        Object prevChrProcessing = null;
        String chrProcessing = null;
        BufferedReader catalogRdr = null;
        int rowsInCatalog = 0;
        try {
            catalogRdr = FileUtils.getBufferedReader(this.mCatalogFile.getAbsolutePath());
            String curCatalogRow = null;
            while ((curCatalogRow = catalogRdr.readLine()) != null) {
                CatalogTabixEntry tabixRowEntry;
                if (curCatalogRow.startsWith("#")) continue;
                if (++rowsInCatalog % 100000 == 0) {
                    System.gc();
                    System.out.println("Completed row-by-row validation on [" + rowsInCatalog + "] rows of catalog.");
                    System.gc();
                    double currentMemory = (double)(Runtime.getRuntime().totalMemory() / 1024L) / 1024.0 - (double)(Runtime.getRuntime().freeMemory() / 1024L) / 1024.0;
                    System.out.println("Memory used currently [" + currentMemory + "] megabytes.");
                }
                if ((tabixRowEntry = VerifyCatalogUtils.readCatalogRow(curCatalogRow, this.mLogger)) == null) {
                    this.logMessage("Catalog ValidatorBase.validate(): Could not read in catalog row as valid Tabix Entry: line: " + curCatalogRow, LogLevel.ERROR);
                    continue;
                }
                if (chrProcessing == null || !tabixRowEntry.getChromosome().equals(chrProcessing)) {
                    if (chrProcessing != null && humanVariantHelper != null) {
                        this.logMessage("Chromosome " + chrProcessing + ": _refAllele values that DO match the reference sequence is [" + humanVariantHelper.getNumberRefAllelesMatchReferenceSequence() + "].", LogLevel.INFO);
                        String noMatchMessage = "Chromosome " + chrProcessing + ": _refAllele values that DO NOT match the reference sequence is [" + humanVariantHelper.getNumberRefAllelesNotMatchReferenceSequence() + "].";
                        if (humanVariantHelper.getNumberRefAllelesNotMatchReferenceSequence() <= 0) {
                            this.logMessage(noMatchMessage, LogLevel.INFO);
                        } else {
                            this.logMessage(noMatchMessage, LogLevel.ERROR);
                        }
                    }
                    chrProcessing = tabixRowEntry.getChromosome();
                    if (this.mCatalogDataSource.isVariantCatalog()) {
                        humanVariantHelper = new VerifyHumanVariantCatalog(this.mChrSizeMap, chrProcessing, this.mRefseqFileNm, this.mLogger);
                    }
                }
                this.verifyCatalogRow(tabixRowEntry, isPositionalCatalog, humanVariantHelper);
            }
            this.logMessage("Completed row-by-row validation. Number of rows in catalog [" + rowsInCatalog + "].\n", LogLevel.INFO);
        }
        catch (Throwable t) {
            try {
                this.logMessage("Catalog ValidatorBase.validate(): Exception occurred: " + t.getMessage(), LogLevel.ERROR);
                t.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            t.printStackTrace();
        }
    }

    private void verifyCatalogRow(CatalogTabixEntry catalogRowEntry, boolean isPositionalCatalog, VerifyHumanVariantCatalog humanVariantVerifyHelper) throws Exception {
        JsonObject catalogRowJsonObj = null;
        try {
            catalogRowJsonObj = VerifyCatalogUtils.getJsonObject(catalogRowEntry.getJsonString());
        }
        catch (JsonSyntaxException jse) {
            this.logMessage("Exception parsing json value for tabix row =" + catalogRowEntry.getJsonString(), LogLevel.ERROR);
        }
        try {
            this.validateRowTabix(catalogRowEntry, isPositionalCatalog);
            CatalogEntryGoldenJson catalogRowGolden = this.validateRowGoldenJson(catalogRowJsonObj, isPositionalCatalog);
            if (this.mCatalogDataSource.isHumanCatalog() && this.mCatalogDataSource.isVariantCatalog() && this.mCatalogDataSource.getHumanBuildValue() != null) {
                humanVariantVerifyHelper.validateGoldenJson_Variant(catalogRowJsonObj, catalogRowGolden);
            } else {
                this.logMessage("Not performing variant checking. ", LogLevel.WARNING);
            }
            this.compareTabixToGoldenElements(catalogRowEntry, catalogRowGolden, isPositionalCatalog);
            this.validateRowJson(catalogRowEntry.getJsonString(), catalogRowJsonObj);
        }
        catch (Exception e) {
            this.logMessage("Exception: Exception in detailed catalog row checking. json value for tabix row =" + catalogRowEntry.getJsonString(), LogLevel.ERROR);
            e.printStackTrace();
        }
    }

    private void verifyCatalogFile(File catalogFile) throws VerifierInputException {
        if (!CatalogFileValidator.catalogExists(catalogFile.getAbsolutePath())) {
            throw new VerifierInputException("Catalog specified does not exist or is not readable: " + catalogFile.getAbsolutePath());
        }
        this.setCatalogNamePrefix(catalogFile);
        if (this.getCatalogNamePrefix() == null || this.getCatalogNamePrefix().length() <= 0) {
            throw new VerifierInputException("Couldn't get a valid catalog name based on the expected suffix name for catalog: " + catalogFile.getAbsolutePath());
        }
        if (!CatalogFileValidator.hasExpectedSuffix(catalogFile.getAbsolutePath())) {
            throw new VerifierInputException("Expected suffix name [.tsv.bgz] not found for catalog: " + catalogFile.getAbsolutePath());
        }
        this.setCatalogDir(catalogFile);
        if (this.getCatalogDir() == null || this.getCatalogDir().length() == 0) {
            throw new VerifierInputException("Catalog directory not acquired successfully: " + this.getCatalogDir());
        }
    }

    private void verifySupportingCatalogFilesExist(File catalogFile) {
        File blackList_biorWebSymLink;
        File catDir = catalogFile.getParentFile();
        String catalogNamePrefix = this.getCatalogNamePrefix();
        this.mColumnsTsvFile = new File(catDir + File.separator + catalogNamePrefix + ".columns.tsv");
        if (!FileUtils.fileExists(this.mColumnsTsvFile)) {
            this.logMessage("File not exist: " + this.mColumnsTsvFile.getAbsolutePath(), LogLevel.ERROR);
        }
        if (!FileUtils.fileExists(new File(catDir + File.separator + catalogNamePrefix + ".datasource.properties"))) {
            this.logMessage("File not exist: " + catDir + File.separator + catalogNamePrefix + ".datasource.properties", LogLevel.ERROR);
        }
        if (!FileUtils.fileExists(new File(catDir + File.separator + catalogNamePrefix + ".columns.tsv.blacklist"))) {
            this.logMessage("File not exist: " + catDir + File.separator + catalogNamePrefix + ".columns.tsv.blacklist", LogLevel.WARNING);
        }
        if (!FileUtils.fileExists(blackList_biorWebSymLink = new File(catDir + File.separator + catalogNamePrefix + ".columns.tsv.blacklist.biorweb"))) {
            this.logMessage("File not exist: " + catDir + File.separator + catalogNamePrefix + ".columns.tsv.blacklist.biorweb", LogLevel.WARNING);
        } else if (!FileUtils.validSymLink(blackList_biorWebSymLink)) {
            this.logMessage("Unable to follow/resolve symlink for biorweb blacklist sym link file: " + blackList_biorWebSymLink.getAbsolutePath(), LogLevel.WARNING);
        }
    }

    private TreeMap<String, String> verifyBIORIndexFilenames(File catalogFile) {
        File[] fList;
        TreeMap<String, String> biorIndexMap = new TreeMap<String, String>();
        File indexDir = new File(this.getCatalogDir() + File.separator + "index");
        if (!indexDir.isDirectory()) {
            return null;
        }
        for (File f : fList = indexDir.listFiles()) {
            String tmpHack_indexname;
            String fBaseNm = f.getName();
            if (!fBaseNm.startsWith(tmpHack_indexname = this.getCatalogNamePrefix().replace(".vcf", "")) || !fBaseNm.endsWith(".idx.h2.db")) continue;
            String colNameIndexed = fBaseNm.substring(new String(tmpHack_indexname + '.').length(), fBaseNm.indexOf(".idx.h2.db"));
            if (this.mCatalogColumns.get(colNameIndexed) == null) {
                this.logMessage("BIOR Index checking: Column name in BIOR index [" + colNameIndexed + "] not found in Columns.tsv list. Unusable Index: " + f.getAbsolutePath(), LogLevel.WARNING);
                continue;
            }
            if (catalogFile.lastModified() > f.lastModified()) {
                this.logMessage("BIOR Index checking: Catalog file [" + catalogFile.getAbsolutePath() + "] is newer than the BIOR index found. Must regenerate BIOR Index: " + f.getAbsolutePath(), LogLevel.WARNING);
                continue;
            }
            biorIndexMap.put(colNameIndexed, f.getAbsolutePath());
        }
        if (biorIndexMap.size() == 0) {
            this.logMessage("BIOR Index checking: No valid H2 database file names found in index subdirectory for catalog name: " + this.getCatalogNamePrefix(), LogLevel.WARNING);
        }
        return biorIndexMap;
    }

    private void verifyBlackList(File blacklistFile, HashMap<String, ColumnMetaData> catalogColumnInfo) throws VerifierInputException {
        if (catalogColumnInfo == null || catalogColumnInfo.keySet().size() == 0) {
            this.logMessage("Cannot verify the blacklist file content: CatalogColumnsMap is empty.", LogLevel.WARNING);
            return;
        }
        if (blacklistFile == null || !blacklistFile.exists()) {
            this.logMessage("Cannot verify the blacklist file content. Expected blacklist file does not exist.", LogLevel.WARNING);
            return;
        }
        BufferedReader rdr = null;
        try {
            rdr = FileUtils.getBufferedReader(blacklistFile.getAbsolutePath());
            String line = null;
            while ((line = rdr.readLine()) != null) {
                if (line.trim().startsWith("#") || catalogColumnInfo.get(line.trim()) != null) continue;
                this.logMessage("The blacklist file contains a column name not found in the columns.tsv file: " + line.trim(), LogLevel.WARNING);
            }
        }
        catch (IOException io) {
            throw new VerifierInputException("Exception reading blacklist file: " + blacklistFile.getAbsolutePath());
        }
    }

    private CatalogDataSource verifyDataSource(File ourCatalogFile, File dataSourceFile, String catalogListPathNm, VAL_TYPE valType) {
        CatalogDataSource catalogDataSrc = null;
        try {
            catalogDataSrc = new CatalogDataSource(dataSourceFile, this.mLogger);
            if (catalogDataSrc != null) {
                catalogDataSrc.verify(this.mCatalogFile, catalogListPathNm, this.mValType);
            }
        }
        catch (Exception e) {
            String msg = "Exception raised while verifying data source properties: " + e.getMessage();
            this.logMessage(msg, LogLevel.ERROR);
            return null;
        }
        return catalogDataSrc;
    }

    protected void validateRowTabix(CatalogTabixEntry catalogRowEntry, boolean isPositionalCatalog) throws Exception {
        if (isPositionalCatalog) {
            if (this.mChrSizeMap != null) {
                Boolean inRange = this.validateTabixPositionsInChrRange(catalogRowEntry, isPositionalCatalog);
                if (inRange == null) {
                    this.logMessage("Non-positional catalog entry found within positional catalog. chromosome value: " + catalogRowEntry.getChromosome(), LogLevel.WARNING);
                } else if (!inRange.booleanValue()) {
                    this.logMessage("Tabix values found to not be in correct chromsomal size range: " + catalogRowEntry.getCatalogTabixLine(), LogLevel.WARNING);
                }
            } else {
                this.logMessage("The catalog was found to be positional, but the chromosome size map is not set. Cannot validate tabix positions for catalog.", LogLevel.WARNING);
            }
        } else {
            this.validateTabixNonPositional(catalogRowEntry);
        }
    }

    private Boolean validateTabixPositionsInChrRange(CatalogTabixEntry tabixEntry, boolean catalogIsPositional) throws Exception {
        Boolean result = null;
        if (catalogIsPositional && !VerifyCatalogUtils.isChromosomePositional(tabixEntry)) {
            if (VerifyCatalogUtils.isMinBPPositional(tabixEntry) && VerifyCatalogUtils.isMaxBPPositional(tabixEntry)) {
                return null;
            }
            this.logMessage("Tabix chromosome is not positional but the _minBP or _maxBP appears to be positional. Please verify content for catalog row containing:  _landmark: " + tabixEntry.getChromosome() + " _minBP: " + tabixEntry.getMinPosition() + " _maxBP: " + tabixEntry.getMaxPosition(), LogLevel.WARNING);
            return null;
        }
        boolean minInRange = this.inChromosomeRange(tabixEntry.getChromosome(), tabixEntry.getMinPosition());
        boolean maxInRange = this.inChromosomeRange(tabixEntry.getChromosome(), tabixEntry.getMaxPosition());
        if (!minInRange) {
            this.logMessage("Tabix start position not in valid chromosome size range.  Chr: " + tabixEntry.getChromosome() + " Chr Max Position: " + this.mChrSizeMap.get(tabixEntry.getChromosome()) + " Tabix entry start position: " + tabixEntry.getMinPosition(), LogLevel.ERROR);
        }
        if (!maxInRange) {
            this.logMessage("Tabix stop position not in valid chromosome size range.  Chr: " + tabixEntry.getChromosome() + " Chr Max Position: " + this.mChrSizeMap.get(tabixEntry.getChromosome()) + " Tabix entry stop position: " + tabixEntry.getMaxPosition(), LogLevel.ERROR);
        }
        result = minInRange && maxInRange;
        return result;
    }

    private void validateTabixNonPositional(CatalogTabixEntry tabixEntry) throws Exception {
        if (VerifyCatalogUtils.isChromosomePositional(tabixEntry)) {
            this.logMessage("Non-positional, non-variant catalog has unexpected non-empty tabix chromosome value of: " + tabixEntry.getChromosome(), LogLevel.WARNING);
        }
    }

    protected CatalogEntryGoldenJson validateRowGoldenJson(JsonObject catalogRowJson, boolean catalogIsPositional) {
        CatalogEntryGoldenJson catalogRowGolden = new CatalogEntryGoldenJson();
        try {
            String chr;
            Set<String> validChrs = null;
            if (this.mChrSizeMap != null && this.mChrSizeMap.size() > 0) {
                validChrs = this.mChrSizeMap.keySet();
            }
            if ((chr = VerifyCatalogUtils.validateGoldenJsonLandmark(catalogRowJson, catalogIsPositional, validChrs, this.mLogger)) != null) {
                catalogRowGolden.setChr(chr);
            }
            int jsonGolden_Minbp = -1;
            JsonPrimitive minBPPrim = VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_minBP");
            if (minBPPrim == null) {
                if (catalogIsPositional) {
                    this.logMessage("_minBP golden value is not in JSON String or is not a JsonPrimitive type, but is expected in positional catalog entry. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
                }
            } else if (!minBPPrim.isNumber()) {
                this.logMessage("_minBP golden value is not in JSON Number. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
            } else {
                jsonGolden_Minbp = minBPPrim.getAsInt();
                catalogRowGolden.setMinBP(jsonGolden_Minbp);
            }
            int jsonGolden_Maxbp = -1;
            JsonPrimitive maxBPPrim = VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_maxBP");
            if (maxBPPrim == null) {
                if (catalogIsPositional) {
                    this.logMessage("_maxBP golden value is not in JSON String or is not a JsonPrimitive type. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
                }
            } else if (!maxBPPrim.isNumber()) {
                this.logMessage("_maxBP golden value is not in JSON Number. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
            } else {
                jsonGolden_Maxbp = maxBPPrim.getAsInt();
                catalogRowGolden.setMaxBP(jsonGolden_Maxbp);
            }
        }
        catch (Exception e) {
            this.logMessage("Exception creating object from golden attributes. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
        }
        return catalogRowGolden;
    }

    protected boolean compareTabixToGoldenElements(CatalogTabixEntry tabixRowEntry, CatalogEntryGoldenJson goldenVariant, boolean catalogIsPositional) throws Exception {
        Integer jsonGoldenInt_maxBP;
        Integer jsonGoldenInt_minBP;
        String jsonLandmarkChr = goldenVariant.getChr();
        boolean rowChrIsPositional = VerifyCatalogUtils.isChromosomePositional(tabixRowEntry);
        if (catalogIsPositional) {
            if (rowChrIsPositional && !tabixRowEntry.getChromosome().equals(jsonLandmarkChr)) {
                this.logMessage("Tabix chr [" + tabixRowEntry.getChromosome() + "] not string-equal to _landmark golden value [" + jsonLandmarkChr + "], but is positional catalog entry and should be equal, and present.", LogLevel.ERROR);
                return false;
            }
        } else if (!rowChrIsPositional && jsonLandmarkChr != null && !tabixRowEntry.getChromosome().equals(jsonLandmarkChr)) {
            this.logMessage("Tabix chr [" + tabixRowEntry.getChromosome() + "] not equivalent to _landmark golden value [" + jsonLandmarkChr + "], for non-positional catalog entry and should be.", LogLevel.ERROR);
            return false;
        }
        if ((jsonGoldenInt_minBP = goldenVariant.getMinBP()) != null) {
            if (tabixRowEntry.getMinPosition().intValue() != jsonGoldenInt_minBP.intValue()) {
                this.logMessage("Tabix start position [" + tabixRowEntry.getMinPosition() + "] not equal to golden _minBP value [" + jsonGoldenInt_minBP + "].", LogLevel.ERROR);
                return false;
            }
        } else if (catalogIsPositional) {
            this.logMessage("Json Golden _minBP is null but catalog is positional.", LogLevel.ERROR);
            return false;
        }
        if ((jsonGoldenInt_maxBP = goldenVariant.getMaxBP()) != null) {
            if (tabixRowEntry.getMaxPosition().intValue() != jsonGoldenInt_maxBP.intValue()) {
                this.logMessage("Tabix start position [" + tabixRowEntry.getMaxPosition() + "] not equal to golden _maxBP value [" + jsonGoldenInt_maxBP + "].", LogLevel.ERROR);
                return false;
            }
        } else if (catalogIsPositional) {
            this.logMessage("Json Golden _maxBP is null but catalog is positional.", LogLevel.ERROR);
            return false;
        }
        if (catalogIsPositional) {
            if (tabixRowEntry.getMaxPosition() < tabixRowEntry.getMinPosition()) {
                this.logMessage("Tabix stop position [" + tabixRowEntry.getMaxPosition() + "] less than tabix start position [" + tabixRowEntry.getMinPosition() + "]. Invalid catalog format.", LogLevel.ERROR);
                return false;
            }
            if (jsonGoldenInt_minBP != null && jsonGoldenInt_maxBP != null && jsonGoldenInt_maxBP < jsonGoldenInt_minBP) {
                this.logMessage("Golden _maxBP stop position [" + jsonGoldenInt_maxBP + "] less than golden _minBP start value [" + jsonGoldenInt_minBP + "]. Invalid catalog format.", LogLevel.ERROR);
                return false;
            }
        }
        return true;
    }

    private boolean inChromosomeRange(String chr, int pos) {
        Integer chrSize = this.mChrSizeMap.get(chr);
        if (VerifyCatalogUtils.isEmpty(chr)) {
            this.logMessage("Chromosome value is empty. Cannot check position [" + pos + "] for chromosome value.", LogLevel.ERROR);
            return false;
        }
        if (chrSize == null) {
            this.logMessage("Chromosome value not found in chromosome size map: " + chr + " Cannot check position [" + pos + "] for chromosome value.", LogLevel.ERROR);
            return false;
        }
        return pos >= 1 && pos <= chrSize;
    }

    protected void validateRowJson(String catalogRowJsonStr, JsonObject catalogRowJsonObj) throws Exception {
        JsonReader jsonRdrFromTabix = new JsonReader((Reader)new InputStreamReader(new ByteArrayInputStream(catalogRowJsonStr.getBytes("UTF-8"))));
        boolean keysAndQuotingValid = this.traverseJsonForInvalidJson(jsonRdrFromTabix);
        jsonRdrFromTabix.close();
        if (!keysAndQuotingValid) {
            this.logMessage("ERROR: Catalog row json has invalid elements: " + catalogRowJsonStr, LogLevel.ERROR);
        }
        if (this.mCatalogColumns != null && this.mCatalogColumns.keySet().size() > 0) {
            List<String> jsonKeysNotFoundInColInfo;
            List<String> columnsNotFoundInJson = this.traverseJsonByColumn(catalogRowJsonObj, this.mCatalogColumns);
            if (columnsNotFoundInJson.size() > 0) {
                for (String jsonKey : columnsNotFoundInJson) {
                    if (this.mCatalogColsNotFoundInSomeJsonRows.indexOf(jsonKey) >= 0) continue;
                    this.mCatalogColsNotFoundInSomeJsonRows.add(jsonKey);
                }
            }
            if ((jsonKeysNotFoundInColInfo = this.traverseJsonByJsonKey(catalogRowJsonObj, this.mCatalogColumns)).size() > 0) {
                for (String jsonKey : this.mJsonKeysNotFoundInColumnsTsv) {
                    if (this.mJsonKeysNotFoundInColumnsTsv.indexOf(jsonKey) >= 0) continue;
                    this.mJsonKeysNotFoundInColumnsTsv.add(jsonKey);
                }
            }
        } else {
            this.logMessage("Unable to check Row's JSON by Catalog columns.tsv info, or by Json key. No columns.tsv info was found for catalog.", LogLevel.WARNING);
        }
    }

    protected List<String> traverseJsonByColumn(JsonObject catalogRowJsonObj, HashMap<String, ColumnMetaData> columnInfo) throws Exception {
        ArrayList<String> columnsNotFoundInJson = new ArrayList<String>();
        String curColNameChecking = null;
        try {
            Iterator<String> i$ = columnInfo.keySet().iterator();
            while (i$.hasNext()) {
                String colName;
                curColNameChecking = colName = i$.next();
                Object jsonObjFound = this.getJsonValueForCatalogColumn(colName, catalogRowJsonObj, columnInfo.get(colName));
                if (jsonObjFound == null) {
                    columnsNotFoundInJson.add(colName);
                    continue;
                }
                this.incrementNumberOfTimesKeySeenInCatalog(columnInfo.get(colName).getColumnName());
            }
        }
        catch (MalformedJsonException jsonExc) {
            String msg = "Exception parsing thru Json for Catalog Column [" + curColNameChecking + "] & Row: Exception: " + jsonExc.getMessage();
            System.err.println(msg);
            this.logMessage(msg, LogLevel.ERROR);
            return null;
        }
        catch (Exception e) {
            String msg = "Exception parsing thru Json for Catalog Column [" + curColNameChecking + "] & Row: Exception: " + e.getMessage();
            System.err.println(msg);
            this.logMessage(msg, LogLevel.ERROR);
            return null;
        }
        return columnsNotFoundInJson;
    }

    protected List<String> traverseJsonByJsonKey(JsonObject catalogRowJsonObj, HashMap<String, ColumnMetaData> columnKeyToMetaMap) throws Exception {
        return this.traverseJsonByJsonKey(catalogRowJsonObj, columnKeyToMetaMap, null);
    }

    protected List<String> traverseJsonByJsonKey(JsonObject catalogRowJsonObj, HashMap<String, ColumnMetaData> columnKeyToMetaMap, String parentJsonKeyName) throws Exception {
        ArrayList<String> jsonObjsNotInColumnInfo = new ArrayList<String>();
        Object currentJsonObj = null;
        for (Map.Entry thisEntry : catalogRowJsonObj.entrySet()) {
            JsonElement nextJsonElement;
            String nextJsonKey = (String)thisEntry.getKey();
            currentJsonObj = this.getJavaObjForJSON(nextJsonKey, nextJsonElement = (JsonElement)thisEntry.getValue(), columnKeyToMetaMap, jsonObjsNotInColumnInfo);
            if (currentJsonObj == null && !nextJsonElement.isJsonObject()) {
                this.logMessage("No Java Object could be created for Json Object: JSON Key [" + nextJsonKey + "] JSON Element [" + nextJsonElement.toString() + "] .", LogLevel.WARNING);
            }
            if (currentJsonObj == null) continue;
            boolean foundCatColNameForJson = false;
            String curKey = null;
            String matchedCatalogColNm = null;
            for (String definedColName : columnKeyToMetaMap.keySet()) {
                if (parentJsonKeyName != null) {
                    curKey = parentJsonKeyName + '.' + nextJsonKey;
                    Pattern keyCombo = Pattern.compile(parentJsonKeyName + "\\." + nextJsonKey + "(\\.|$)");
                    Matcher keyComMatcher = keyCombo.matcher(definedColName);
                    if (!keyComMatcher.matches()) continue;
                    foundCatColNameForJson = true;
                    matchedCatalogColNm = definedColName;
                    break;
                }
                curKey = nextJsonKey;
                if (!definedColName.equals(curKey)) continue;
                foundCatColNameForJson = true;
                matchedCatalogColNm = definedColName;
                break;
            }
            if (!foundCatColNameForJson || matchedCatalogColNm == null) {
                jsonObjsNotInColumnInfo.add(curKey);
                this.logMessage("No Catalog Column Name found for Json Object Found: JSON [" + nextJsonElement.toString() + "] JSON Key [" + curKey + "].", LogLevel.ERROR);
                continue;
            }
            ColumnMetaData catColumnDefinition = columnKeyToMetaMap.get(matchedCatalogColNm);
            if (catColumnDefinition == null) {
                this.logMessage("Catalog column name [" + matchedCatalogColNm + "] not found in catalog column map. Cannot check data type.", LogLevel.WARNING);
                continue;
            }
            if (this.dataTypesMatch(currentJsonObj, catColumnDefinition)) continue;
            String msg = "Data type does not match between json [" + currentJsonObj.getClass().getName() + "] and columns.tsv [" + catColumnDefinition.getType() + "] for matched catalog column key: " + matchedCatalogColNm + "\n";
            this.logMessage(msg, LogLevel.ERROR);
        }
        return jsonObjsNotInColumnInfo;
    }

    protected Object getJavaObjForJSON(String jsonKey, JsonElement jsonElement, HashMap<String, ColumnMetaData> columnKeyToMetaMap, List<String> jsonObjectsNotInColumnInfoMap) throws Exception {
        Object currentJsonObj = null;
        if (jsonKey.contains(".")) {
            this.logMessage("JSON key has a period within it; This is not recommended. Key: " + jsonKey, LogLevel.WARNING);
        }
        if (jsonElement.isJsonNull()) {
            this.logMessage("traverseJsonByJsonKeyset(): json value is a JSON-null for key: " + jsonKey, LogLevel.WARNING);
        } else if (jsonElement.isJsonObject()) {
            currentJsonObj = jsonElement.getAsJsonObject();
            List<String> jsonKeysNotFoundInCols = this.traverseJsonByJsonKey(jsonElement.getAsJsonObject(), columnKeyToMetaMap, jsonKey);
            if (jsonKeysNotFoundInCols != null && jsonKeysNotFoundInCols.size() > 0) {
                jsonObjectsNotInColumnInfoMap.addAll(jsonKeysNotFoundInCols);
            }
            currentJsonObj = null;
        } else if (jsonElement.isJsonArray()) {
            JsonArray jsonArrVal = jsonElement.getAsJsonArray();
            currentJsonObj = jsonArrVal;
        } else if (jsonElement.isJsonPrimitive()) {
            String strVal;
            JsonPrimitive jsonPrimVal = jsonElement.getAsJsonPrimitive();
            if (jsonPrimVal.isBoolean()) {
                Boolean boolVal = jsonPrimVal.getAsBoolean();
                currentJsonObj = boolVal;
            } else if (jsonPrimVal.isNumber()) {
                currentJsonObj = this.jsonNumberToJavaNumber(jsonPrimVal);
            } else if (jsonPrimVal.isString() && (strVal = jsonPrimVal.getAsString()) != null) {
                currentJsonObj = strVal;
            }
        } else {
            this.logMessage("traverseJsonByJsonKeyset(): haven't found a json datatype for json key: " + jsonKey, LogLevel.ERROR);
            currentJsonObj = null;
        }
        return currentJsonObj;
    }

    protected boolean dataTypesMatch(Object jsonObj, ColumnMetaData columnDefinition) {
        ColumnMetaData.Type definedDataType = columnDefinition.getType();
        String definedCount = columnDefinition.getCount();
        if (jsonObj instanceof Boolean && definedDataType.equals((Object)ColumnMetaData.Type.Boolean)) {
            return true;
        }
        if ((jsonObj instanceof Integer || jsonObj instanceof Long) && definedDataType.equals((Object)ColumnMetaData.Type.Integer)) {
            return true;
        }
        return jsonObj instanceof String && definedDataType.equals((Object)ColumnMetaData.Type.String) ? definedCount.equals("1") : jsonObj instanceof JsonArray && definedCount.equals(".");
    }

    private Object getJsonValueForCatalogColumn(String columnName, JsonObject jsonObj, ColumnMetaData catalogCol) throws Exception {
        String[] columnNameElems = null;
        if (!columnName.contains(".")) {
            columnNameElems = new String[]{columnName};
        } else {
            columnNameElems = columnName.split("\\.");
            if (columnNameElems.length < 1) {
                String msg = "Bad column name format. Less than one element: " + columnName;
                throw new Exception(msg);
            }
        }
        try {
            Object currentJsonObj = jsonObj;
            Iterator<String> columnNameElemItr = Arrays.asList(columnNameElems).iterator();
            while (columnNameElemItr.hasNext()) {
                String colElem = columnNameElemItr.next();
                JsonElement jsonElem = null;
                if (currentJsonObj instanceof JsonObject) {
                    JsonObject currentJson = currentJsonObj;
                    jsonElem = currentJson.get(colElem);
                }
                if (jsonElem == null) {
                    return null;
                }
                if (jsonElem.isJsonObject()) {
                    JsonObject embeddedJsonObj = jsonElem.getAsJsonObject();
                    if (embeddedJsonObj == null) {
                        this.logMessage("Embedded json object retrieval was null for column name [" + columnName + "] and column name element[" + colElem + "].", LogLevel.WARNING);
                        return null;
                    }
                    if (!columnNameElemItr.hasNext()) {
                        return embeddedJsonObj;
                    }
                    String nextColNameElement = columnNameElemItr.next();
                    Object foundObj = this.getJsonValueForCatalogColumn(nextColNameElement, embeddedJsonObj, catalogCol);
                    currentJsonObj = foundObj;
                } else if (jsonElem.isJsonArray()) {
                    JsonArray jsonArr = jsonElem.getAsJsonArray();
                    currentJsonObj = jsonArr;
                    this.setMaxValuesForKeyIfGreater(catalogCol.getColumnName(), jsonArr.size());
                } else if (jsonElem.isJsonPrimitive()) {
                    JsonPrimitive jsonPrim = jsonElem.getAsJsonPrimitive();
                    if (jsonPrim.isJsonNull()) {
                        currentJsonObj = jsonPrim;
                    } else if (jsonPrim.isBoolean()) {
                        currentJsonObj = jsonPrim.getAsBoolean();
                    } else if (jsonPrim.isNumber()) {
                        String numStr = jsonPrim.getAsString();
                        currentJsonObj = !this.isValidInteger(numStr, catalogCol.getType()) ? (Number)jsonPrim.getAsDouble() : (Number)jsonPrim.getAsInt();
                    } else if (jsonPrim.isString()) {
                        currentJsonObj = jsonPrim.getAsString();
                        String strVal = (String)currentJsonObj;
                        if (!this.isQuotedString(strVal)) {
                            this.logMessage("getJsonForCatalogColumn(): Invalid JSON formatting: json string value [" + strVal + "] is not quoted.", LogLevel.ERROR);
                        }
                    } else {
                        if (jsonPrim.isJsonObject()) {
                            throw new RuntimeException("ERROR: getJsonForCatalogColumn(): column element name: " + colElem + " WARNING: Embedded JsonObject is Json primitive but says it is a json object too. Not expecting this.");
                        }
                        if (jsonPrim.isJsonArray()) {
                            throw new RuntimeException("ERROR: getJsonForCatalogColumn(): column element name: " + colElem + " WARNING: Embedded JsonObject is Json primitive but says it is a json array too. Not expecting this.");
                        }
                    }
                }
                if (currentJsonObj != null && columnNameElemItr.hasNext()) continue;
                this.incrementNumberOfTimesKeySeenInCatalog(catalogCol.getColumnName());
                return currentJsonObj;
            }
        }
        catch (MalformedJsonException jsonExc) {
            jsonExc.printStackTrace();
            this.logMessage("Exception parsing thru Json for row: Exception: " + jsonExc.getMessage() + " Column Name: " + columnName + " Json row value: " + jsonObj.toString(), LogLevel.ERROR);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logMessage("Exception parsing thru Json for row: Exception: " + e.getMessage() + " Column Name: " + columnName + " Json row value: " + jsonObj.toString(), LogLevel.ERROR);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean traverseJsonForInvalidJson(JsonReader rdr) throws Exception {
        boolean foundAllValidJson = true;
        String currentPropName = null;
        try {
            if (rdr.isLenient()) {
                String msg = "Raising Exception in traverseJsonToCheckForInvalidJson(): Json Reader is set to lenient. Validation needs the reader set to strict checking for this method to perform checks adequately.";
                System.err.println(msg);
                rdr.close();
                throw new Exception(msg);
            }
            rdr.beginObject();
            while (rdr.hasNext()) {
                Object valueFromJson;
                currentPropName = rdr.nextName();
                if (currentPropName.contains(".")) {
                    this.logMessage("traverseJsonForInvalidJson(): Period in json property name: " + currentPropName, LogLevel.WARNING);
                    foundAllValidJson = false;
                }
                if (rdr.peek() == JsonToken.NAME || (valueFromJson = this.readNextJsonTokenValue(rdr, currentPropName)) != null) continue;
                this.logMessage("traverseJsonForInvalidJson()/readNextJsonTokenValue(): Did not return a json value for json property name: " + currentPropName, LogLevel.WARNING);
                foundAllValidJson = false;
            }
            rdr.endObject();
        }
        catch (MalformedJsonException mal) {
            String msg = "MalformedJsonException parsing JSON property name [" + currentPropName + "].";
            this.logMessage(msg, LogLevel.WARNING);
            foundAllValidJson = false;
        }
        catch (Exception e) {
            String msg = "Exception parsing JSON property name [" + currentPropName + "].";
            this.logMessage(msg, LogLevel.WARNING);
            foundAllValidJson = false;
        }
        return foundAllValidJson;
    }

    private void reportColumnUsage() {
        if (this.mCatalogColumns == null || this.mCatalogColumns.keySet().size() == 0) {
            this.logMessage("Catalog columns.tsv information is not set. Cannot report usage stats.", LogLevel.WARNING);
            return;
        }
        LogLevel entryLogLvl = null;
        for (String colName : this.mCatalogColumns.keySet()) {
            ColumnMetaData catCol = this.mCatalogColumns.get(colName);
            StringBuffer msgBuf = new StringBuffer();
            msgBuf.append("Catalog Column: " + colName);
            int numTimesInCatalog = this.getNumberOfTimesKeySeenInCatalog(colName);
            if (numTimesInCatalog == 0) {
                entryLogLvl = LogLevel.WARNING;
                msgBuf.append("\tThis column was not found in the catalog. Consider removing it from the columns.tsv file.");
            } else {
                entryLogLvl = LogLevel.INFO;
                msgBuf.append("\tNumber of occurrences in catalog: " + numTimesInCatalog);
            }
            ColumnMetaData colDefn = this.mCatalogColumns.get(colName);
            if (colDefn.getType().equals((Object)ColumnMetaData.Type.String) && colDefn.getCount().equals(".")) {
                msgBuf.append("\tLargest number of elements found for array column: " + this.getMaxValuesForKey(catCol.getColumnName()));
            }
            this.logMessage(msgBuf.toString(), entryLogLvl);
        }
    }

    private Object readNextJsonTokenValue(JsonReader rdr, String currentPropName) throws Exception {
        Serializable jsonValue = null;
        try {
            JsonToken jsonToken = rdr.peek();
            if (currentPropName.equals("_altAlleles") && !jsonToken.equals((Object)JsonToken.BEGIN_ARRAY)) {
                this.logMessage("data type of _altAlleles is not an array.", LogLevel.WARNING);
            }
            if (jsonToken == JsonToken.NULL) {
                this.logMessage("Value null or empty for property name: " + currentPropName + " skipping it...", LogLevel.WARNING);
                rdr.skipValue();
            } else if (jsonToken == JsonToken.BEGIN_ARRAY) {
                ArrayList<Object> arrayElements = new ArrayList<Object>();
                int idx = 0;
                rdr.beginArray();
                while (rdr.hasNext()) {
                    arrayElements.add(this.readNextJsonTokenValue(rdr, currentPropName + "_" + idx));
                    ++idx;
                }
                rdr.endArray();
                jsonValue = arrayElements.size() > 0 ? arrayElements : null;
            } else if (jsonToken == JsonToken.BEGIN_OBJECT) {
                boolean successfullyParsedEmbeddedObj = this.traverseJsonForInvalidJson(rdr);
                jsonValue = !successfullyParsedEmbeddedObj ? null : new Boolean(successfullyParsedEmbeddedObj);
            } else if (jsonToken == JsonToken.NUMBER) {
                String numStr = rdr.nextString();
                jsonValue = numStr.contains(".") ? (Number)new Double(numStr) : (Number)new Integer(numStr);
            } else if (jsonToken == JsonToken.STRING) {
                String s = rdr.nextString();
                jsonValue = s;
            } else if (jsonToken == JsonToken.BOOLEAN) {
                jsonValue = rdr.nextBoolean();
            }
        }
        catch (MalformedJsonException mal) {
            this.logMessage("MalformedJsonException parsing JSON property name [" + currentPropName + "].", LogLevel.ERROR);
        }
        catch (Exception e) {
            this.logMessage("Exception parsing JSON property name [" + currentPropName + "].", LogLevel.ERROR);
        }
        return jsonValue;
    }

    private String getCatalogNamePrefix() {
        return this.mCatalogPrefix;
    }

    private void setCatalogNamePrefix(File catalogFile) {
        if (catalogFile == null) {
            return;
        }
        String basename = catalogFile.getName();
        String catalogNamePrefix = null;
        if (!VerifyCatalogUtils.isEmpty(basename) && basename.endsWith(".tsv.bgz")) {
            int indexOfCatalogSuffix = basename.indexOf(".tsv.bgz");
            if (indexOfCatalogSuffix != -1 && indexOfCatalogSuffix + ".tsv.bgz".length() == basename.length()) {
                catalogNamePrefix = basename.substring(0, basename.indexOf(".tsv.bgz"));
                if (catalogNamePrefix != null && catalogNamePrefix.length() > 0) {
                    this.mCatalogPrefix = catalogNamePrefix;
                }
            } else {
                this.logMessage("Catalog file [" + basename + "] may not have expected file extension. Unable to parse catalog name prefix from suffix expected [" + ".tsv.bgz" + "].", LogLevel.ERROR);
            }
        } else {
            this.logMessage("Catalog file [" + basename + "] does not have expected file extension of: " + ".tsv.bgz", LogLevel.ERROR);
        }
    }

    private String getCatalogDir() {
        return this.mCatalogDir;
    }

    private void setCatalogDir(File catalogFile) {
        File catDir = catalogFile.getAbsoluteFile().getParentFile();
        if (!catDir.isDirectory()) {
            return;
        }
        this.mCatalogDir = catDir.getAbsolutePath();
    }

    protected UniqOrderedMessageLogger getLogger() {
        return this.mLogger;
    }

    protected void setLogger(UniqOrderedMessageLogger l) {
        this.mLogger = l;
    }

    protected void logMessage(String msg, LogLevel logLevel) {
        if (this.mLogger != null) {
            this.mLogger.logMessage(msg, logLevel);
        } else {
            System.err.println(msg);
        }
    }

    private boolean isValidInteger(String intStrValue, ColumnMetaData.Type type) {
        if (type.equals((Object)ColumnMetaData.Type.Integer)) {
            try {
                Integer intVal = new Integer(intStrValue);
                if (intVal % 1 != 0) {
                    return false;
                }
                if (intVal >= Integer.MIN_VALUE && intVal <= Integer.MAX_VALUE) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private boolean isValidLong(String longStrValue, String catalogDataType) {
        if (catalogDataType.equalsIgnoreCase("Long")) {
            try {
                Long longVal = new Long(longStrValue);
                if (longVal % 1L != 0L) {
                    return false;
                }
                if (longVal >= Long.MIN_VALUE && longVal <= Long.MAX_VALUE) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected Object jsonNumberToJavaNumber(JsonPrimitive jsonNumber) {
        Number correctInstanceOfJavaNumber = null;
        Number num = this.stringToJavaNumber(jsonNumber.getAsString());
        if (num instanceof Long) {
            correctInstanceOfJavaNumber = (Long)num;
        } else if (num instanceof Integer) {
            correctInstanceOfJavaNumber = (Integer)num;
        } else if (num instanceof BigDecimal) {
            correctInstanceOfJavaNumber = (BigDecimal)num;
        } else if (num instanceof Double) {
            correctInstanceOfJavaNumber = (Double)num;
        }
        return correctInstanceOfJavaNumber;
    }

    protected Number stringToJavaNumber(String value) {
        if (!value.contains(".")) {
            try {
                long longValue = Long.parseLong(value);
                if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException longValue) {
                // empty catch block
            }
        }
        try {
            Double valueAsADouble = Double.parseDouble(value);
            Float valueAsFloat = Float.valueOf(Float.parseFloat(value));
            if (valueAsADouble >= (double)1.4E-45f && valueAsADouble <= 3.4028234663852886E38) {
                return valueAsFloat;
            }
            return valueAsADouble;
        }
        catch (NumberFormatException nf) {
            return new BigDecimal(value);
        }
    }

    private boolean isQuotedString(String str) {
        if (str == null) {
            return false;
        }
        return !str.startsWith("\"") || !str.endsWith("\"");
    }

    private void initHumanReferenceInfo(File catalogFile, String chromosomeSizesFileName, String chromosomeOrderFileFileName, UniqOrderedMessageLogger logger) throws VerifierInputException {
        if (chromosomeSizesFileName == null || chromosomeSizesFileName.length() <= 0) {
            throw new VerifierInputException("Chromosome-size file specified is not valid. Cannot validate catalog positional elements without this file.");
        }
        if (chromosomeOrderFileFileName == null || chromosomeOrderFileFileName.length() <= 0) {
            throw new VerifierInputException("Chromosome-order file specified is not valid. Cannot validate catalog positional elements without this file.");
        }
        File tabixIndexFile = new File(this.getCatalogDir() + File.separator + this.getCatalogNamePrefix() + ".tsv.bgz.tbi");
        if (!FileUtils.fileExists(tabixIndexFile)) {
            logger.logMessage("Cannot check to ensure tabix file is newer than catalog file. The tabix file not exist: " + tabixIndexFile.getAbsolutePath(), LogLevel.ERROR);
        } else if (catalogFile.lastModified() > tabixIndexFile.lastModified()) {
            logger.logMessage("Tabix index file timestamp is older than the catalog file itself: " + tabixIndexFile.getAbsolutePath(), LogLevel.ERROR);
        }
        this.mChrSizeMap = this.initChrSizes(chromosomeSizesFileName);
        if (this.mChrSizeMap == null || this.mChrSizeMap.size() == 0) {
            throw new VerifierInputException("Chromosome-size map is empty. Cannot validate catalog positional elements without this info. File specified: " + chromosomeSizesFileName);
        }
        this.mExpectedChrOrderList = this.initChrOrder(chromosomeOrderFileFileName);
        if (this.mExpectedChrOrderList == null || this.mExpectedChrOrderList.size() == 0) {
            throw new VerifierInputException("Chromosome-order list is null or empty. Cannot validate catalog positional elements without this info. mExpectedChrOrderList=" + this.mExpectedChrOrderList.toString());
        }
        String timeStamp = new SimpleDateFormat("MM.dd.yyyy 'at' HH:mm:ss z").format(Calendar.getInstance().getTime());
        System.out.println("Starting Variant Catalog Validation. Date/Time: " + timeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TreeMap<String, Integer> initChrSizes(String genomeRefChrSizeFileNm) {
        if (genomeRefChrSizeFileNm == null) return null;
        if (genomeRefChrSizeFileNm.length() <= 0) {
            return null;
        }
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(genomeRefChrSizeFileNm));
            String n2332 = null;
            while ((n2332 = r.readLine()) != null) {
                String[] elems = n2332.trim().split("\t");
                if (elems.length != 2) {
                    r.close();
                    throw new Exception("genome chromosome size file not in format execpted. Not two columns in file: " + genomeRefChrSizeFileNm);
                }
                String chr = null;
                Integer iPos = null;
                try {
                    chr = elems[0].trim().replace("chr", "");
                }
                catch (Exception e) {
                    chr = null;
                }
                try {
                    iPos = new Integer(elems[1].trim());
                }
                catch (Exception e) {
                    iPos = null;
                }
                if (chr == null || iPos == null) continue;
                map.put(chr, iPos);
            }
        }
        catch (Throwable t) {
            try {
                TreeMap<String, Integer> treeMap = null;
                return treeMap;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        try {
            if (r == null) return map;
            r.close();
            return map;
        }
        catch (Exception n2332) {
            return map;
        }
    }

    private List<String> initChrOrder(String orderedChrFileName) throws VerifierInputException {
        ArrayList<String> orderedChrExpecting = new ArrayList<String>();
        BufferedReader r = null;
        try {
            r = FileUtils.getBufferedReader(orderedChrFileName);
            String l = null;
            while ((l = r.readLine()) != null) {
                String ln = l.trim();
                if (ln.length() <= 0) continue;
                String chrVal = "";
                if (ln.startsWith("chr")) {
                    chrVal = ln.replace("chr", "");
                }
                orderedChrExpecting.add(chrVal);
            }
        }
        catch (IOException io) {
            throw new VerifierInputException("Unable to read and initialize chromosome order file: " + orderedChrFileName);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return orderedChrExpecting;
    }

    private boolean isPositionalCatalog(File catalogFile, List<String> validChromosomes) throws VerifierExecutionException {
        String msg;
        int linesChecked = 0;
        int linesRead = 0;
        int numNonPositonalTabixEntries = 0;
        int numPositionalTabixEntries = 0;
        int numUnexpectedFormat = 0;
        boolean numJSONOnly = false;
        try {
            BufferedReader catalogRdr = FileUtils.getBufferedReader(catalogFile.getCanonicalPath());
            String curCatalogRow = null;
            while ((curCatalogRow = catalogRdr.readLine()) != null) {
                if (curCatalogRow.startsWith("#")) continue;
                if (++linesRead < 20000) {
                    ++linesChecked;
                    CatalogTabixEntry thisTabixEntry = VerifyCatalogUtils.readCatalogRow(curCatalogRow, this.getLogger());
                    if (!(VerifyCatalogUtils.isChromosomePositional(thisTabixEntry) || VerifyCatalogUtils.isMinBPPositional(thisTabixEntry) || VerifyCatalogUtils.isMaxBPPositional(thisTabixEntry))) {
                        ++numNonPositonalTabixEntries;
                        continue;
                    }
                    if (VerifyCatalogUtils.isChromosomePositional(thisTabixEntry) && VerifyCatalogUtils.isMinBPPositional(thisTabixEntry) && VerifyCatalogUtils.isMaxBPPositional(thisTabixEntry)) {
                        ++numPositionalTabixEntries;
                        continue;
                    }
                    ++numUnexpectedFormat;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new VerifierExecutionException("isPositionalCatalog(): Exception while determining whether catalog is positional: catalog: " + catalogFile.getAbsolutePath() + " Exception: " + e.getMessage());
        }
        boolean looksPositional = true;
        if (numUnexpectedFormat == 0 && numNonPositonalTabixEntries == linesChecked) {
            looksPositional = false;
        } else if (numUnexpectedFormat == 0 && numPositionalTabixEntries == linesChecked) {
            msg = "Catalog appears to be positionial. Number lines checked: " + linesChecked + " Number of those lines with positional tabix entries: " + numPositionalTabixEntries;
            this.getLogger().logMessage(msg, LogLevel.INFO);
            looksPositional = true;
        } else if (numUnexpectedFormat == 0 && numPositionalTabixEntries > numNonPositonalTabixEntries) {
            msg = "Catalog appears to be positionial. \n\t Number lines checked: " + linesChecked + "\n\t Number of those lines with positional tabix entries: " + numPositionalTabixEntries + "\n\t Number of those lines with non-positional tabix entries: " + numNonPositonalTabixEntries;
            this.getLogger().logMessage(msg, LogLevel.INFO);
            looksPositional = true;
        } else {
            looksPositional = false;
            throw new VerifierExecutionException("WARNING: isPositionalCatalog() failed to determine whether catalog is positional. " + catalogFile.getAbsolutePath() + " linesChecked=" + linesChecked + " numUnexpectedFormat=" + numUnexpectedFormat);
        }
        return looksPositional;
    }

    private WholeCatalogValidationThread startCatalogOrderCheckingThread(boolean isPositionalCatalog, BufferedWriter logWtr) {
        WholeCatalogValidationThread orderCheckThread = new WholeCatalogValidationThread();
        orderCheckThread.setExpectedChrOrderList(this.mExpectedChrOrderList);
        orderCheckThread.setCatalogFileName(this.mCatalogFile.getAbsolutePath());
        orderCheckThread.setBiorIndexMap(this.mBIORIndexMap_colNameToFilePath);
        orderCheckThread.setPositionalCatalogIndicator(isPositionalCatalog);
        orderCheckThread.setLogWriter(logWtr);
        orderCheckThread.start();
        return orderCheckThread;
    }

    private void incrementNumberOfTimesKeySeenInCatalog(String key) {
        Integer numTimesSeen = this.mNumberOfTimesKeySeenInCatalog.get(key);
        if (numTimesSeen == null) {
            this.mNumberOfTimesKeySeenInCatalog.put(key, 1);
        } else {
            this.mNumberOfTimesKeySeenInCatalog.put(key, numTimesSeen + 1);
        }
    }

    private int getNumberOfTimesKeySeenInCatalog(String key) {
        Integer numTimesSeen = this.mNumberOfTimesKeySeenInCatalog.get(key);
        if (numTimesSeen == null) {
            return 0;
        }
        return numTimesSeen;
    }

    private void setMaxValuesForKeyIfGreater(String key, int numValues) {
        Integer maxValues = this.mMaxValuesForKey.get(key);
        if (maxValues == null) {
            this.mMaxValuesForKey.put(key, numValues);
        } else if (numValues > maxValues) {
            this.mMaxValuesForKey.put(key, numValues);
        }
    }

    private int getMaxValuesForKey(String key) {
        Integer maxValues = this.mMaxValuesForKey.get(key);
        if (maxValues == null) {
            return 0;
        }
        return maxValues;
    }

    public static void main(String[] args) {
        String catalogFilePath = BASEDIR_TEST + "/bsi/catalogs/bior/v1/dbSNP/142_GRCh37.p13/variants_nodups.v2/00-All.vcf.tsv.bgz";
        catalogFilePath = BASEDIR_TEST + "/bsi/catalogs/bior/v1/omim/2014_01_13/genemap_GRCh37.tsv.bgz";
        catalogFilePath = BASEDIR_TEST + "/bsi/bioinf_int/s110048.catalog_building/omim/GRCh37/2016_04_27/ensembl_gtf/omim_genemap_ensembl_gtf.tsv.bgz";
        catalogFilePath = BASEDIR_TEST + "/bsi/BORA/Testing/jaj/bior/omim/omim_genemap_ensembl_gtf.tsv.bgz";
        VerifyCatalogBase catalogValidator = new VerifyCatalogBase();
        try {
            catalogValidator.verify(catalogFilePath, VAL_TYPE.STRICT, catalogValidator.apacheLogger);
        }
        catch (Exception e) {
            System.err.println("Exception raised in ValidateCatalogCommand: " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static enum VAL_TYPE {
        LENIENT,
        STRICT;

    }
}

