/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepExecuteException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.catalog.Catalog;
import edu.mayo.bior.cli.cmd.CreateCatalogPropsCommand;
import edu.mayo.bior.util.validation.CatalogFileValidator;
import edu.mayo.cli.InvalidDataException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class CreatePropFilesStep
implements BuildCatalogStepInterface {
    private BuildInfo mBuildInfo = null;
    private StepLogger mStepLogger = null;
    private String mCatalogDirectoryPath = null;
    private String mCatalogFilePath = null;
    private String mDataSrcFilePath = null;
    private String mColumnsTsvFilePath = null;
    private String mBlacklistFilePath = null;
    private String mBlacklistBiowebFilePath = null;

    public CreatePropFilesStep(BuildInfo buildInfo, StepLogger stepLogger) throws IOException {
        this.mBuildInfo = buildInfo;
        this.mStepLogger = stepLogger;
        this.init(this.mBuildInfo);
    }

    @Override
    public void execute() throws BuildCatalogStepInputException, BuildCatalogStepExecuteException {
        this.mStepLogger.log("Starting create catalog property files step :\n");
        this.mStepLogger.log("------------------------------------\n");
        this.mStepLogger.log("Create catalog property files step: Checking inputs... \n");
        this.checkInput();
        this.mStepLogger.log("Create catalog property files step: creating property files ... \n");
        CreateCatalogPropsCommand cmd = new CreateCatalogPropsCommand();
        try {
            cmd.execNoCmd(this.mCatalogFilePath, null, this.mCatalogDirectoryPath, false);
        }
        catch (InvalidDataException cliInvalidDataException) {
            throw new BuildCatalogStepExecuteException("Error executing creating catalog property files: " + cliInvalidDataException.getMessage());
        }
        catch (IOException ioe) {
            throw new BuildCatalogStepExecuteException("IO Exception occurred: " + ioe.getMessage());
        }
        catch (URISyntaxException e) {
            throw new BuildCatalogStepExecuteException("CreatePropFilesStep.execute(): Expected output file not found for catalog [" + this.mCatalogFilePath + "]:" + "Exception: " + e.getMessage());
        }
        catch (Exception e) {
            throw new BuildCatalogStepExecuteException("CreatePropFilesStep.execute(): Unexpected exception Error creating properties files: " + e.getMessage());
        }
        this.mStepLogger.log("Create catalog property files step: Checking outputs ... \n");
        this.checkOutput();
        this.mStepLogger.log("Create catalog property files step completed.\n");
        this.mStepLogger.log("------------------------------------\n");
    }

    private void init(BuildInfo buildInfo) throws IOException {
        this.mCatalogFilePath = buildInfo.getTargetDirectory() + "/" + buildInfo.getCatalogPrefix() + ".tsv.bgz";
    }

    private void checkInput() throws BuildCatalogStepInputException {
        File catalogFile = new File(this.mCatalogFilePath);
        if (!CatalogFileValidator.catalogExists(catalogFile)) {
            throw new BuildCatalogStepInputException("CreateMetadataStep.checkInput(): Catalog file is not a valid file. Please check catalog build, create catalog step results.");
        }
        if (!CatalogFileValidator.hasExpectedSuffix(catalogFile)) {
            throw new BuildCatalogStepInputException("CreateMetadataStep.checkInput(): Catalog file is not a valid file. Does not have expected catalog file name suffix.");
        }
        File catalogDir = null;
        try {
            catalogDir = catalogFile.getCanonicalFile().getParentFile();
            if (catalogDir != null) {
                if (!catalogDir.isDirectory() || !catalogDir.canWrite()) {
                    throw new BuildCatalogStepInputException("Acquired catalog directory doesn't appear to be a valid, writable directory: " + catalogDir.getAbsolutePath());
                }
                this.mCatalogDirectoryPath = catalogDir.getAbsolutePath();
                if (this.mCatalogDirectoryPath == null) {
                    throw new BuildCatalogStepInputException("CreateMetadataStep.checkInput(): Could not successfully set parent directory of catalog file: " + this.mCatalogFilePath);
                }
            }
        }
        catch (IOException io) {
            throw new BuildCatalogStepInputException("Not able to acquire catalog directory from catalog file name: " + this.mCatalogFilePath);
        }
        String catalogFilePrefix = Catalog.getCatalogPrefix(this.mCatalogFilePath);
        if (catalogFilePrefix == null) {
            throw new BuildCatalogStepInputException("IndexesStep.checkInput(): catalog file not valid suffix [" + this.mCatalogFilePath + "]. Please check catalog file name.");
        }
        this.mDataSrcFilePath = this.mCatalogDirectoryPath + "/" + catalogFilePrefix + ".datasource.properties";
        this.backupToNumeric(this.mDataSrcFilePath);
        this.mColumnsTsvFilePath = this.mCatalogDirectoryPath + "/" + catalogFilePrefix + ".columns.tsv";
        this.backupToNumeric(this.mColumnsTsvFilePath);
        this.mBlacklistFilePath = this.mCatalogDirectoryPath + "/" + catalogFilePrefix + ".columns.tsv.blacklist";
        this.backupToNumeric(this.mBlacklistFilePath);
        this.mBlacklistBiowebFilePath = this.mCatalogDirectoryPath + "/" + catalogFilePrefix + ".columns.tsv.blacklist.biorweb";
        this.backupToNumeric(this.mBlacklistBiowebFilePath);
    }

    private void checkOutput() throws BuildCatalogStepExecuteException {
        StringBuilder outputCheckMsg = new StringBuilder();
        String msgBegin = "CreatePropFilesStep.checkOutput():  ";
        String msg = "";
        File newDataSrcFile = new File(this.mDataSrcFilePath);
        if (!newDataSrcFile.exists()) {
            outputCheckMsg.append("datasource.properties was not created: " + this.mDataSrcFilePath);
        } else if (!newDataSrcFile.canRead()) {
            outputCheckMsg.append("datasource.properties is not readable: " + this.mDataSrcFilePath);
        } else {
            this.backupOriginalFile(newDataSrcFile.getAbsolutePath());
        }
        File newColumnsTSVFile = new File(this.mColumnsTsvFilePath);
        if (!newColumnsTSVFile.exists()) {
            outputCheckMsg.append(" columns.tsv was not created: " + this.mColumnsTsvFilePath);
        } else if (!newColumnsTSVFile.canRead()) {
            outputCheckMsg.append(" columns.tsv is not readable: " + this.mColumnsTsvFilePath);
        } else {
            this.backupOriginalFile(this.mColumnsTsvFilePath);
        }
        File newBlackListFile = new File(this.mBlacklistFilePath);
        if (!newBlackListFile.exists()) {
            outputCheckMsg.append(" blacklist was not created: " + this.mBlacklistFilePath);
        } else if (!newBlackListFile.canRead()) {
            outputCheckMsg.append(" blacklist is not readable: " + this.mBlacklistFilePath);
        } else {
            this.backupOriginalFile(this.mBlacklistFilePath);
        }
        File newBlacklistBiorwebFile = new File(this.mBlacklistBiowebFilePath);
        if (!newBlacklistBiorwebFile.exists()) {
            outputCheckMsg.append(" blacklist biorweb file was not created: " + this.mBlacklistBiowebFilePath);
        } else if (!newBlacklistBiorwebFile.canRead()) {
            outputCheckMsg.append(" blacklist biorweb is not readable: " + this.mBlacklistBiowebFilePath);
        } else {
            this.backupOriginalFile(this.mBlacklistBiowebFilePath);
        }
        if (outputCheckMsg.toString().length() > 0) {
            throw new BuildCatalogStepExecuteException(msgBegin + outputCheckMsg.toString());
        }
    }

    private void backupOriginalFile(String catalogPropFileName) throws BuildCatalogStepExecuteException {
        File catalogDir = new File(this.mCatalogDirectoryPath);
        File backupDir = new File(catalogDir.getAbsolutePath() + "/.build/");
        if (!backupDir.exists() && !backupDir.mkdir()) {
            System.err.println("CreatePropFilesStep.copyIfExists(): Unable to create directory: " + backupDir.getAbsolutePath());
            throw new BuildCatalogStepExecuteException("Unable to build the .build subdirectory in: " + catalogDir.getAbsolutePath());
        }
        File curFile = new File(catalogPropFileName);
        if (!curFile.exists()) {
            return;
        }
        File defaultBackupFile = new File(backupDir.getAbsolutePath(), curFile.getName() + ".default");
        if (!defaultBackupFile.exists()) {
            try {
                FileUtils.copyFile((File)curFile, (File)defaultBackupFile);
            }
            catch (IOException io) {
                throw new BuildCatalogStepExecuteException("Exception raised. " + io.getMessage() + " Unable to make backup copy of: " + curFile.getAbsolutePath() + " to: " + defaultBackupFile.getAbsolutePath());
            }
        }
    }

    private void backupToNumeric(String catalogPropFileName) throws BuildCatalogStepInputException {
        File catalogDir = new File(this.mCatalogDirectoryPath);
        File backupDir = new File(catalogDir.getAbsolutePath() + "/.build/");
        if (!backupDir.exists() && catalogDir.canWrite() && !backupDir.mkdir()) {
            System.err.println("Unable to create directory: " + catalogDir.getAbsolutePath());
            throw new BuildCatalogStepInputException("Unable to build the .build subdirectory in: " + catalogDir.getAbsolutePath());
        }
        File curFile = new File(catalogPropFileName);
        if (!curFile.exists()) {
            return;
        }
        File newBackupFile = null;
        File mostRecentNumericBackup = this.getMostRecentNumericBackup(backupDir, curFile.getName());
        if (mostRecentNumericBackup == null) {
            newBackupFile = new File(backupDir.getAbsolutePath() + "/" + curFile.getName() + ".1");
        } else {
            String backupBasename = mostRecentNumericBackup.getName();
            String backupNumber = backupBasename.substring(curFile.getName().length(), backupBasename.length());
            backupNumber = backupNumber.replace(".", "");
            Integer nextNum = -1;
            try {
                Integer curNum = new Integer(backupNumber);
                nextNum = curNum + 1;
            }
            catch (NumberFormatException nf) {
                System.err.println("Error getting next backup integer for: " + mostRecentNumericBackup.getAbsolutePath());
            }
            newBackupFile = new File(backupDir.getAbsolutePath() + "/" + curFile.getName() + "." + nextNum);
        }
        if (!curFile.renameTo(newBackupFile)) {
            this.mStepLogger.log("CreatePropFilesStep.moveIfExists: FAILED moving file: " + curFile.getAbsolutePath() + " to backup file: " + newBackupFile.getAbsolutePath());
        }
    }

    private File getMostRecentNumericBackup(File inDir, String filenamePrefix) {
        File[] fileList;
        File mostRecentWithPrefix = null;
        for (File each : fileList = inDir.listFiles()) {
            if (!Pattern.matches(filenamePrefix + "\\.\\d+", each.getName())) continue;
            if (mostRecentWithPrefix == null) {
                mostRecentWithPrefix = each;
                continue;
            }
            if (each.lastModified() <= mostRecentWithPrefix.lastModified()) continue;
            mostRecentWithPrefix = each;
        }
        return mostRecentWithPrefix;
    }
}

