/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import edu.mayo.bior.util.FieldProcessor;
import java.util.HashSet;
import java.util.Set;

public abstract class FieldProcessorBase
implements FieldProcessor {
    protected static String gCurBlankValue = "NA";
    protected static Set<String> gCurBlanks = null;

    public static void addABlank(String value) {
        if (value == null) {
            return;
        }
        if (gCurBlanks == null) {
            if (value.equals(".")) {
                return;
            }
            gCurBlanks = new HashSet<String>();
            gCurBlanks.add(".");
        }
        gCurBlanks.add(value);
    }

    public static void setABlank(String value) {
        if (gCurBlanks == null) {
            gCurBlanks = new HashSet<String>();
        } else {
            gCurBlanks.clear();
        }
        if (value != null) {
            gCurBlanks.add(value);
        }
    }

    public static void setTheBlankValue(String value) {
        gCurBlankValue = value;
    }

    public static String[] getAllBlanks() {
        String[] result;
        if (gCurBlanks != null) {
            int numBlanks = gCurBlanks.size();
            result = gCurBlanks.toArray(new String[numBlanks]);
        } else {
            result = new String[]{"."};
        }
        return result;
    }

    @Override
    public void addBlank(String value) {
        FieldProcessorBase.addABlank(value);
    }

    @Override
    public void setBlank(String value) {
        FieldProcessorBase.setABlank(value);
    }

    @Override
    public void setBlankValue(String value) {
        FieldProcessorBase.setTheBlankValue(value);
    }

    @Override
    public String[] getBlanks() {
        return FieldProcessorBase.getAllBlanks();
    }

    protected boolean isBlank(String value) {
        if (value == null) {
            return true;
        }
        if (gCurBlanks != null) {
            return gCurBlanks.contains(value);
        }
        return ".".equals(value);
    }
}

