/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createcatalog;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.GenomicObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class TjsonToCatalogPipe
extends AbstractPipe<History, History> {
    private static Logger sLogger = Logger.getLogger(TjsonToCatalogPipe.class);
    private int mJsonCol = -1;
    private boolean mIsJsonOnly = false;
    private boolean mIsFirstRow = true;
    private boolean mIsModifyChrom = true;
    private final String LANDMARK = CoreAttributes._landmark.toString();
    private final String MINBP = CoreAttributes._minBP.toString();
    private final String MAXBP = CoreAttributes._maxBP.toString();
    private final String REFALLELE = CoreAttributes._refAllele.toString();
    private boolean mIsWarnedOfLandmarkNonString = false;
    private boolean mIsWarnedOfMinbpNonLong = false;
    private boolean mIsWarnedOfMaxbpNonLong = false;
    private boolean mIsWarnedOfMaxbpCalculated = false;
    private List<String> mLandmarksWarned = new ArrayList<String>();
    private String mJsonOriginal = null;

    public TjsonToCatalogPipe(int jsonCol, boolean isJsonOnly, boolean isModifyChromosome) {
        this.mJsonCol = jsonCol;
        this.mIsJsonOnly = isJsonOnly;
        this.mIsModifyChrom = isModifyChromosome;
    }

    protected History processNextStart() throws NoSuchElementException {
        History historyIn = this.getNextNonBlankNonHeaderLine();
        if (this.isHeaderLine(historyIn)) {
            return historyIn;
        }
        this.fixJsonColumnIfFirstDataRow(historyIn.size());
        History historyOut = this.processLine(historyIn);
        return historyOut;
    }

    private boolean isHeaderLine(History historyIn) {
        return ((String)historyIn.get(0)).startsWith("#");
    }

    private History getNextNonBlankNonHeaderLine() {
        History historyIn = null;
        while (this.isBlankOrHeaderLine(historyIn = (History)this.starts.next())) {
        }
        return historyIn;
    }

    private void fixJsonColumnIfFirstDataRow(int colCount) {
        if (!this.mIsFirstRow) {
            return;
        }
        this.mIsFirstRow = false;
        if (this.mJsonCol > -1) {
            --this.mJsonCol;
        }
        if (this.mJsonCol <= -1) {
            this.mJsonCol = colCount + this.mJsonCol;
        }
    }

    private boolean isBlankOrHeaderLine(History line) {
        boolean isBlank = line == null || line.size() == 0 || line.size() == 1 && ((String)line.get(0)).trim().length() == 0;
        boolean isHeader = line != null && line.size() > 0 && ((String)line.get(0)).startsWith("#");
        return isBlank || isHeader;
    }

    public History processLine(History lineIn) {
        if (lineIn.size() == 0 || this.mJsonCol < 0 || this.mJsonCol > lineIn.size() - 1) {
            throw new RuntimeException("JSON column (" + this.mJsonCol + ") is out of range on row: " + lineIn.getMergedData("\t"));
        }
        this.mJsonOriginal = (String)lineIn.get(this.mJsonCol);
        JSONObject jsonObj = null;
        Object gsonObj = null;
        try {
            jsonObj = new JSONObject(this.mJsonOriginal);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Failed to create JSONObject for TJSON input row: " + lineIn.getMergedData("\t"));
        }
        String chrom = this.getLandmark(jsonObj, this.mIsModifyChrom);
        Long minBP = this.getMinBP(jsonObj);
        Long maxBP = this.getMaxBP(jsonObj);
        if (this.mIsJsonOnly) {
            return new History(new String[]{jsonObj.toString()});
        }
        return new History(new String[]{chrom, minBP.toString(), maxBP.toString(), jsonObj.toString()});
    }

    public Long getMaxBP(JSONObject jsonObj) {
        Object maxbpObj = this.getFromJson(jsonObj, this.MAXBP);
        Object minbpObj = this.getFromJson(jsonObj, this.MINBP);
        Object refObj = this.getFromJson(jsonObj, this.REFALLELE);
        if (maxbpObj == null) {
            if (minbpObj == null || refObj == null) {
                return 0L;
            }
            if (!this.mIsWarnedOfMaxbpCalculated) {
                sLogger.warn((Object)("Warning: " + CoreAttributes._maxBP.toString() + " was not specified, so it will be calculated from " + CoreAttributes._minBP.toString() + " and " + CoreAttributes._refAllele.toString() + " length."));
                sLogger.warn((Object)("First offending JSON shown: " + jsonObj.toString()));
                this.mIsWarnedOfMaxbpCalculated = true;
            }
            Long minbp = Long.parseLong(minbpObj.toString());
            String refAllele = refObj.toString();
            Long maxbp = minbp + (long)refAllele.length() - 1L;
            jsonObj.put(this.MAXBP, (Object)maxbp);
            return maxbp;
        }
        if (minbpObj != null && maxbpObj != null && refObj != null) {
            Long minbpLong = Long.parseLong(minbpObj.toString());
            Long maxbpLong = Long.parseLong(maxbpObj.toString());
            int refLen = refObj.toString().length();
            if (maxbpLong - minbpLong != (long)(refLen - 1)) {
                throw new IllegalArgumentException("Error:  length of the refAllele does not equal (max-min+1): " + this.mJsonOriginal);
            }
        }
        String clsName = maxbpObj.getClass().getName();
        Long maxbp = Long.parseLong(maxbpObj.toString());
        if (!(maxbpObj instanceof Integer)) {
            if (!this.mIsWarnedOfMaxbpNonLong) {
                sLogger.warn((Object)("Warning: " + CoreAttributes._maxBP.toString() + " was not an integer.  Correcting offending JSON (only first original shown): " + this.mJsonOriginal));
                this.mIsWarnedOfMaxbpNonLong = true;
            }
            jsonObj.put(this.MAXBP, (Object)maxbp);
        }
        return maxbp;
    }

    public Long getMinBP(JSONObject jsonObj) {
        Object minbpObj = this.getFromJson(jsonObj, this.MINBP);
        if (minbpObj == null) {
            return 0L;
        }
        Long minbp = Long.parseLong(minbpObj.toString());
        String clsName = minbpObj.getClass().getName();
        if (!(minbpObj instanceof Integer)) {
            if (!this.mIsWarnedOfMinbpNonLong) {
                sLogger.warn((Object)("Warning: " + CoreAttributes._minBP.toString() + " was not an integer.  Correcting offending JSON (only first original shown): " + this.mJsonOriginal));
                this.mIsWarnedOfMinbpNonLong = true;
            }
            jsonObj.put(this.MINBP, (Object)minbp);
        }
        return minbp;
    }

    public String getLandmark(JSONObject jsonObj, boolean isModifyChrom) {
        String landmarkModified;
        Object landmarkObj = this.getFromJson(jsonObj, this.LANDMARK);
        if (landmarkObj == null) {
            return "UNKNOWN";
        }
        String landmark = landmarkObj.toString().trim();
        if (isModifyChrom && !landmark.equals(landmarkModified = GenomicObjectUtils.computechr((String)landmark))) {
            if (!this.mLandmarksWarned.contains(landmark)) {
                sLogger.warn((Object)("Warning: _landmark was changed from " + landmark + " to " + landmarkModified + ".  Correcting offending JSON (only first original shown): " + this.mJsonOriginal));
                this.mLandmarksWarned.add(landmark);
            }
            landmark = landmarkModified;
            jsonObj.put(this.LANDMARK, (Object)landmarkModified);
        }
        if (!(landmarkObj instanceof String)) {
            if (!this.mIsWarnedOfLandmarkNonString) {
                sLogger.warn((Object)("Warning: " + CoreAttributes._landmark.toString() + " was not a String.  Correcting offending JSON (only first original shown): " + this.mJsonOriginal));
                this.mIsWarnedOfLandmarkNonString = true;
            }
            jsonObj.put(this.LANDMARK, (Object)landmark);
        }
        return landmark;
    }

    protected Object getFromJson(JSONObject jsonObj, String key) {
        if (!jsonObj.has(key)) {
            return null;
        }
        Object val = jsonObj.get(key);
        if (val.toString().equals(".")) {
            return null;
        }
        return val;
    }
}

