/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import com.google.gson.JsonArray;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.bior.pipeline.VEP.VEPEXE;
import edu.mayo.bior.pipeline.VEP.VepFunctions;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VEPPipeline
extends AbstractPipe<History, History> {
    private static final Logger sLogger = Logger.getLogger(VEPPipeline.class);
    private VEPEXE mVepExe = null;
    private boolean mIsWorstCaseOnly = true;
    private List<History> mBuffer = new ArrayList<History>();
    private int mMaxBufferSize = 100;
    private boolean mHasMoreInput = true;
    private String EOL = "\n";
    private String TAB = "\t";
    private final String DUMMY_LINE = "DUMMY_LINE";
    private VepFunctions mVepFunctions = null;
    private final int COL_ID = 2;
    private final int COL_INFO = 7;
    private int mNumColsOnInput = 0;

    public VEPPipeline(String[] userSuppliedCommandOptions, boolean pickworst) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this.mIsWorstCaseOnly = pickworst;
        this.mVepExe = new VEPEXE(userSuppliedCommandOptions);
        this.mMaxBufferSize = this.mVepExe.getVepBufferSize();
        this.mVepFunctions = new VepFunctions(this.mVepExe.getVepColHeaders());
    }

    public boolean hasNext() {
        return this.mHasMoreInput && this.mBuffer.size() > 0;
    }

    public History processNextStart() throws NoSuchElementException {
        if (this.mBuffer.size() > 0) {
            return this.getNextOutputBufferItem();
        }
        if (!this.mHasMoreInput) {
            throw new NoSuchElementException("End of input");
        }
        this.fillBufferFromInput();
        this.sendToVep(this.mBuffer);
        this.getOutputFromVep();
        this.addCsqErrorForAnyLinesWithNoVepOutput();
        return this.getNextOutputBufferItem();
    }

    private void fillBufferFromInput() {
        int numBypasses = 0;
        while (this.mBuffer.size() < this.mMaxBufferSize + numBypasses) {
            boolean bl = this.mHasMoreInput = this.mHasMoreInput && this.starts.hasNext();
            if (this.mHasMoreInput) {
                History nextLine = this.trimColumns((History)this.starts.next());
                this.mNumColsOnInput = nextLine.size();
                if (this.mVepExe.isBypass(nextLine)) {
                    ++numBypasses;
                    nextLine.add((Object)this.getVepAsJson(this.mVepExe.getDefaultErrorResponse()));
                    this.mBuffer.add(nextLine);
                    continue;
                }
                this.mBuffer.add(nextLine);
                continue;
            }
            this.mBuffer.add(this.getDummyDataLine());
        }
    }

    private History trimColumns(History line) {
        for (int i = 0; i < line.size(); ++i) {
            line.set(i, (Object)((String)line.get(i)).trim());
        }
        return line;
    }

    private void sendToVep(List<History> inputBuffer) {
        String inputLinesToSend = this.convertInputBufferToString(inputBuffer);
        this.mVepExe.sendLines(inputLinesToSend);
    }

    private void getOutputFromVep() {
        for (int i = 0; i < this.mMaxBufferSize; ++i) {
            History out = this.mVepExe.getNextLine();
            if (this.isDummyLine(out)) {
                this.mHasMoreInput = false;
                continue;
            }
            String id = (String)out.get(2);
            int inputBufferLineNum = Integer.parseInt(id.replace("line", ""));
            History fullLine = this.mBuffer.get(inputBufferLineNum);
            fullLine.add((Object)this.getVepAsJson((String)out.get(7)));
        }
    }

    private void addCsqErrorForAnyLinesWithNoVepOutput() {
        for (int i = 0; i < this.mBuffer.size(); ++i) {
            History line = this.mBuffer.get(i);
            if (this.isDummyLine(line)) continue;
            if (((String)line.get(line.size() - 1)).contains("VEPERRORMessage")) {
                String errorMsg = "Warning: VEP could not process line:\n    " + StringUtils.join((Collection)line.subList(0, 7), (String)"\t");
                sLogger.error((Object)errorMsg);
                System.err.println(errorMsg);
            }
            if (line.size() >= this.mNumColsOnInput + 1) continue;
            line.add((Object)this.getVepAsJson(this.mVepExe.getDefaultErrorResponse()));
        }
    }

    private History getNextOutputBufferItem() {
        History next = this.mBuffer.remove(0);
        if (this.isDummyLine(next)) {
            throw new NoSuchElementException("Reached end of input");
        }
        return next;
    }

    private boolean isDummyLine(History next) {
        return next != null && next.size() >= 3 && ((String)next.get(2)).equals("DUMMY_LINE");
    }

    private History getDummyDataLine() {
        return new History(new String[]{"1", "1", "DUMMY_LINE", "A", "C", ".", "."});
    }

    private String convertInputBufferToString(List<History> buffer) {
        StringBuilder vepInputStr = new StringBuilder();
        for (int i = 0; i < buffer.size(); ++i) {
            if (this.mVepExe.isBypass(buffer.get(i))) continue;
            String line = this.getHistoryAsVepInputLine(buffer.get(i), i);
            vepInputStr.append(line + this.EOL);
        }
        return vepInputStr.toString();
    }

    private String getVepAsJson(String csqString) {
        JsonArray csqAsJsonArray = this.mVepFunctions.vepCsqToJsonList(csqString);
        String vepOut = this.mIsWorstCaseOnly ? this.mVepFunctions.getWorstCase(csqAsJsonArray).toString() : "{\"CSQ\":" + csqAsJsonArray.toString() + "}";
        return vepOut;
    }

    private String getHistoryAsVepInputLine(History history, int lineNum) {
        String id = ((String)history.get(2)).equals("DUMMY_LINE") ? "DUMMY_LINE" : "line" + lineNum;
        return (String)history.get(0) + this.TAB + (String)history.get(1) + this.TAB + id + this.TAB + (String)history.get(3) + this.TAB + (String)history.get(4) + this.TAB + (String)history.get(5) + this.TAB + (String)history.get(6) + this.TAB + ".";
    }

    public void terminate() throws InterruptedException {
        this.mVepExe.terminate();
    }
}

