/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

public class AlleleFreq {
    private String chromosome;
    private int startPos;
    private char minorBase;
    private char majorBase;
    private double minorFreq;
    private double majorFreq;
    private String frequencySource;
    private static final String kMajorSplit = ",";
    private static final String kMinorSplit = "/";

    public AlleleFreq(String chromosome, int startPos, char minorBase, char majorBase, double minorFreq, double majorFreq, String frequencySource) {
        this.chromosome = chromosome;
        this.startPos = startPos;
        this.minorBase = minorBase;
        this.majorBase = majorBase;
        this.minorFreq = minorFreq;
        this.majorFreq = majorFreq;
        this.frequencySource = frequencySource;
    }

    public final String getChromosome() {
        return this.chromosome;
    }

    public final int getStartPos() {
        return this.startPos;
    }

    public final char getMinorBase() {
        return this.minorBase;
    }

    public final char getMajorBase() {
        return this.majorBase;
    }

    public final double getMinorFreq() {
        return this.minorFreq;
    }

    public final double getMajorFreq() {
        return this.majorFreq;
    }

    public final String getFrequencySource() {
        return this.frequencySource;
    }

    private static final int getHash(double value) {
        return (int)(value * 1000.0);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.frequencySource == null ? 0 : this.frequencySource.hashCode());
        result = 31 * result + (this.chromosome == null ? 0 : this.chromosome.hashCode());
        result = 31 * result + this.startPos;
        result = 31 * result + this.majorBase;
        result = 31 * result + this.minorBase;
        long temp = AlleleFreq.getHash(this.majorFreq);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = AlleleFreq.getHash(this.minorFreq);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlleleFreq)) {
            return false;
        }
        AlleleFreq other = (AlleleFreq)obj;
        if (this.startPos != other.startPos) {
            return false;
        }
        if (this.majorBase != other.majorBase) {
            return false;
        }
        if (this.minorBase != other.minorBase) {
            return false;
        }
        if (this.frequencySource == null ? other.frequencySource != null : !this.frequencySource.equals(other.frequencySource)) {
            return false;
        }
        if (this.chromosome == null ? other.chromosome != null : !this.chromosome.equals(other.chromosome)) {
            return false;
        }
        if (AlleleFreq.getHash(this.majorFreq) != AlleleFreq.getHash(other.majorFreq)) {
            return false;
        }
        return AlleleFreq.getHash(this.minorFreq) == AlleleFreq.getHash(other.minorFreq);
    }

    public String toString() {
        StringBuilder results = new StringBuilder();
        if (this.frequencySource != null) {
            results.append(this.frequencySource);
            results.append('\t');
        }
        results.append(this.minorBase);
        results.append(kMinorSplit);
        results.append(this.majorBase);
        results.append(kMajorSplit);
        results.append(this.minorFreq);
        results.append(kMinorSplit);
        results.append(this.majorFreq);
        return results.toString();
    }
}

