/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.catalog.GoldenAttribute;
import edu.mayo.bior.pipeline.createCatalogProps.ColumnMetaFromCatalogCrawling;
import edu.mayo.bior.pipeline.createCatalogProps.ColumnMetaFromVcf;
import edu.mayo.bior.pipeline.exception.CatalogMetadataInputException;
import edu.mayo.bior.util.ClasspathUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;

public class CreateCatalogPropsCommand
implements CommandPlugin {
    public static final char OPTION_CATALOG = 'd';
    public static final char OPTION_ORIGINAL_VCF = 'v';
    public static final char OPTION_TARGET_DIR = 't';
    private List<AddMetadataLines.BiorMetaControlledVocabulary> biorMetaControlledVocabulary = Arrays.asList(AddMetadataLines.BiorMetaControlledVocabulary.values());

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine line, Options opts) throws InvalidDataException, IOException {
        String catalogBgzipPath = line.getOptionValue('d');
        boolean isVcfSpecified = line.hasOption('v');
        String catalogOriginalVcfPath = line.getOptionValue('v');
        String targetDir = line.getOptionValue('t');
        try {
            this.execNoCmd(catalogBgzipPath, catalogOriginalVcfPath, targetDir, isVcfSpecified);
        }
        catch (IOException ioe) {
            throw new InvalidDataException("Error accessing one of the files: " + ioe.getMessage());
        }
        catch (URISyntaxException e) {
            throw new InvalidDataException("Could not find the columns defaults properties file: " + e.getMessage());
        }
        catch (ConfigurationException e) {
            throw new InvalidDataException("Error modifying the properties file: " + e.getMessage());
        }
    }

    public void execNoCmd(String catalogBgzipPath, String catalogOriginalVcfPath, String targetDirPath, boolean isVcfSpecified) throws InvalidDataException, IOException, URISyntaxException, ConfigurationException {
        boolean isCrawlCatalog;
        File originalVcfFile;
        String catalogFullFilename;
        File targetDir;
        File catalogFile = new File(catalogBgzipPath);
        if (!catalogFile.exists()) {
            throw new IOException("Catalog file could not be found: " + catalogBgzipPath);
        }
        if (targetDirPath == null || targetDirPath.length() == 0) {
            targetDirPath = new File(catalogBgzipPath).getCanonicalFile().getParent();
        }
        if (!(targetDir = new File(targetDirPath).getCanonicalFile()).exists()) {
            throw new IOException("Target directory does not exist: " + targetDir);
        }
        if (!targetDir.isDirectory()) {
            throw new IOException("Target directory is not a directory: " + targetDir);
        }
        if (!targetDir.canWrite()) {
            throw new IOException("Target directory is not writable: " + targetDir);
        }
        String catalogFilenamePrefix = catalogFullFilename = catalogFile.getName();
        if (catalogFullFilename.endsWith(".tsv")) {
            catalogFilenamePrefix = catalogFullFilename.substring(0, catalogFullFilename.lastIndexOf(".tsv"));
        } else if (catalogFullFilename.endsWith(".tsv.bgz")) {
            catalogFilenamePrefix = catalogFullFilename.substring(0, catalogFullFilename.lastIndexOf(".tsv.bgz"));
        }
        File datasrcPropsFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".datasource.properties");
        File columnsPropsFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".columns.tsv");
        File blacklistFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".columns.tsv.blacklist");
        File blacklistBiorwebSymLink = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".columns.tsv.blacklist.biorweb");
        if (datasrcPropsFile.isDirectory()) {
            throw new IOException("Datasource properties file is an existing directory.  It should be a file");
        }
        if (columnsPropsFile.isDirectory()) {
            throw new IOException("Columns properties file is an existing directory.  It should be a file");
        }
        if (datasrcPropsFile.exists()) {
            throw new IOException("Datasource properties file already exists.  If you would like to recreate the properties files, first remove the existing ones, then recreate them.");
        }
        if (columnsPropsFile.exists()) {
            throw new IOException("Columns properties file already exists.  If you would like to recreate the properties files, first remove the existing ones, then recreate them.");
        }
        if (blacklistFile.exists()) {
            throw new IOException("Blacklist file with extension [.columns.tsv.blacklist] already exists.  If you would like to recreate the properties files, first remove the existing ones, then recreate them.");
        }
        File file = originalVcfFile = isVcfSpecified ? new File(catalogOriginalVcfPath) : null;
        if (isVcfSpecified && (originalVcfFile == null || !originalVcfFile.exists())) {
            throw new IOException("Orginal VCF source file that the catalog was built from does not exist!: " + catalogOriginalVcfPath);
        }
        boolean bl = isCrawlCatalog = !isVcfSpecified;
        if (isCrawlCatalog) {
            long MB = 0x100000L;
            if (catalogFile.length() > 0xA00000L) {
                System.out.println("  WARNING: Catalog is large (" + catalogFile.length() / 0x100000L + "MB).  This may take a while to process)...");
            }
        }
        this.createDatasourcePropsFile(datasrcPropsFile);
        this.createColumnPropsFile(columnsPropsFile, catalogFile, originalVcfFile, isVcfSpecified);
        try {
            File NewColumnsTsvFileObj = new File(columnsPropsFile.getCanonicalPath());
            this.createBlackListFiles(NewColumnsTsvFileObj, blacklistFile, blacklistBiorwebSymLink);
            if (!blacklistFile.exists() || !blacklistBiorwebSymLink.exists()) {
                throw new IOException("Unable to create the blacklist or blacklist biorweb file successfully.");
            }
        }
        catch (CatalogMetadataInputException i) {
            throw new InvalidDataException(i.getMessage());
        }
        catch (IOException io) {
            throw io;
        }
        System.out.println("Datasource properties file created at: " + datasrcPropsFile.getCanonicalPath());
        System.out.println("Columns    properties file created at: " + columnsPropsFile.getCanonicalPath());
        System.out.println("Blacklist  properties file created at: " + blacklistFile.getCanonicalPath());
        System.out.println("Done.");
    }

    protected void createDatasourcePropsFile(File datasourcePropsFile) throws InvalidDataException, IOException, ConfigurationException {
        String catalogNamePrefix = datasourcePropsFile.getName().replace(".datasource.properties", "");
        String deployedDistributionDefault = "datasource.properties.default";
        String uri = this.getClass().getClassLoader().getResource(deployedDistributionDefault).getPath();
        File defaultDataSrcProps = null;
        if (uri != null && uri.length() > 0) {
            defaultDataSrcProps = new File(uri);
        } else {
            String testEnvDistributionDefault = "src/main/resources/datasource.properties.default";
            File testEnvDefaultDataSrcProps = new File(testEnvDistributionDefault);
            if (testEnvDefaultDataSrcProps.canRead()) {
                defaultDataSrcProps = testEnvDefaultDataSrcProps;
            } else {
                System.err.println("Unable to locate file:" + deployedDistributionDefault);
                throw new IOException("Unable to locate file:" + deployedDistributionDefault);
            }
        }
        String datasourceProps = FileUtils.readFileToString((File)defaultDataSrcProps).replace("_CATALOG_PREFIX_", catalogNamePrefix);
        FileUtils.write((File)datasourcePropsFile, (CharSequence)datasourceProps);
    }

    protected void createColumnPropsFile(File columnPropsFile, File catalogFile, File originalVcfFile, boolean isVcfSpecified) throws InvalidDataException, IOException, URISyntaxException {
        List<ColumnMetaData> colMetaList = this.mergeCrawlerWithVcf(catalogFile, originalVcfFile, isVcfSpecified);
        colMetaList = this.mergeWithDefaults(colMetaList);
        StringBuilder content = this.getColumnContents(columnPropsFile, colMetaList);
        columnPropsFile.createNewFile();
        this.writeToFile(columnPropsFile, content.toString());
    }

    protected void createBlackListFiles(File columnPropsFile, File blacklistPropsFile, File blacklistBiorweb) throws CatalogMetadataInputException, IOException {
        blacklistPropsFile.createNewFile();
        StringBuilder blackListContent = new StringBuilder();
        String blacklistTopRow = "### These columns are to generally be ignored within UIs as they are duplicates or are normalized versions of the original columns.\n";
        String blacklistBiorwebTopRow = "### These fields will NOT be showing in BioRWeb.  All others will.\n";
        StringBuilder blackListComments = new StringBuilder("### If this file is NOT present, then assume that all fields, except for the golden attributes (those beginning with _) should be shown.\n### If this file is present, but contains no columns, then assume that all fields should be shown.\n");
        blackListContent.append((CharSequence)blackListComments);
        GoldenAttribute[] goldenAttributes = GoldenAttribute.values();
        HashMap columnKeyToMetaMap = null;
        try {
            columnKeyToMetaMap = new ColumnMetaDataOperations().load(columnPropsFile.getCanonicalPath());
        }
        catch (IOException e) {
            throw new CatalogMetadataInputException("Could not create blacklist file. Could not get columns.tsv info from file: " + columnPropsFile.getCanonicalPath() + "\nError: " + e.getMessage());
        }
        for (String colname : columnKeyToMetaMap.keySet()) {
            for (GoldenAttribute golden : goldenAttributes) {
                if (!colname.equals(golden.name())) continue;
                blackListContent.append(colname + "\n");
            }
        }
        this.writeToFile(blacklistPropsFile, blacklistTopRow + blackListContent.toString());
        this.writeToFile(blacklistBiorweb, blacklistBiorwebTopRow + blackListContent.toString());
    }

    private List<ColumnMetaData> mergeCrawlerWithVcf(File catalogFile, File originalVcfFile, boolean isVcfSpecified) throws IOException {
        List<ColumnMetaData> colMetaList = new ColumnMetaFromCatalogCrawling().getColumnMetadata(catalogFile.getCanonicalPath());
        if (isVcfSpecified && originalVcfFile != null && originalVcfFile.exists()) {
            List<ColumnMetaData> fromVcfColMetaList = new ColumnMetaFromVcf().getColumnMetadata(originalVcfFile.getCanonicalPath());
            for (ColumnMetaData colMetaVcf : fromVcfColMetaList) {
                for (int i = colMetaList.size() - 1; i >= 0; --i) {
                    if (!colMetaList.get(i).getColumnName().equals(colMetaVcf.getColumnName())) continue;
                    colMetaList.remove(i);
                }
                colMetaList.add(colMetaVcf);
            }
        }
        return colMetaList;
    }

    private List<ColumnMetaData> mergeWithDefaults(List<ColumnMetaData> colMetaList) throws URISyntaxException, IOException {
        File colDefaultsProps = ClasspathUtil.loadResource("/allCatalogs.columns.tsv");
        HashMap defaultsColNameToMetaMap = new AddMetadataLines().parseColumnProperties(colDefaultsProps.getCanonicalPath());
        for (int i = 0; i < colMetaList.size(); ++i) {
            String colName = colMetaList.get(i).getColumnName();
            if (!defaultsColNameToMetaMap.containsKey(colName)) continue;
            colMetaList.set(i, (ColumnMetaData)defaultsColNameToMetaMap.get(colName));
        }
        return colMetaList;
    }

    private StringBuilder getColumnContents(File columnPropsFile, List<ColumnMetaData> colMetaList) {
        ColumnMetaDataOperations colMetaOps = new ColumnMetaDataOperations();
        StringBuilder content = new StringBuilder(colMetaOps.getLinesAsString(colMetaOps.getDefaultColumnsTsvHeader()));
        Collections.sort(colMetaList);
        for (ColumnMetaData colMeta : colMetaList) {
            content.append(colMeta.toString() + "\n");
        }
        return content;
    }

    private void writeToFile(File source, String content) throws IOException {
        FileWriter fw = new FileWriter(source.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(content);
        bw.close();
    }
}

