/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.Treat.TreatPipelineMultiCmd;
import edu.mayo.bior.pipeline.Treat.TreatPipelineSingleThread;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidOptionArgValueException;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class AnnotateCommand
implements CommandPlugin {
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private static final Logger sLogger = Logger.getLogger(AnnotateCommand.class);
    private static final String OPTION_GENOME_VERSION = "genome_version";
    private static final char OPTION_CONFIG_FILE = 'c';
    private static final char OPTION_MULTI_PROCESS = 'm';
    private static final char OPTION_STATUS = 's';

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        try {
            String configFilePath = null;
            if (line.hasOption('c') && (!new File(configFilePath = line.getOptionValue('c')).exists() || new File(configFilePath).length() == 0L)) {
                throw new InvalidOptionArgValueException(opts.getOption("c"), configFilePath, "The Config file path '" + configFilePath + "' does not exist (or is empty). Please specify a valid config file path.");
            }
            try {
                boolean isMultiProcess = line.hasOption('m');
                if (isMultiProcess) {
                    sLogger.warn((Object)"WARNING: Running bior_annotate as a MULTI-PROCESS command!!!");
                    TreatPipelineMultiCmd treatPipeline = new TreatPipelineMultiCmd(configFilePath);
                    List<Metadata> treatMetadata = treatPipeline.getMetadata();
                    this.mPipeline.execute(new HistoryInPipe(treatMetadata), treatPipeline, new HistoryOutPipe());
                } else {
                    sLogger.info((Object)"NOTE: Running bior_annotate as a single-threaded command.");
                    TreatPipelineSingleThread treatPipeline = new TreatPipelineSingleThread(configFilePath);
                    List<Metadata> treatMetadata = treatPipeline.getMetadata();
                    this.mPipeline.execute(new HistoryInPipe(treatMetadata), treatPipeline, new HistoryOutPipe());
                }
                this.mPipeline.getStatus().isSuccessful = true;
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidOptionArgValueException(opts.getOption("c"), configFilePath, ex.getMessage());
            }
            catch (URISyntaxException e) {
                throw new IOException("Could not load properties file for catalog or tool: " + e.getMessage());
            }
        }
        catch (Exception e) {
            this.mPipeline.getStatus().isSuccessful = false;
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        if (line.hasOption('s')) {
            String statusFilePath = line.getOptionValue('s');
            FileUtils.writeStringToFile((File)new File(statusFilePath), (String)this.mPipeline.getStatus().toString());
        }
    }

    private String[] getCommandLineOptions(CommandLine line) {
        ArrayList<String> cmdoptions = new ArrayList<String>();
        String genomeDatabase = line.hasOption(OPTION_GENOME_VERSION) ? line.getOptionValue(OPTION_GENOME_VERSION) : "GRCh37.64";
        sLogger.debug((Object)String.format("Using genome database version %s", genomeDatabase));
        cmdoptions.add(genomeDatabase);
        return cmdoptions.toArray(new String[cmdoptions.size()]);
    }
}

