/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalogvalidator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import edu.mayo.bior.catalogvalidator.CatalogEntryGoldenJson;
import edu.mayo.bior.catalogvalidator.CatalogTabixEntry;
import edu.mayo.bior.catalogvalidator.UniqOrderedMessageLogger;
import edu.mayo.bior.catalogvalidator.WholeCatalogValidationThread;
import edu.mayo.pipes.history.ColumnMetaData;
import htsjdk.tribble.readers.TabixReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.lf5.LogLevel;

public class VerifyCatalogUtils {
    private static final String NL = "\n";
    private static final String TAB = "\t";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static CatalogTabixEntry readCatalogRow(String lineInCatalog, UniqOrderedMessageLogger logger) {
        if (lineInCatalog == null) {
            return null;
        }
        String[] lnElems = lineInCatalog.split(TAB);
        CatalogTabixEntry tabixRowEntry = null;
        if (lnElems.length == 4) {
            if (lnElems[0] != null && lnElems[0].length() > 0 && lnElems[1] != null && lnElems[1].length() > 0 && lnElems[2] != null && lnElems[2].length() > 0 && lnElems[3] != null && lnElems[3].length() > 0 && lnElems[3].startsWith("{") && lnElems[3].endsWith("}")) {
                try {
                    return new CatalogTabixEntry(lnElems[0], lnElems[1], lnElems[2], lnElems[3], lineInCatalog.trim());
                }
                catch (NumberFormatException nf) {
                    String err = "readCatalogRow(): Catalog format unexpected: number of tab-separated columns is 4 but some of fields not valid to create CatalogTabixEntry object. line: " + lineInCatalog;
                    logger.logMessage(err, LogLevel.ERROR);
                    return null;
                }
            }
            String err = "readCatalogRow(): Catalog format unexpected: number of tab-separated columns is 4 but some of fields are empty or not json. line: " + lineInCatalog;
            logger.logMessage(err, LogLevel.ERROR);
            return null;
        }
        if (lnElems.length == 1) {
            if (lnElems[0] != null && lnElems[0].startsWith("{") && lnElems[0].endsWith("}")) {
                return new CatalogTabixEntry((String)null, (Integer)null, (Integer)null, lnElems[0], lineInCatalog.trim());
            }
            logger.logMessage("Catalog row has onlyone column but doesn't appear to be JSON.", LogLevel.ERROR);
            return null;
        }
        String err = "readCatalogRow(): Catalog format unexpected: number of tab-separated columns is not 4 or 1. line: " + lineInCatalog;
        logger.logMessage(err, LogLevel.ERROR);
        return null;
    }

    protected static CatalogEntryGoldenJson getGoldenJsonVariant(JsonObject catalogRowJson) {
        CatalogEntryGoldenJson variant = new CatalogEntryGoldenJson();
        try {
            JsonArray jsonAltAlleles;
            variant.setChr(catalogRowJson.get("_landmark").getAsString());
            variant.setMinBP(VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_minBP").getAsInt());
            variant.setMaxBP(VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_maxBP").getAsInt());
            JsonPrimitive goldenRefAllele = VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_refAllele");
            if (goldenRefAllele != null) {
                variant.setRefAllele(goldenRefAllele.getAsString());
                JsonPrimitive strandPrim = VerifyCatalogUtils.getJsonPrimitive(catalogRowJson, "_strand");
                if (strandPrim != null) {
                    variant.setStrand(strandPrim.getAsString());
                }
            }
            if ((jsonAltAlleles = catalogRowJson.getAsJsonArray("_altAlleles")) != null) {
                Iterator iterator = jsonAltAlleles.iterator();
                while (iterator.hasNext()) {
                    String eachAltAllele = ((JsonElement)iterator.next()).getAsString();
                    variant.addAltAllele(eachAltAllele);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return variant;
    }

    protected static JsonObject getJsonObject(String jsonAsString) {
        JsonParser jp = new JsonParser();
        JsonElement catalogRowJsonElem = null;
        JsonObject catalogRowJsonObj = null;
        catalogRowJsonElem = jp.parse(jsonAsString);
        catalogRowJsonObj = catalogRowJsonElem.getAsJsonObject();
        return catalogRowJsonObj;
    }

    protected static JsonPrimitive getJsonPrimitive(JsonObject jsonObj, String jsonKey) {
        JsonElement jsonElem = jsonObj.get(jsonKey);
        if (jsonElem == null || !jsonElem.isJsonPrimitive()) {
            return null;
        }
        return jsonElem.getAsJsonPrimitive();
    }

    protected static Object getJsonValueForJsonKey(JsonObject jsonObj, String keyOfValueToRetrieve, String parentJsonKey) {
        Object currentJsonObj = null;
        for (Map.Entry thisEntry : jsonObj.entrySet()) {
            String strVal;
            String jsonKey = (String)thisEntry.getKey();
            if (!jsonKey.equals(keyOfValueToRetrieve) && !jsonKey.contains(keyOfValueToRetrieve)) continue;
            JsonElement jsonElem = (JsonElement)thisEntry.getValue();
            if (jsonElem.isJsonNull()) {
                System.err.println("getJavaObjectForJsonID(): Value for json key [" + jsonKey + "] is empty.");
                break;
            }
            if (jsonElem.isJsonObject()) {
                JsonObject embeddedJsonObj = jsonElem.getAsJsonObject();
                currentJsonObj = VerifyCatalogUtils.getJsonValueForJsonKey(embeddedJsonObj, keyOfValueToRetrieve, jsonKey);
                continue;
            }
            if (jsonElem.isJsonArray()) {
                JsonArray jsonArrVal = jsonElem.getAsJsonArray();
                currentJsonObj = jsonArrVal;
                break;
            }
            if (!jsonElem.isJsonPrimitive()) break;
            JsonPrimitive jsonPrimVal = jsonElem.getAsJsonPrimitive();
            if (jsonPrimVal.isBoolean()) {
                Boolean boolVal = jsonPrimVal.getAsBoolean();
                currentJsonObj = boolVal;
                break;
            }
            if (jsonPrimVal.isNumber()) {
                currentJsonObj = VerifyCatalogUtils.jsonNumberToJavaNumber(jsonPrimVal);
                break;
            }
            if (!jsonPrimVal.isString() || (strVal = jsonPrimVal.getAsString()) == null) break;
            currentJsonObj = strVal;
            break;
        }
        return currentJsonObj;
    }

    protected static boolean isTabixRetrievalSuccessful(TabixReader tabixRdr, CatalogTabixEntry tabixCatEntry, WholeCatalogValidationThread.TABIX_QUERY_ORDER tabixOrderToCheck) throws IOException {
        boolean successfulMatch = false;
        boolean allResultsRelavent = true;
        TabixReader.Iterator tabixItr = VerifyCatalogUtils.getTabixIterator(tabixRdr, tabixCatEntry);
        if (tabixItr == null) {
            successfulMatch = false;
            allResultsRelavent = false;
        } else {
            int currentIteratorIdx = 0;
            int iteratorIdxThatMatched = -1;
            int numTabixResults = 0;
            String tabixLine = null;
            while ((tabixLine = tabixItr.next()) != null) {
                ++currentIteratorIdx;
                ++numTabixResults;
                if (tabixLine.equals(tabixCatEntry.getCatalogTabixLine())) {
                    successfulMatch = true;
                    iteratorIdxThatMatched = currentIteratorIdx;
                    continue;
                }
                String[] elems = tabixLine.split(TAB);
                CatalogTabixEntry qryResultTabixEntry = new CatalogTabixEntry(elems[0], elems[1], elems[2], elems[3], tabixLine);
                boolean tabixResultMinPosInRange = VerifyCatalogUtils.withinRange(qryResultTabixEntry.getMinPosition(), tabixCatEntry.getMinPosition(), tabixCatEntry.getMaxPosition());
                boolean tabixResultMaxPosInRange = VerifyCatalogUtils.withinRange(qryResultTabixEntry.getMaxPosition(), tabixCatEntry.getMinPosition(), tabixCatEntry.getMaxPosition());
                if (tabixResultMinPosInRange || tabixResultMaxPosInRange || qryResultTabixEntry.getMinPosition() <= tabixCatEntry.getMinPosition() && qryResultTabixEntry.getMaxPosition() >= tabixCatEntry.getMaxPosition()) continue;
                System.err.println("WARNING: Tabix query result catalog entry not within minBP or maxBP query range: \n\t queried minBP: " + tabixCatEntry.getMinPosition() + NL + TAB + " queried maxBP: " + tabixCatEntry.getMaxPosition() + NL + TAB + " result minBP out of range: " + qryResultTabixEntry.getMinPosition() + NL + TAB + " result maxBP out of range: " + qryResultTabixEntry.getMaxPosition() + NL);
                allResultsRelavent = false;
            }
            if (!(successfulMatch && tabixOrderToCheck.name().equals(WholeCatalogValidationThread.TABIX_QUERY_ORDER.FIRST_ELEM_IN_RESULT.name()) && iteratorIdxThatMatched == 1 || successfulMatch && tabixOrderToCheck.name().equals(WholeCatalogValidationThread.TABIX_QUERY_ORDER.LAST_ELEM_IN_RESULT.name()) && iteratorIdxThatMatched == numTabixResults)) {
                successfulMatch = false;
            }
        }
        return successfulMatch && allResultsRelavent;
    }

    private boolean isValidInteger(String intStrValue, String catalogDataType) {
        if (catalogDataType.equalsIgnoreCase("int") || catalogDataType.equalsIgnoreCase("Integer")) {
            try {
                Integer intVal = new Integer(intStrValue);
                if (intVal % 1 != 0) {
                    return false;
                }
                if (intVal >= Integer.MIN_VALUE && intVal <= Integer.MAX_VALUE) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private boolean isValidLong(String longStrValue, String catalogDataType) {
        if (catalogDataType.equalsIgnoreCase("Long")) {
            try {
                Long longVal = new Long(longStrValue);
                if (longVal % 1L != 0L) {
                    return false;
                }
                if (longVal >= Long.MIN_VALUE && longVal <= Long.MAX_VALUE) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isEmptyJsonValue(String jsonValue) {
        String trimmedJsonVal = VerifyCatalogUtils.trim(jsonValue);
        return VerifyCatalogUtils.isEmpty(trimmedJsonVal) || trimmedJsonVal.equals(".");
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        String trimmedStr = VerifyCatalogUtils.trim(str);
        return trimmedStr.length() <= 0;
    }

    public static boolean isQuotedString(String str) {
        if (str == null) {
            return false;
        }
        return !str.startsWith("\"") || !str.endsWith("\"");
    }

    protected static boolean isCatalogEntryPositional(CatalogTabixEntry tabixRow) {
        return VerifyCatalogUtils.isChromosomePositional(tabixRow) && VerifyCatalogUtils.isMinBPPositional(tabixRow) && VerifyCatalogUtils.isMaxBPPositional(tabixRow);
    }

    protected static boolean isChromosomePositional(CatalogTabixEntry tabixRow) {
        return tabixRow.getChromosome() != null && !tabixRow.getChromosome().toUpperCase().equals("UNKNOWN") && !tabixRow.getChromosome().toUpperCase().equals(".");
    }

    protected static boolean isMinBPPositional(CatalogTabixEntry tabixRow) {
        if (tabixRow.getMinPosition() != null && tabixRow.getMinPosition() > 1) {
            return true;
        }
        if (tabixRow.getMinPosition() != null && tabixRow.getMinPosition() == 0) {
            return false;
        }
        return false;
    }

    protected static boolean isMaxBPPositional(CatalogTabixEntry tabixRow) {
        if (tabixRow.getMaxPosition() != null) {
            if (tabixRow.getMaxPosition() == 0 || tabixRow.getMaxPosition() == 1) {
                return false;
            }
            if (tabixRow.getMaxPosition() > 1) {
                return true;
            }
        }
        return false;
    }

    protected boolean dataTypesMatch(Object jsonObj, ColumnMetaData columnDefinition) {
        ColumnMetaData.Type definedDataType = columnDefinition.getType();
        String definedCount = columnDefinition.getCount();
        if (jsonObj instanceof Boolean && definedDataType.equals((Object)ColumnMetaData.Type.Boolean)) {
            return true;
        }
        if ((jsonObj instanceof Long || jsonObj instanceof Integer) && definedDataType.equals((Object)ColumnMetaData.Type.Integer)) {
            return true;
        }
        return jsonObj instanceof String && definedDataType.equals((Object)ColumnMetaData.Type.String) ? definedCount.equals("1") : jsonObj instanceof JsonArray && definedDataType.equals((Object)ColumnMetaData.Type.String) && definedCount.equals(".");
    }

    protected static TabixReader.Iterator getTabixIterator(TabixReader tabixRdr, CatalogTabixEntry tabixRowEntry) {
        return VerifyCatalogUtils.getTabixIterator(tabixRdr, tabixRowEntry.getChromosome(), tabixRowEntry.getMinPosition(), tabixRowEntry.getMaxPosition());
    }

    protected static TabixReader.Iterator getTabixIterator(TabixReader tabixRdr, String chr, Integer start, Integer stop) {
        TabixReader.Iterator chrItr = null;
        try {
            chrItr = tabixRdr.query(chr + ":" + start + "-" + stop);
        }
        catch (Throwable t) {
            System.err.println("WARNING: Exception while requesting tabix iterator for region [" + chr + ":" + start + "-" + stop + "].  Exception is: " + t.getMessage());
            return null;
        }
        return chrItr;
    }

    protected static String validateGoldenJsonLandmark(JsonObject catalogRowJson, boolean isPositionalCatalog, Set<String> validChrValues, UniqOrderedMessageLogger logger) {
        String jsonGolden_landmarkStr = null;
        JsonElement goldenLandmarkElem = catalogRowJson.get("_landmark");
        if (goldenLandmarkElem == null) {
            if (isPositionalCatalog) {
                logger.logMessage("_landmark golden value is not in JSON String, but catalog is positional. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
                return null;
            }
        } else {
            jsonGolden_landmarkStr = goldenLandmarkElem.getAsString();
            if (validChrValues != null && validChrValues.size() > 0 && !validChrValues.contains(jsonGolden_landmarkStr)) {
                logger.logMessage("_landmark value [" + jsonGolden_landmarkStr + "] not found in configured valid chromosomes list: " + validChrValues.toString(), LogLevel.WARN);
            }
            if (!jsonGolden_landmarkStr.equals("X") && !jsonGolden_landmarkStr.equals("Y") && !jsonGolden_landmarkStr.equals("M") && jsonGolden_landmarkStr.matches("\\d+")) {
                Integer iLandmark = -1;
                try {
                    iLandmark = goldenLandmarkElem.getAsInt();
                    if (iLandmark < 1 || iLandmark > 22) {
                        logger.logMessage("_landmark value should be valid numeric chr value at this point [" + jsonGolden_landmarkStr + "], but is not. Json obj id: " + catalogRowJson.get("_id"), LogLevel.ERROR);
                        return null;
                    }
                }
                catch (Exception e) {
                    logger.logMessage("_landmark value should be valid numeric chr value at this point [" + jsonGolden_landmarkStr + "], but could not create Integer object for value. Json obj id: " + catalogRowJson.get("_id"), LogLevel.ERROR);
                    return null;
                }
            }
        }
        return jsonGolden_landmarkStr;
    }

    protected static String validateGoldenJsonStrand(JsonObject catalogRowJson, UniqOrderedMessageLogger logger) throws Exception {
        String strand = null;
        JsonElement strandJsonElem = catalogRowJson.get("_strand");
        if (strandJsonElem != null && strandJsonElem.isJsonPrimitive()) {
            JsonPrimitive strandPrim = strandJsonElem.getAsJsonPrimitive();
            if (!strandPrim.isString()) {
                logger.logMessage("_strand golden value is not a JSON Primitive String type. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
                return null;
            }
            strand = strandJsonElem.getAsString();
            if (!strand.equals("+")) {
                logger.logMessage("_strand golden value is not equal to a '+'. row id: " + catalogRowJson.get("_id").getAsString(), LogLevel.WARNING);
                return null;
            }
        } else {
            return null;
        }
        return strand;
    }

    protected static Object jsonNumberToJavaNumber(JsonPrimitive jsonNumber) {
        Number correctInstanceOfJavaNumber = null;
        Number num = VerifyCatalogUtils.stringToJavaNumber(jsonNumber.getAsString());
        if (num instanceof Long) {
            correctInstanceOfJavaNumber = (Long)num;
        } else if (num instanceof Integer) {
            correctInstanceOfJavaNumber = (Integer)num;
        } else if (num instanceof BigDecimal) {
            correctInstanceOfJavaNumber = (BigDecimal)num;
        } else if (num instanceof Double) {
            correctInstanceOfJavaNumber = (Double)num;
        }
        return correctInstanceOfJavaNumber;
    }

    protected static Number stringToJavaNumber(String value) {
        if (!value.contains(".")) {
            try {
                long longValue = Long.parseLong(value);
                if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException longValue) {
                // empty catch block
            }
        }
        try {
            Double valueAsADouble = Double.parseDouble(value);
            Float valueAsFloat = Float.valueOf(Float.parseFloat(value));
            if (valueAsADouble >= (double)1.4E-45f && valueAsADouble <= 3.4028234663852886E38) {
                return valueAsFloat;
            }
            return valueAsADouble;
        }
        catch (NumberFormatException nf) {
            return new BigDecimal(value);
        }
    }

    public static String trim(String inputStr) {
        if (inputStr == null) {
            return null;
        }
        return inputStr.trim();
    }

    private static boolean withinRange(int queryPosition, int minRange, int maxRange) {
        return queryPosition >= minRange && queryPosition <= maxRange;
    }
}

