/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.misses;

import edu.mayo.pipes.JSON.tabix.TabixReaderBAD;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import net.sf.samtools.util.BlockCompressedInputStream;

public class TabixReaderTest {
    private TabixReaderBAD mTabixReaderBad;
    private TabixReader mTabixReaderGood;
    private String mCatalogPath = null;
    private File mOutputFile = null;

    public static void main(String[] args) {
        File outFile;
        if (args.length == 0) {
            TabixReaderTest.printUsage();
        }
        boolean useFixed = false;
        String catalogFilePath = null;
        String outputFilePath = null;
        for (int i = 0; i < args.length; ++i) {
            String eachArg = args[i];
            String nextArg = null;
            if (i + 1 < args.length) {
                nextArg = args[i + 1];
            }
            if (eachArg.equals("-h") || eachArg.equals("--help") || eachArg.equals("-help")) {
                TabixReaderTest.printUsage();
            }
            if (eachArg.equals("-c") || eachArg.equals("--catalog")) {
                catalogFilePath = nextArg;
                ++i;
            }
            if (eachArg.equals("-o") || eachArg.equals("--output_file_path")) {
                outputFilePath = nextArg;
                ++i;
            }
            if (!eachArg.equals("-f") && !eachArg.equals("--fixed")) continue;
            useFixed = true;
        }
        if (catalogFilePath == null || catalogFilePath.length() == 0) {
            System.err.println("\nERROR: Catalog file to check not specified. Please specify a catalog.\n");
            TabixReaderTest.printUsage();
        } else {
            File catFile = new File(catalogFilePath);
            if (catFile == null || !catFile.exists()) {
                System.err.println("\nERROR: Catalog file specified does not exist. Please specify a valid catalog.\n");
                TabixReaderTest.printUsage();
            }
        }
        File catalogIndexFile = new File(catalogFilePath + ".tbi");
        if (catalogIndexFile == null || !catalogIndexFile.exists()) {
            System.err.println("\nERROR: Catalog tabix index file for the catalog does not exist [" + catalogIndexFile.getAbsolutePath() + "]. " + " If this is a catalog that has genomic coordinates in the first three columns, you must create a tabix index in order to check" + " it for misses due to the Java tabix issue. If this is not a positional catalog, there is no need to check for misses. " + " Non-positional catalogs are not designed to return results using the tools affected by this Java tabix issue.\n");
            TabixReaderTest.printUsage();
        }
        if (outputFilePath == null || outputFilePath.length() == 0) {
            File catalogFile = new File(catalogFilePath);
            String basename = catalogFile.getName();
            outputFilePath = useFixed ? basename + "_misses_fixed.txt" : basename + "_misses.txt";
        }
        if ((outFile = new File(outputFilePath)).exists()) {
            if (!outFile.isFile()) {
                System.err.println("\nERROR: Output file is not a file [" + outputFilePath + "]. Please specify an output file value.\n");
                TabixReaderTest.printUsage();
            } else {
                System.err.println("\nERROR: Output file already exists [" + outputFilePath + "]. Please remove and rerun, or specify new value.\n");
                TabixReaderTest.printUsage();
            }
        }
        File parentDir = null;
        parentDir = outFile.getParentFile() == null ? new File(".").getAbsoluteFile() : outFile.getParentFile();
        if (parentDir == null || !parentDir.canWrite()) {
            System.err.println("\nERROR: Output file specified is not writable [" + outputFilePath + "]. Please change permissions on directory/file and rerun, or specify new value.\n");
            TabixReaderTest.printUsage();
        }
        try {
            new TabixReaderTest(catalogFilePath, outFile).dumpMissesFromCatalog(useFixed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TabixReaderTest(String catalogPath, File outputFile) throws IOException {
        this.mCatalogPath = catalogPath;
        this.mOutputFile = outputFile;
        this.mTabixReaderBad = new TabixReaderBAD(catalogPath);
        this.mTabixReaderGood = new TabixReader(catalogPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMissesFromCatalog(boolean useFixed) {
        BufferedWriter outWtr = null;
        try {
            double start = System.currentTimeMillis();
            outWtr = new BufferedWriter(new FileWriter(this.mOutputFile));
            File catalogFile = new File(this.mCatalogPath);
            BlockCompressedInputStream inStream = new BlockCompressedInputStream(catalogFile);
            String line = null;
            int numLines = 0;
            int numMisses = 0;
            System.err.println(". = 10k lines,  o=100k lines");
            while ((line = inStream.readLine()) != null) {
                String tabixRegionQueryStr;
                if (++numLines % 1000000 == 0) {
                    System.err.println(numLines);
                } else if (numLines % 100000 == 0) {
                    System.err.print("o");
                } else if (numLines % 10000 == 0) {
                    System.err.print(".");
                }
                String chrom = this.getMid(line, "_landmark\":\"", "\"");
                String min = this.getMid(line, "_minBP\":", ",");
                String max = this.getMid(line, "_maxBP\":", ",");
                if (!this.isGiven(chrom) || this.isAtLeastOneHit(tabixRegionQueryStr = chrom + ":" + min + "-" + max, useFixed)) continue;
                ++numMisses;
                outWtr.write(line + "\t{}\n");
            }
            System.err.println();
            double end = System.currentTimeMillis();
            double runtime = (end - start) / 1000.0;
            long linesPerSecond = (long)((double)numLines / runtime);
            File tabixIndex = new File(this.mCatalogPath + ".tbi");
            String fileSizeWithCommas = new DecimalFormat("#,###").format(catalogFile.length());
            System.err.println("Catalog path:     " + this.mCatalogPath);
            System.err.println("Size of catalog:  " + fileSizeWithCommas);
            System.err.println("Last modified:    " + new Date(catalogFile.lastModified()));
            System.err.println("Tabix index size: " + new DecimalFormat("#,###").format(tabixIndex.length()));
            System.err.println("Tabix index last modified: " + new Date(tabixIndex.lastModified()));
            System.err.println("Time of this run: " + new Date());
            System.err.println("Total runtime (seconds) = " + runtime);
            System.err.println("Output file for MISSES:   " + this.mOutputFile.getCanonicalPath());
            System.err.println("# lines processed:        " + numLines);
            System.err.println("# lines processed per second: " + linesPerSecond);
            System.err.println("# MISSES:  " + numMisses);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outWtr != null) {
                    outWtr.flush();
                    outWtr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isAtLeastOneHit(String tabixRegionQueryStr, boolean useFixed) {
        try {
            if (useFixed) {
                TabixReader.Iterator iter = this.mTabixReaderGood.query(tabixRegionQueryStr);
                return iter != null && this.isGiven(iter.next());
            }
            TabixReaderBAD.Iterator iter = this.mTabixReaderBad.query(tabixRegionQueryStr);
            return iter != null && this.isGiven(iter.next());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isGiven(String s) {
        return s != null && s.trim().length() > 0;
    }

    private String getMid(String line, String pre, String post) {
        int idx1 = line.indexOf(pre);
        int idx2 = line.indexOf(post, idx1 + pre.length());
        if (idx1 == -1) {
            return "{}";
        }
        if (idx2 == -1) {
            idx2 = line.length();
        }
        return line.substring(idx1 + pre.length(), idx2).replace("}", "");
    }

    private static void printUsage() {
        System.err.println("This is a utility provided by the BIOR team to help assess the impact to user-generated\nBIOR catalogs due to a bug in a Broad Institute Java-based tabix reader used within the BIOR toolkit\nprior to versions 2.4.2 and 4.1.2.\n\nBy default the utility outputs all lines from of a BIOR catalog that do not return an expected\nresult. These lines in the catalog would have been incorrectly ommitted from annotations outputted\nby some commands in the BIOR toolkit.\n\nYou can also ensure your catalog is now returning all the expected results, as it should have been, by\nrunning this utility with the optional '--fixed' parameter.\n\nFor more information on this issue, please see web-site: http://bsiweb.mayo.edu/bior/java-tabix-bug-2016-09\n");
        System.err.println("USAGE: bior_count_catalog_misses --catalog <CATALOG> [ --output_file_path <OUTPUT_FILE_PATH> --fixed ]");
        System.err.println("where: \t--output_file_path <OUTPUT_FILE_PATH \t is optional. \n            If provided, the reported catalog rows that did not return an expected result will be written to this file.\n            If the file already exists, the program will exit with an error. If not provided, an output file name will \n            be generated automatically based on the catalog file name and reported at the conclusion of the program run.\n       \t--fixed \t is optional. \n            If --fixed is specified, the new, fixed htsjdk TabixReader will be used to check your catalog so that you can\n            verify the previous problem with the Java TabixReader has been resolved for your catalog.  If the --fixed parameter\n            is left out, this utility uses the older, broken TabixReader so that you can assess which annotations \n            from the specific catalog were incorrectly ommited in the past.\n");
        System.exit(1);
    }
}

