/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.MergeColumnsTsv;
import edu.mayo.bior.buildcatalog.StepLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;

public class MergeDataSourceProperties {
    private File mCatalogDir;
    private String mCatalogShortName;
    private File mPreviousCatalogDataSourceProperties;
    private StepLogger mStepLogger;
    private LinkedHashMap<DataSourceKey, String> mKeyToDescMap = new LinkedHashMap();

    public MergeDataSourceProperties(File catalogDir, String catalogShortName, File previousCatalogDataSourceProperties, StepLogger stepLogger) {
        this.mCatalogDir = catalogDir;
        this.mCatalogShortName = catalogShortName;
        this.mPreviousCatalogDataSourceProperties = previousCatalogDataSourceProperties;
        this.mStepLogger = stepLogger;
        this.initDefaultDescriptionMap();
    }

    private void initDefaultDescriptionMap() {
        this.mKeyToDescMap.put(DataSourceKey.ShortUniqueName, "## Short name that should be unique (or mostly unique except for fixes to existing catalog) across all catalogs. Ex: dbSNP_142_GRCh37p13");
        this.mKeyToDescMap.put(DataSourceKey.Description, "## Description of catalog.  Ex: NCBI's dbSNP Variant Database");
        this.mKeyToDescMap.put(DataSourceKey.Source, "## Source of data, without point release, etc.  Ex: dbSNP");
        this.mKeyToDescMap.put(DataSourceKey.Dataset, "## Type of data.  Ex: Variants");
        this.mKeyToDescMap.put(DataSourceKey.Version, "## Version of the data source.  Ex: 142");
        this.mKeyToDescMap.put(DataSourceKey.Build, "## The Genome build/assembly.  Ex: GRCh37.p13");
        this.mKeyToDescMap.put(DataSourceKey.Format, "## The BioR catalog compatibility format.  Ex: 1.1.0");
    }

    public void mergeDatasourceProperties() throws IOException, ConfigurationException {
        File currentPropsFile = new File(this.mCatalogDir, this.mCatalogShortName + ".datasource.properties");
        File defaultPropsFile = new File(this.mCatalogDir.getCanonicalPath() + "/.build", this.mCatalogShortName + ".datasource.properties.default");
        PropertiesConfiguration currentProps = this.loadProps(currentPropsFile);
        PropertiesConfiguration defaultProps = this.loadProps(defaultPropsFile);
        PropertiesConfiguration prevCtgProps = this.loadProps(this.mPreviousCatalogDataSourceProperties);
        List<String> defaultPropKeysUnused = this.toList(defaultProps.getKeys());
        List<String> prevCtgPropKeysUnused = this.toList(prevCtgProps.getKeys());
        Iterator currentKeys = currentProps.getKeys();
        for (DataSourceKey key : DataSourceKey.values()) {
            this.mergeValue(key, currentProps, defaultProps, prevCtgProps, defaultPropKeysUnused, prevCtgPropKeysUnused);
            this.mergeDescription(key, currentProps, defaultProps, prevCtgProps);
        }
        this.warnIfAnyDefaultKeysUnused(defaultPropKeysUnused, currentPropsFile, defaultPropsFile);
        this.warnIfAnyPreviousCatalogKeysUnused(prevCtgPropKeysUnused, currentPropsFile, this.mPreviousCatalogDataSourceProperties);
        this.warnIfCurrentDiffersFromPrevious(currentProps, prevCtgProps);
        MergeColumnsTsv.backupCurrentFile(currentPropsFile);
        currentProps.save(currentPropsFile);
        this.addTopMostCommentIfMissing(currentPropsFile);
        this.removeSpacesAroundEquals(currentPropsFile);
        if (MergeColumnsTsv.isCurrentSameAsLastBackup(currentPropsFile)) {
            this.mStepLogger.logAndSummary("No updates necessary to datasource.properties.");
            MergeColumnsTsv.removeLastBackup(currentPropsFile);
        }
    }

    private void warnIfCurrentDiffersFromPrevious(PropertiesConfiguration currentProps, PropertiesConfiguration prevCtgProps) {
        Iterator keys = currentProps.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String currVal = currentProps.getString(key);
            String prevVal = prevCtgProps.getString(key);
            if (!this.isGiven(currVal) || !this.isGiven(prevVal) || currVal.equals(prevVal)) continue;
            this.mStepLogger.logAndSummary("Note: '" + key + "' value is different between current and previous catalog.");
        }
    }

    private void removeSpacesAroundEquals(File currentPropsFile) throws IOException {
        List lines = FileUtils.readLines((File)currentPropsFile);
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.startsWith("#") || line.indexOf("=") == -1 || line.indexOf("=") <= 0 || line.indexOf("=") != 1 + line.indexOf(" = ")) continue;
            lines.set(i, line.replace(" = ", "="));
        }
        FileUtils.writeLines((File)currentPropsFile, (Collection)lines);
    }

    private void warnIfAnyPreviousCatalogKeysUnused(List<String> prevCtgPropKeysUnused, File currentPropsFile, File prevCtgPropsFile) throws IOException {
        if (prevCtgPropKeysUnused.size() > 0) {
            this.logAndSummary("These keys were found in the previous catalog file:");
            this.logAndSummary("    " + prevCtgPropsFile.getCanonicalPath());
            this.logAndSummary("but not in the current one:");
            this.logAndSummary("    " + currentPropsFile.getCanonicalPath());
            this.logAndSummary("--------:");
            for (String key : prevCtgPropKeysUnused) {
                this.logAndSummary("    " + key);
            }
        }
    }

    private void warnIfAnyDefaultKeysUnused(List<String> defaultPropKeysUnused, File currentPropsFile, File defaultPropsFile) throws IOException {
        if (defaultPropKeysUnused.size() > 0) {
            this.logAndSummary("These keys were found in the defaults file:");
            this.logAndSummary("    " + defaultPropsFile.getCanonicalPath());
            this.logAndSummary("but not in the current one:");
            this.logAndSummary("    " + currentPropsFile.getCanonicalPath());
            this.logAndSummary("--------:");
            for (String key : defaultPropKeysUnused) {
                this.logAndSummary("    " + key);
            }
        }
    }

    private void addTopMostCommentIfMissing(File currentPropsFile) throws IOException {
        String currentProps = FileUtils.readFileToString((File)currentPropsFile);
        String topMostComment = "### Datasource properties file for Catalog - " + this.mCatalogShortName + ".  Please fill in the descriptions to the keys below.\n";
        if (!currentProps.startsWith("### Datasource properties file for Catalog -")) {
            currentProps = topMostComment + currentProps;
        }
        String CATALOG_PREFIX_VAR = "_CATALOG_PREFIX_";
        if (currentProps.contains("_CATALOG_PREFIX_")) {
            currentProps = currentProps.replace("_CATALOG_PREFIX_", this.mCatalogShortName);
        }
        FileUtils.write((File)currentPropsFile, (CharSequence)currentProps);
    }

    private void mergeDescription(DataSourceKey key, PropertiesConfiguration currentProps, PropertiesConfiguration defaultProps, PropertiesConfiguration prevCtgProps) {
        String desc = currentProps.getLayout().getComment(key.toString());
        if (!this.isGiven(desc)) {
            this.log("Description/comment missing for key: '" + key.toString() + "'");
            String prevCtgDesc = prevCtgProps.getLayout().getComment(key.toString());
            String defaultDesc = defaultProps.getLayout().getComment(key.toString());
            if (this.isGiven(prevCtgDesc)) {
                this.log("  Using previous catalog description/comment: " + prevCtgDesc);
                currentProps.getLayout().setComment(key.toString(), prevCtgDesc);
            } else if (this.isGiven(defaultDesc)) {
                this.log("  Using default description/comment: " + defaultDesc);
                currentProps.getLayout().setComment(key.toString(), prevCtgDesc);
            } else {
                String hardCodedDesc = this.mKeyToDescMap.get((Object)key);
                this.log("  Using hard-coded description/comment: " + hardCodedDesc);
                currentProps.getLayout().setComment(key.toString(), hardCodedDesc);
            }
        }
    }

    private void mergeValue(DataSourceKey key, PropertiesConfiguration currentProps, PropertiesConfiguration defaultProps, PropertiesConfiguration prevCtgProps, List<String> defaultPropKeysUnused, List<String> prevCtgPropKeysUnused) {
        if (!this.isGiven(key, currentProps)) {
            this.logAndSummary("Key '" + (Object)((Object)key) + "' missing, or value is empty.  Attempting to add key and value...");
            if (this.isGiven(key, prevCtgProps)) {
                String val = prevCtgProps.getString(key.toString());
                this.logAndSummary("  Using the previous catalog key and value: " + val);
                currentProps.setProperty(key.toString(), (Object)val);
            } else if (this.isGiven(key, defaultProps)) {
                String val = defaultProps.getString(key.toString());
                this.logAndSummary("  Using the default catalog key and value: " + val);
                currentProps.setProperty(key.toString(), (Object)val);
            } else {
                this.logAndSummary("  Could not find a value in the previous catalog or defaults, so setting it to empty");
                currentProps.setProperty(key.toString(), (Object)"");
            }
        }
        defaultPropKeysUnused.remove(key.toString());
        prevCtgPropKeysUnused.remove(key.toString());
    }

    private List<String> toList(Iterator<String> keys) {
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasNext()) {
            keyList.add(keys.next());
        }
        return keyList;
    }

    private boolean isGiven(DataSourceKey key, PropertiesConfiguration props) {
        if (props == null) {
            return false;
        }
        String val = props.getString(key.toString());
        return val != null && val.trim().length() > 0;
    }

    private boolean isGiven(String s) {
        return s != null && s.trim().length() > 0;
    }

    private PropertiesConfiguration loadProps(File propsFile) throws IOException, ConfigurationException {
        PropertiesConfiguration props = new PropertiesConfiguration();
        try {
            if (propsFile != null) {
                props.load(propsFile);
            }
        }
        catch (Exception e) {
            this.log("Could not load the data source properties file: " + propsFile.getCanonicalPath());
        }
        return props;
    }

    private void log(String msg) {
        if (this.mStepLogger == null) {
            return;
        }
        this.mStepLogger.log(msg);
    }

    private void logAndSummary(String msg) {
        if (this.mStepLogger == null) {
            return;
        }
        this.mStepLogger.logAndSummary(msg);
    }

    private static enum DataSourceKey {
        ShortUniqueName,
        Description,
        Source,
        Dataset,
        Version,
        Build,
        Format;

    }
}

