/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import edu.mayo.bior.buildcatalog.BuildCatalogStepInputException;
import edu.mayo.bior.buildcatalog.BuildCatalogStepInterface;
import edu.mayo.bior.buildcatalog.BuildInfo;
import edu.mayo.bior.buildcatalog.BuildStepKey;
import edu.mayo.bior.buildcatalog.CreatePropFilesStep;
import edu.mayo.bior.buildcatalog.CreateStep;
import edu.mayo.bior.buildcatalog.HelpDocStep;
import edu.mayo.bior.buildcatalog.IndexesStep;
import edu.mayo.bior.buildcatalog.MakeJsonStep;
import edu.mayo.bior.buildcatalog.MergeMetadataStep;
import edu.mayo.bior.buildcatalog.StepLogger;
import edu.mayo.bior.buildcatalog.SummaryStep;
import edu.mayo.bior.buildcatalog.VerifyStep;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.exception.ExceptionUtils;

public class BuildCatalog {
    public void build(String buildInfoPath, BuildStepKey stepToStartFrom) throws Exception {
        BuildInfo buildInfo = new BuildInfo(buildInfoPath);
        File targetDir = new File(buildInfo.getTargetDirectory());
        if (stepToStartFrom.equals((Object)BuildStepKey.AUTO)) {
            stepToStartFrom = this.determineAutoResumeStep(targetDir);
        }
        this.deleteAllSuccessFilesOnAndAfterStep(stepToStartFrom, targetDir);
        for (BuildStepKey stepKey : BuildStepKey.values()) {
            if (!stepKey.isExecuteStep(stepToStartFrom)) continue;
            String stepDisplayName = stepKey.getDisplayName();
            StepLogger logger = new StepLogger(stepDisplayName, targetDir);
            BuildCatalogStepInterface buildStep = this.createStepForKey(stepKey, buildInfo, logger);
            try {
                logger.logAndSummary(String.format("%s step started", stepDisplayName));
                buildStep.execute();
                this.markStepSuccessful(stepDisplayName, targetDir);
                logger.logAndSummary(String.format("%s step succeeded", stepDisplayName));
            }
            catch (Exception e) {
                logger.log(ExceptionUtils.getStackTrace((Throwable)e));
                System.err.println("Unexpected error executing step " + stepKey.toString() + ".\n" + e.getMessage());
                throw e;
            }
            finally {
                logger.closeLogWriters();
            }
        }
    }

    private void deleteAllSuccessFilesOnAndAfterStep(BuildStepKey stepToStartFrom, File targetDir) {
        for (BuildStepKey stepKey : BuildStepKey.values()) {
            if (!stepKey.isExecuteStep(stepToStartFrom)) continue;
            this.getStepSuccessfulFile(stepKey.getDisplayName(), targetDir).delete();
        }
    }

    private void markStepSuccessful(String stepDisplayName, File targetDir) throws IOException {
        File successFile = this.getStepSuccessfulFile(stepDisplayName, targetDir);
        successFile.createNewFile();
    }

    private File getStepSuccessfulFile(String stepDisplayName, File targetDir) {
        File dir = new File(targetDir, ".build/progress");
        return new File(dir, stepDisplayName + ".successful");
    }

    private BuildCatalogStepInterface createStepForKey(BuildStepKey step, BuildInfo buildInfo, StepLogger logger) throws BuildCatalogStepInputException, IOException {
        if (step.equals((Object)BuildStepKey.MAKE_JSON)) {
            return new MakeJsonStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.CREATE_CATALOG)) {
            return new CreateStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.PROP_FILES)) {
            return new CreatePropFilesStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.MERGE_PROP_FILES)) {
            return new MergeMetadataStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.INDEXES)) {
            return new IndexesStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.VERIFY_CATALOG)) {
            return new VerifyStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.HELP_DOCS)) {
            return new HelpDocStep(buildInfo, logger);
        }
        if (step.equals((Object)BuildStepKey.SUMMARY)) {
            return new SummaryStep(buildInfo, logger);
        }
        throw new BuildCatalogStepInputException("Step not valid: " + step.toString());
    }

    private BuildStepKey determineAutoResumeStep(File targetDir) throws IOException {
        BuildStepKey[] steps = BuildStepKey.values();
        for (int i = 1; i < steps.length; ++i) {
            File successFile = this.getStepSuccessfulFile(steps[i].getDisplayName(), targetDir);
            if (successFile.exists()) continue;
            return steps[i];
        }
        return BuildStepKey.MAKE_JSON;
    }
}

