/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.FileAppenderFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlFileAppenderFactory
extends FileAppenderFactory {
    private DOMConfiguratorAccessor accessor = new DOMConfiguratorAccessor();
    private Document doc;
    private String filename;

    public XmlFileAppenderFactory(URL url) throws IOException, SAXException, ParserConfigurationException {
        this(url, null);
    }

    public XmlFileAppenderFactory(URL url, String filename) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        this.doc = docBuilder.parse(url.getFile());
        this.filename = filename;
    }

    public boolean appenderExists(String appenderName) {
        throw new RuntimeException("Not Implemented");
    }

    public void setAppenderFilename(String appenderName, String filename) {
        throw new RuntimeException("Not Implemented");
    }

    public String getAppenderFilename(String appenderName) {
        throw new RuntimeException("Not Implemented");
    }

    public FileAppender makeAppender(String appenderName) {
        Appender appender = this.accessor.findAppenderByName(this.doc, appenderName);
        if (appender != null) {
            if (appender instanceof FileAppender) {
                return (FileAppender)appender;
            }
            throw new RuntimeException(String.format("LOG4J appender %s is not a file appender", appenderName));
        }
        throw new RuntimeException(String.format("LOG4J appender %s could not be parsed", appenderName));
    }

    private class DOMConfiguratorAccessor
    extends DOMConfigurator {
        private DOMConfiguratorAccessor() {
        }

        public Appender findAppenderByName(Document theDoc, String appenderName) {
            return super.findAppenderByName(theDoc, appenderName);
        }
    }
}

