/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import edu.mayo.pipes.JSON.tabix.TabixReaderBAD;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class TabixWriter
extends TabixReaderBAD {
    private static final Charset LATIN1 = Charset.forName("ISO-8859-1");
    public static final int TI_PRESET_GENERIC = 0;
    public static final int TI_PRESET_SAM = 1;
    public static final int TI_PRESET_VCF = 2;
    public static final int TI_FLAG_UCSC = 65536;
    public static final Conf BIOR_CATALOG_CONF = new Conf(0, 1, 2, 3, '#', 0);
    public static final Conf GFF_CONF = new Conf(0, 1, 4, 5, '#', 0);
    public static final Conf BED_CONF = new Conf(65536, 1, 2, 3, '#', 0);
    public static final Conf PSLTBL_CONF = new Conf(65536, 15, 17, 18, '#', 0);
    public static final Conf SAM_CONF = new Conf(1, 3, 4, 0, '@', 0);
    public static final Conf VCF_CONF = new Conf(2, 1, 2, 0, '#', 0);
    List<Map<Integer, List<TabixReaderBAD.TPair64>>> binningIndex = new ArrayList<Map<Integer, List<TabixReaderBAD.TPair64>>>();
    List<List<Long>> linearIndex = new ArrayList<List<Long>>();

    public TabixWriter(File fn, Conf conf) throws Exception {
        this.applyConf(conf);
        this.mChr2tid = new LinkedHashMap();
    }

    private void applyConf(Conf conf) {
        this.mPreset = conf.preset;
        this.mSc = conf.chrColumn;
        this.mBc = conf.startColumn;
        this.mEc = conf.endColumn;
        this.mMeta = conf.commentChar;
        this.mSkip = conf.linesToSkip;
    }

    public void createIndex(File fn) throws Exception {
        BlockCompressedInputStream fp = new BlockCompressedInputStream(fn);
        this.makeIndex(fp);
        fp.close();
        File indexFile = new File(fn + ".tbi");
        BlockCompressedOutputStream fpidx = new BlockCompressedOutputStream(indexFile);
        this.saveIndex(fpidx);
        fpidx.close();
    }

    private void makeIndex(BlockCompressedInputStream fp) throws Exception {
        String str;
        long lineno = 0L;
        long offset0 = -1L;
        int last_bin = -1;
        int last_tid = -1;
        int save_tid = -1;
        int save_bin = -1;
        long last_off = 0L;
        long save_off = 0L;
        int last_coor = -1;
        while ((str = TabixWriter.readLine((InputStream)fp)) != null) {
            if (++lineno <= (long)this.mSkip || str.charAt(0) == this.mMeta) {
                last_off = fp.getFilePointer();
                continue;
            }
            TabixReaderBAD.TIntv intv = this.getIntv(str);
            if (intv.beg < 0 || intv.end < 0) {
                throw new Exception("The indexes overlap or are out of bounds.");
            }
            if (last_tid != intv.tid) {
                if (last_tid > intv.tid) {
                    throw new Exception(String.format("The chromosome blocks are not continuous at line %d, is the file sorted? [pos %d].", lineno, intv.beg + 1));
                }
                last_tid = intv.tid;
                last_bin = -1;
            } else if (last_coor > intv.beg) {
                throw new Exception(String.format("File out of order at line %d.", lineno));
            }
            long tmp = this.insertLinear(this.linearIndex.get(intv.tid), intv.beg, intv.end, last_off);
            if (last_off == 0L) {
                offset0 = tmp;
            }
            if (intv.bin != last_bin) {
                if (save_bin != -1) {
                    this.insertBinning(this.binningIndex.get(save_tid), save_bin, save_off, last_off);
                }
                save_off = last_off;
                save_bin = last_bin = intv.bin;
                save_tid = intv.tid;
                if (save_tid < 0) break;
            }
            if (fp.getFilePointer() <= last_off) {
                throw new Exception(String.format("Bug in BGZF: %x < %x.", fp.getFilePointer(), last_off));
            }
            last_off = fp.getFilePointer();
            last_coor = intv.beg;
        }
        if (save_tid >= 0) {
            this.insertBinning(this.binningIndex.get(save_tid), save_bin, save_off, fp.getFilePointer());
        }
        this.mergeChunks();
        this.fillMissing();
        if (offset0 != -1L && !this.linearIndex.isEmpty() && this.linearIndex.get(0) != null) {
            int beg = (int)(offset0 >> 32);
            int end = (int)(offset0 & 0xFFFFFFFFFFFFFFFFL);
            for (int i = beg; i <= end; ++i) {
                this.linearIndex.get(0).set(i, 0L);
            }
        }
    }

    private void insertBinning(Map<Integer, List<TabixReaderBAD.TPair64>> binningForChr, int bin, long beg, long end) {
        if (!binningForChr.containsKey(bin)) {
            binningForChr.put(bin, new ArrayList());
        }
        List<TabixReaderBAD.TPair64> list = binningForChr.get(bin);
        list.add(new TabixReaderBAD.TPair64(beg, end));
    }

    private long insertLinear(List<Long> linearForChr, int beg, int end, long offset) {
        end = end - 1 >> TAD_LIDX_SHIFT;
        int newSize = Math.max(beg >>= TAD_LIDX_SHIFT, end) + 1;
        while (linearForChr.size() < newSize) {
            linearForChr.add(0L);
        }
        if (beg == end) {
            if (linearForChr.get(beg) == 0L) {
                linearForChr.set(beg, offset);
            }
        } else {
            for (int i = beg; i <= end; ++i) {
                if (linearForChr.get(i) != 0L) continue;
                linearForChr.set(i, offset);
            }
        }
        return (long)beg << 32 | (long)end;
    }

    private void mergeChunks() {
        for (int i = 0; i < this.binningIndex.size(); ++i) {
            Map<Integer, List<TabixReaderBAD.TPair64>> binningForChr = this.binningIndex.get(i);
            for (Integer k : binningForChr.keySet()) {
                List<TabixReaderBAD.TPair64> p = binningForChr.get(k);
                int m = 0;
                for (int l = 1; l < p.size(); ++l) {
                    if (p.get((int)m).v >> 16 == p.get((int)l).u >> 16) {
                        p.get((int)m).v = p.get((int)l).v;
                        continue;
                    }
                    p.set(++m, p.get(l));
                }
                while (p.size() > m + 1) {
                    p.remove(p.size() - 1);
                }
            }
        }
    }

    private void fillMissing() {
        for (int i = 0; i < this.linearIndex.size(); ++i) {
            List<Long> linearForChr = this.linearIndex.get(i);
            for (int j = 1; j < linearForChr.size(); ++j) {
                if (linearForChr.get(j) != 0L) continue;
                linearForChr.set(j, linearForChr.get(j - 1));
            }
        }
    }

    public static void writeInt(OutputStream os, int value) throws IOException {
        byte[] buf = new byte[4];
        ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).putInt(value);
        os.write(buf);
    }

    public static void writeLong(OutputStream os, long value) throws IOException {
        byte[] buf = new byte[8];
        ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).putLong(value);
        os.write(buf);
    }

    private void saveIndex(BlockCompressedOutputStream fp) throws IOException {
        fp.write("TBI\u0001".getBytes(LATIN1));
        TabixWriter.writeInt((OutputStream)fp, this.binningIndex.size());
        TabixWriter.writeInt((OutputStream)fp, this.mPreset);
        TabixWriter.writeInt((OutputStream)fp, this.mSc);
        TabixWriter.writeInt((OutputStream)fp, this.mBc);
        TabixWriter.writeInt((OutputStream)fp, this.mEc);
        TabixWriter.writeInt((OutputStream)fp, this.mMeta);
        TabixWriter.writeInt((OutputStream)fp, this.mSkip);
        int l = 0;
        for (String k : this.mChr2tid.keySet()) {
            l += k.length() + 1;
        }
        TabixWriter.writeInt((OutputStream)fp, l);
        for (String k : this.mChr2tid.keySet()) {
            fp.write(k.getBytes(LATIN1));
            fp.write(0);
        }
        for (int i = 0; i < this.mChr2tid.size(); ++i) {
            Map<Integer, List<TabixReaderBAD.TPair64>> binningForChr = this.binningIndex.get(i);
            TabixWriter.writeInt((OutputStream)fp, binningForChr.size());
            for (int k : binningForChr.keySet()) {
                List<TabixReaderBAD.TPair64> p = binningForChr.get(k);
                TabixWriter.writeInt((OutputStream)fp, k);
                TabixWriter.writeInt((OutputStream)fp, p.size());
                for (TabixReaderBAD.TPair64 bin : p) {
                    TabixWriter.writeLong((OutputStream)fp, bin.u);
                    TabixWriter.writeLong((OutputStream)fp, bin.v);
                }
            }
            List<Long> linearForChr = this.linearIndex.get(i);
            TabixWriter.writeInt((OutputStream)fp, linearForChr.size());
            for (int x = 0; x < linearForChr.size(); ++x) {
                TabixWriter.writeLong((OutputStream)fp, linearForChr.get(x));
            }
        }
    }

    @Override
    protected int chr2tid(String chr) {
        if (!this.mChr2tid.containsKey(chr)) {
            this.mChr2tid.put(chr, this.mChr2tid.size());
            this.binningIndex.add(new HashMap());
            this.linearIndex.add(new ArrayList());
        }
        return (Integer)this.mChr2tid.get(chr);
    }

    @Override
    protected TabixReaderBAD.TIntv getIntv(String line) {
        TabixReaderBAD.TIntv result = super.getIntv(line);
        result.bin = this.reg2bin(result.beg, result.end);
        return result;
    }

    private int reg2bin(int beg, int end) {
        if (beg >> 14 == --end >> 14) {
            return 4681 + (beg >> 14);
        }
        if (beg >> 17 == end >> 17) {
            return 585 + (beg >> 17);
        }
        if (beg >> 20 == end >> 20) {
            return 73 + (beg >> 20);
        }
        if (beg >> 23 == end >> 23) {
            return 9 + (beg >> 23);
        }
        if (beg >> 26 == end >> 26) {
            return 1 + (beg >> 26);
        }
        return 0;
    }

    public static class Conf {
        public final int preset;
        public final int chrColumn;
        public final int startColumn;
        public final int endColumn;
        public final char commentChar;
        public final int linesToSkip;

        public Conf(int preset, int chrColumn, int startColumn, int endColumn, char commentChar, int linesToSkip) {
            this.preset = preset;
            this.chrColumn = chrColumn;
            this.startColumn = startColumn;
            this.endColumn = endColumn;
            this.commentChar = commentChar;
            this.linesToSkip = linesToSkip;
        }
    }
}

