/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.inject;

import com.google.gson.JsonObject;
import edu.mayo.pipes.JSON.inject.BaseInjector;
import edu.mayo.pipes.JSON.inject.ColumnAware;
import edu.mayo.pipes.JSON.inject.Injector;
import edu.mayo.pipes.JSON.inject.JsonType;
import edu.mayo.pipes.history.History;

public class ColumnInjector
extends BaseInjector
implements Injector,
ColumnAware {
    private int mCol;
    private String mKey;
    private JsonType mType;

    public ColumnInjector(int column, JsonType type) {
        this(column, null, type);
    }

    public ColumnInjector(int column, String key, JsonType type) {
        if (column == 0) {
            throw new IllegalArgumentException("Zero is not a valid column - columns begin with 1.");
        }
        this.mCol = column;
        this.mKey = key;
        this.mType = type;
    }

    @Override
    public void inject(JsonObject object, History history) {
        String key = this.mKey == null ? history.getMetaData().getColumns().get(this.mCol - 1).getColumnName() : this.mKey;
        String value = (String)history.get(this.mCol - 1);
        if (!this.isNull(value)) {
            super.injectAsPrimitive(object, key, value, this.mType);
        }
    }

    @Override
    public int getColumn() {
        return this.mCol;
    }

    public int getmCol() {
        return this.mCol;
    }

    public String getmKey() {
        return this.mKey;
    }

    public JsonType getmType() {
        return this.mType;
    }
}

