/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;
import org.biojava.utils.math.BinarySearch;
import org.biojava.utils.math.ComputeObject;

public class IsoelectricPointCalc {
    private static double PH_MIN = 0.0;
    private static double PH_MAX = 14.0;
    private static double EPSI = 1.0E-4;
    private static Map pK_NtermCache = new HashMap();
    private static Map pKCache = new HashMap();
    private static Map pK_CtermCache = new HashMap();
    private static IsoelectricPointCalc calculator;

    public IsoelectricPointCalc() {
        SymbolPropertyTable PK_NtermTable = ProteinTools.getSymbolPropertyTable("pK_Nterm");
        SymbolPropertyTable pKTable = ProteinTools.getSymbolPropertyTable("pK");
        SymbolPropertyTable PK_CtermTable = ProteinTools.getSymbolPropertyTable("pK_Cterm");
        Iterator<Symbol> aaSyms = ProteinTools.getAlphabet().iterator();
        while (aaSyms.hasNext()) {
            Symbol sym = aaSyms.next();
            try {
                double pK = PK_NtermTable.getDoubleValue(sym);
                if (Math.abs(pK) > 0.01) {
                    pK_NtermCache.put(sym, new Double(pK));
                }
                if (Math.abs(pK = pKTable.getDoubleValue(sym)) > 0.01) {
                    pKCache.put(sym, new Double(pK));
                }
                if (!(Math.abs(pK = PK_CtermTable.getDoubleValue(sym)) > 0.01)) continue;
                pK_CtermCache.put(sym, new Double(pK));
            }
            catch (IllegalSymbolException ise) {}
        }
    }

    public double getPI(SymbolList peptide, boolean hasFreeNTerm, boolean hasFreeCTerm) throws IllegalAlphabetException, BioException {
        if (peptide.getAlphabet() == ProteinTools.getTAlphabet() || peptide.getAlphabet() == ProteinTools.getAlphabet()) {
            ChargeCalculator computeObj = new ChargeCalculator(peptide, hasFreeNTerm, hasFreeCTerm);
            double pI = 0.0;
            try {
                pI = BinarySearch.solve(PH_MIN, PH_MAX, EPSI, computeObj);
            }
            catch (BioException ex) {
                BioException ex2 = new BioException("Error, the peptide probably contains only positive or negative charges");
                ex2.initCause(ex);
                throw ex2;
            }
            return pI;
        }
        throw new IllegalAlphabetException();
    }

    public static double getIsoelectricPoint(SymbolList peptide) throws IllegalAlphabetException, BioException {
        if (calculator == null) {
            calculator = new IsoelectricPointCalc();
        }
        double pi = calculator.getPI(peptide, true, true);
        return (double)Math.round(pi * 100.0) / 100.0;
    }

    public class ChargeCalculator
    implements ComputeObject {
        Map counts = null;
        Symbol Nterm = null;
        Symbol Cterm = null;
        boolean hasFreeNTerm = true;
        boolean hasFreeCTerm = true;

        private ChargeCalculator(SymbolList peptide, boolean hasFreeNTerm, boolean hasFreeCTerm) {
            this.counts = this.residueCount(peptide);
            this.hasFreeNTerm = hasFreeNTerm;
            this.hasFreeCTerm = hasFreeCTerm;
        }

        private Map residueCount(SymbolList peptide) {
            Iterator<Symbol> residues = peptide.iterator();
            HashMap<Symbol, Integer> symbolCounts = new HashMap<Symbol, Integer>();
            while (residues.hasNext()) {
                Symbol sym = residues.next();
                if (this.Nterm == null) {
                    this.Nterm = sym;
                }
                if (!residues.hasNext()) {
                    this.Cterm = sym;
                }
                if (!pKCache.containsKey(sym)) continue;
                Integer currCount = (Integer)symbolCounts.get(sym);
                if (currCount != null) {
                    int currCountAsInt = currCount;
                    symbolCounts.put(sym, new Integer(++currCountAsInt));
                    continue;
                }
                symbolCounts.put(sym, new Integer(1));
            }
            return symbolCounts;
        }

        public double compute(double pH) {
            double cr;
            Double value;
            double charge = 0.0;
            for (Symbol sym : this.counts.keySet()) {
                double cr2;
                boolean isAcid;
                Double value2 = (Double)pKCache.get(sym);
                if (value2 == null) continue;
                double pK = value2;
                double count = ((Integer)this.counts.get(sym)).intValue();
                boolean bl = isAcid = pK < 0.0;
                if (isAcid) {
                    pK = -pK;
                    cr2 = Math.pow(10.0, pK - pH);
                    charge -= count / (cr2 + 1.0);
                    continue;
                }
                cr2 = Math.pow(10.0, pH - pK);
                charge += count / (cr2 + 1.0);
            }
            if (this.hasFreeNTerm && (value = (Double)pK_NtermCache.get(this.Nterm)) != null) {
                double pK = value;
                cr = Math.pow(10.0, pH - pK);
                charge += 1.0 / (cr + 1.0);
            }
            if (this.hasFreeCTerm && (value = (Double)pK_CtermCache.get(this.Cterm)) != null) {
                double pK = -value.doubleValue();
                cr = Math.pow(10.0, pK - pH);
                charge -= 1.0 / (cr + 1.0);
            }
            return charge;
        }
    }
}

