/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class FileInputAsChar {
    protected String fileName = "";
    protected String stemName = "";
    protected String pathName = "";
    protected String dirPath = "";
    protected BufferedReader input = null;
    protected boolean testFullLine = false;
    protected boolean testFullLineT = false;
    protected boolean eof = false;
    protected boolean fileFound = true;

    public FileInputAsChar(String pathName) {
        int posDot;
        this.pathName = pathName;
        int posSlash = pathName.indexOf("//");
        int posBackSlash = pathName.indexOf("\\");
        if (posSlash != -1 || posBackSlash != -1) {
            File file = new File(this.pathName);
            this.fileName = file.getName();
            this.dirPath = file.getParentFile().toString();
        }
        this.stemName = (posDot = this.fileName.indexOf(46)) == -1 ? this.fileName : this.fileName.substring(0, posDot);
        try {
            this.input = new BufferedReader(new FileReader(this.pathName));
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
            this.fileFound = false;
        }
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStemName() {
        return this.stemName;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public final synchronized char readchar() {
        int ich = -1;
        char ch = '\u0000';
        try {
            ich = this.input.read();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        if (ich == -1) {
            System.out.println("FileInputAsChar.readchar:  attempt to read beyond end of file");
            this.eof = true;
            ch = '\u0000';
        } else {
            ch = (char)ich;
        }
        return ch;
    }

    public final synchronized Character readCharacter() {
        int ich = -1;
        char ch = '\u0000';
        Character wch = null;
        try {
            ich = this.input.read();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        if (ich == -1) {
            System.out.println("FileInputAsChar.readChar:  attempt to read beyond end of file");
            this.eof = true;
            ch = '\u0000';
            wch = null;
        } else {
            ch = (char)ich;
            wch = new Character(ch);
        }
        return wch;
    }

    public final synchronized int readint() {
        int ch = -1;
        try {
            ch = this.input.read();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        if (ch == -1) {
            System.out.println("FileInputAsChar.readint:  attempt to read beyond end of file");
            this.eof = true;
        }
        return ch;
    }

    public final synchronized void close() {
        if (this.fileFound) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean fileFound() {
        return this.fileFound;
    }
}

