/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Impedance;
import flanagan.circuits.TransmissionLine;

public class CoaxialLine
extends TransmissionLine {
    private double innerRadius = -1.0;
    private double outerRadius = -1.0;
    private boolean radiiSet = false;
    private double relativePermittivity = 1.0;
    private double relativePermeability = 1.0;

    public CoaxialLine() {
        this.title = "Coaxial Line";
    }

    public CoaxialLine(String title) {
        this.title = title;
    }

    public void setRadii(double innerRadius, double outerRadius) {
        if (innerRadius <= 0.0) {
            throw new IllegalArgumentException("The inner radius, " + innerRadius + ", must be greater than zero");
        }
        if (outerRadius <= 0.0) {
            throw new IllegalArgumentException("The outer radius, " + outerRadius + ", must be greater than zero");
        }
        if (innerRadius >= outerRadius) {
            throw new IllegalArgumentException("The inner radius, " + innerRadius + ", must be less than the outer radius, " + outerRadius);
        }
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.radiiSet = true;
        this.calculateDistributedCapacitanceAndInductance();
    }

    public void setInnerRadius(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("The inner radius, " + radius + ", must be greater than zero");
        }
        if (this.outerRadius != -1.0 && this.outerRadius <= radius) {
            throw new IllegalArgumentException("The inner radius, " + radius + ", must be less than the outer radius, " + this.outerRadius);
        }
        this.innerRadius = radius;
        if (this.outerRadius != -1.0) {
            this.radiiSet = true;
        }
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setOuterRadius(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("The outer radius, " + radius + ", must be greater than zero");
        }
        if (this.innerRadius != -1.0 && this.innerRadius >= radius) {
            throw new IllegalArgumentException("The outer radius, " + radius + ", must be greater than the inner radius, " + this.innerRadius);
        }
        this.outerRadius = radius;
        if (this.innerRadius != -1.0) {
            this.radiiSet = true;
        }
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermittivity(double epsilonR) {
        this.relativePermittivity = epsilonR;
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    public void setRelativePermeability(double muR) {
        this.relativePermeability = muR;
        if (this.radiiSet) {
            this.calculateDistributedCapacitanceAndInductance();
        }
    }

    private void calculateDistributedCapacitanceAndInductance() {
        this.distributedCapacitance = Impedance.coaxialCapacitance(1.0, this.innerRadius, this.outerRadius, this.relativePermittivity);
        this.distributedInductance = Impedance.coaxialInductance(1.0, this.innerRadius, this.outerRadius, this.relativePermeability);
    }

    @Override
    public CoaxialLine copy() {
        if (this == null) {
            return null;
        }
        CoaxialLine tl = new CoaxialLine();
        tl.innerRadius = this.innerRadius;
        tl.outerRadius = this.outerRadius;
        tl.radiiSet = this.radiiSet;
        tl.relativePermittivity = this.relativePermittivity;
        tl.relativePermeability = this.relativePermeability;
        tl.title = this.title;
        tl.distributedResistance = this.distributedResistance;
        tl.distributedConductance = this.distributedConductance;
        tl.distributedCapacitance = this.distributedCapacitance;
        tl.distributedInductance = this.distributedInductance;
        tl.distributedImpedance = this.distributedImpedance.copy();
        tl.distributedAdmittance = this.distributedAdmittance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.lineLength = this.lineLength;
        tl.segmentLength = this.segmentLength;
        tl.frequency = this.frequency;
        tl.segmentLength = this.segmentLength;
        tl.omega = this.omega;
        tl.inputVoltage = this.inputVoltage.copy();
        tl.inputCurrent = this.inputCurrent.copy();
        tl.outputVoltage = this.outputVoltage.copy();
        tl.outputCurrent = this.outputCurrent.copy();
        tl.idealWavelength = this.idealWavelength;
        tl.generalWavelength = this.generalWavelength;
        tl.lowLossWavelength = this.lowLossWavelength;
        tl.idealPhaseVelocity = this.idealPhaseVelocity;
        tl.generalPhaseVelocity = this.generalPhaseVelocity;
        tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        tl.idealGroupVelocity = this.idealGroupVelocity;
        tl.generalGroupVelocity = this.generalGroupVelocity;
        tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
        tl.delta = this.delta;
        tl.idealAttenuationConstant = this.idealAttenuationConstant;
        tl.generalAttenuationConstant = this.generalAttenuationConstant;
        tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        tl.idealPhaseConstant = this.idealPhaseConstant;
        tl.generalPhaseConstant = this.generalPhaseConstant;
        tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
        tl.idealPropagationConstant = this.idealPropagationConstant.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.generalPropagationConstant = this.generalPropagationConstant.copy();
        tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        tl.idealInputImpedance = this.idealInputImpedance.copy();
        tl.generalInputImpedance = this.generalInputImpedance.copy();
        tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
        tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
        tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        tl.idealABCDmatrix = this.idealABCDmatrix.copy();
        tl.generalABCDmatrix = this.generalABCDmatrix.copy();
        tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        tl.numberOfPoints = this.numberOfPoints;
        return tl;
    }

    @Override
    public Object clone() {
        CoaxialLine ret = null;
        if (this != null) {
            CoaxialLine tl = new CoaxialLine();
            tl.innerRadius = this.innerRadius;
            tl.outerRadius = this.outerRadius;
            tl.radiiSet = this.radiiSet;
            tl.relativePermittivity = this.relativePermittivity;
            tl.relativePermeability = this.relativePermeability;
            tl.title = this.title;
            tl.distributedResistance = this.distributedResistance;
            tl.distributedConductance = this.distributedConductance;
            tl.distributedCapacitance = this.distributedCapacitance;
            tl.distributedInductance = this.distributedInductance;
            tl.distributedImpedance = this.distributedImpedance.copy();
            tl.distributedAdmittance = this.distributedAdmittance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.lineLength = this.lineLength;
            tl.segmentLength = this.segmentLength;
            tl.frequency = this.frequency;
            tl.segmentLength = this.segmentLength;
            tl.omega = this.omega;
            tl.inputVoltage = this.inputVoltage.copy();
            tl.inputCurrent = this.inputCurrent.copy();
            tl.outputVoltage = this.outputVoltage.copy();
            tl.outputCurrent = this.outputCurrent.copy();
            tl.idealWavelength = this.idealWavelength;
            tl.generalWavelength = this.generalWavelength;
            tl.lowLossWavelength = this.lowLossWavelength;
            tl.idealPhaseVelocity = this.idealPhaseVelocity;
            tl.generalPhaseVelocity = this.generalPhaseVelocity;
            tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            tl.idealGroupVelocity = this.idealGroupVelocity;
            tl.generalGroupVelocity = this.generalGroupVelocity;
            tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
            tl.delta = this.delta;
            tl.idealAttenuationConstant = this.idealAttenuationConstant;
            tl.generalAttenuationConstant = this.generalAttenuationConstant;
            tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            tl.idealPhaseConstant = this.idealPhaseConstant;
            tl.generalPhaseConstant = this.generalPhaseConstant;
            tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
            tl.idealPropagationConstant = this.idealPropagationConstant.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.generalPropagationConstant = this.generalPropagationConstant.copy();
            tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            tl.idealInputImpedance = this.idealInputImpedance.copy();
            tl.generalInputImpedance = this.generalInputImpedance.copy();
            tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
            tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
            tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            tl.idealABCDmatrix = this.idealABCDmatrix.copy();
            tl.generalABCDmatrix = this.generalABCDmatrix.copy();
            tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            tl.numberOfPoints = this.numberOfPoints;
            ret = tl;
        }
        return ret;
    }
}

