/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Custom;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Regulation;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import java.util.ArrayList;
import java.util.List;

public class ChangeEffect
implements Cloneable,
Comparable<ChangeEffect> {
    static final boolean COMPATIBLE_v1_8 = true;
    SeqChange seqChange = null;
    EffectType effectType = EffectType.NONE;
    EffectImpact effectImpact = null;
    Marker marker = null;
    String error = "";
    String warning = "";
    String message = "";
    String codonsOld = "";
    String codonsNew = "";
    String codonsAroundOld = "";
    String codonsAroundNew = "";
    int codonNum = -1;
    int codonIndex = -1;
    int codonDegeneracy = -1;
    String aaOld = "";
    String aaNew = "";
    String aasAroundOld = "";
    String aasAroundNew = "";

    public static List<ChangeEffect> emptyResults() {
        return new ArrayList<ChangeEffect>();
    }

    public ChangeEffect(SeqChange seqChange) {
        this.seqChange = seqChange;
    }

    public void addError(ErrorType err) {
        this.error = this.error + (this.error.isEmpty() ? "" : "|") + (Object)((Object)err);
    }

    public void addWarning(String warn) {
        this.warning = this.warning + (this.warning.isEmpty() ? "" : "|") + warn;
    }

    public ChangeEffect clone() {
        try {
            return (ChangeEffect)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    String codonEffect(boolean showAaChange, boolean showBioType) {
        String codonEffect = "";
        if (this.marker == null || this.codonNum < 0) {
            return codonEffect;
        }
        codonEffect = codonEffect + (Object)((Object)this.effectType);
        if (showAaChange) {
            codonEffect = codonEffect + "(" + this.getAaChange() + ")";
        }
        return codonEffect;
    }

    @Override
    public int compareTo(ChangeEffect changeEffect) {
        int comp = this.getEffectImpact().compareTo(changeEffect.getEffectImpact());
        if (comp != 0) {
            return comp;
        }
        comp = this.getEffectType().compareTo(changeEffect.getEffectType());
        if (comp != 0) {
            return comp;
        }
        if (this.getMarker() != null && changeEffect.getMarker() != null) {
            return this.getMarker().compareTo(changeEffect.getMarker());
        }
        return this.seqChange.compareTo(changeEffect.getSeqChange());
    }

    public String effect(boolean shortFormat, boolean showAaChange, boolean showBioType) {
        String e = "";
        String codonEffect = this.codonEffect(showAaChange, showBioType);
        e = !codonEffect.isEmpty() ? codonEffect : (this.isRegulation() ? this.effectType.toString() + "[" + ((Regulation)this.marker).getName() + "]" : (this.isIntergenic() || this.isIntron() || this.isSpliceSite() ? this.effectType.toString() : (!this.message.isEmpty() ? this.effectType.toString() + ": " + this.message : (this.marker == null ? this.effectType.toString() : this.effectType.toString() + ": " + this.marker.getId()))));
        if (shortFormat) {
            e = e.split(":")[0];
        }
        return e;
    }

    public String getAaChange() {
        if (this.aaOld.isEmpty() && this.aaNew.isEmpty()) {
            return "";
        }
        if (this.aaOld.equals(this.aaNew)) {
            return this.aaNew;
        }
        return this.aaOld + "/" + this.aaNew;
    }

    public String getAaChangeHgvs() {
        if (this.aaOld.isEmpty() && this.aaNew.isEmpty()) {
            if (this.codonNum >= 0) {
                return "" + (this.codonNum + 1);
            }
            return "";
        }
        if (this.aaOld.equals(this.aaNew)) {
            return this.aaNew + (this.codonNum + 1);
        }
        return this.aaOld + (this.codonNum + 1) + this.aaNew;
    }

    public int getAaLength() {
        int cdsLen = this.getCdsLength();
        if (cdsLen < 0) {
            return -1;
        }
        int lenNoStop = Math.max(0, cdsLen - 3);
        return lenNoStop / 3;
    }

    public String getAaNew() {
        return this.aaNew;
    }

    public String getAaOld() {
        return this.aaOld;
    }

    public String getBiotype() {
        Gene gene = this.getGene();
        if (gene == null) {
            return "";
        }
        Transcript tr = this.getTranscript();
        if (tr != null) {
            return tr.getBioType();
        }
        if (gene.getGenome().hasCodingInfo()) {
            return gene.isProteinCoding() ? "coding" : "non-coding";
        }
        return "";
    }

    public int getCdsLength() {
        Transcript tr = this.getTranscript();
        if (tr != null && tr.isProteinCoding()) {
            return tr.cds().length();
        }
        return -1;
    }

    public String getCodonChange() {
        if (this.codonsOld.isEmpty() && this.codonsNew.isEmpty()) {
            return "";
        }
        if (this.codonsOld.equals(this.codonsNew)) {
            return this.codonsNew;
        }
        return this.codonsOld + "/" + this.codonsNew;
    }

    public int getCodonNum() {
        return this.codonNum;
    }

    public String getCodonsNew() {
        return this.codonsNew;
    }

    public String getCodonsOld() {
        return this.codonsOld;
    }

    public EffectImpact getEffectImpact() {
        if (this.effectImpact == null) {
            switch (this.effectType) {
                case EXON_DELETED: 
                case FRAME_SHIFT: 
                case SPLICE_SITE_ACCEPTOR: 
                case SPLICE_SITE_DONOR: 
                case START_LOST: 
                case STOP_GAINED: 
                case STOP_LOST: 
                case RARE_AMINO_ACID: {
                    this.effectImpact = EffectImpact.HIGH;
                    break;
                }
                case CODON_CHANGE: 
                case CODON_CHANGE_PLUS_CODON_DELETION: 
                case CODON_CHANGE_PLUS_CODON_INSERTION: 
                case CODON_DELETION: 
                case CODON_INSERTION: 
                case NON_SYNONYMOUS_CODING: 
                case SPLICE_SITE_BRANCH_U12: 
                case UTR_3_DELETED: 
                case UTR_5_DELETED: {
                    this.effectImpact = EffectImpact.MODERATE;
                    break;
                }
                case SPLICE_SITE_BRANCH: 
                case NON_SYNONYMOUS_START: 
                case NON_SYNONYMOUS_STOP: 
                case START_GAINED: 
                case SYNONYMOUS_CODING: 
                case SYNONYMOUS_START: 
                case SYNONYMOUS_STOP: {
                    this.effectImpact = EffectImpact.LOW;
                    break;
                }
                case CDS: 
                case CHROMOSOME: 
                case CUSTOM: 
                case DOWNSTREAM: 
                case EXON: 
                case GENE: 
                case INTRAGENIC: 
                case INTERGENIC: 
                case INTERGENIC_CONSERVED: 
                case INTRON: 
                case INTRON_CONSERVED: 
                case NONE: 
                case REGULATION: 
                case TRANSCRIPT: 
                case UPSTREAM: 
                case UTR_3_PRIME: 
                case UTR_5_PRIME: {
                    this.effectImpact = EffectImpact.MODIFIER;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown impact for effect type: '" + (Object)((Object)this.effectType) + "'");
                }
            }
        }
        return this.effectImpact;
    }

    public EffectType getEffectType() {
        return this.effectType;
    }

    public String getError() {
        return this.error;
    }

    public Exon getExon() {
        if (this.marker != null) {
            if (this.marker instanceof Exon) {
                return (Exon)this.marker;
            }
            return (Exon)this.marker.findParent(Exon.class);
        }
        return null;
    }

    public FunctionalClass getFunctionalClass() {
        if (this.seqChange.isSnp()) {
            if (!this.aaNew.equals(this.aaOld)) {
                CodonTable codonTable = this.marker.codonTable();
                if (codonTable.isStop(this.codonsNew)) {
                    return FunctionalClass.NONSENSE;
                }
                return FunctionalClass.MISSENSE;
            }
            if (!this.codonsNew.equals(this.codonsOld)) {
                return FunctionalClass.SILENT;
            }
        }
        return FunctionalClass.NONE;
    }

    public Gene getGene() {
        if (this.marker != null) {
            if (this.marker instanceof Gene) {
                return (Gene)this.marker;
            }
            return (Gene)this.marker.findParent(Gene.class);
        }
        return null;
    }

    public String getGeneRegion() {
        switch (this.effectType) {
            case CDS: 
            case CHROMOSOME: 
            case CUSTOM: 
            case NONE: {
                return EffectType.NONE.toString();
            }
            case INTERGENIC: 
            case INTERGENIC_CONSERVED: {
                return EffectType.INTERGENIC.toString();
            }
            case UPSTREAM: {
                return EffectType.UPSTREAM.toString();
            }
            case UTR_5_DELETED: 
            case START_GAINED: 
            case UTR_5_PRIME: {
                return EffectType.UTR_5_PRIME.toString();
            }
            case SPLICE_SITE_ACCEPTOR: {
                return EffectType.SPLICE_SITE_ACCEPTOR.toString();
            }
            case SPLICE_SITE_BRANCH_U12: 
            case SPLICE_SITE_BRANCH: {
                return EffectType.SPLICE_SITE_BRANCH.toString();
            }
            case SPLICE_SITE_DONOR: {
                return EffectType.SPLICE_SITE_DONOR.toString();
            }
            case START_LOST: 
            case NON_SYNONYMOUS_START: 
            case SYNONYMOUS_START: 
            case GENE: 
            case INTRAGENIC: 
            case TRANSCRIPT: {
                if (this.isExon()) {
                    return EffectType.EXON.toString();
                }
                return EffectType.NONE.toString();
            }
            case EXON_DELETED: 
            case FRAME_SHIFT: 
            case STOP_GAINED: 
            case STOP_LOST: 
            case RARE_AMINO_ACID: 
            case CODON_CHANGE: 
            case CODON_CHANGE_PLUS_CODON_DELETION: 
            case CODON_CHANGE_PLUS_CODON_INSERTION: 
            case CODON_DELETION: 
            case CODON_INSERTION: 
            case NON_SYNONYMOUS_CODING: 
            case NON_SYNONYMOUS_STOP: 
            case SYNONYMOUS_CODING: 
            case SYNONYMOUS_STOP: 
            case EXON: {
                return EffectType.EXON.toString();
            }
            case INTRON: 
            case INTRON_CONSERVED: {
                return EffectType.INTRON.toString();
            }
            case UTR_3_DELETED: 
            case UTR_3_PRIME: {
                return EffectType.UTR_3_PRIME.toString();
            }
            case DOWNSTREAM: {
                return EffectType.DOWNSTREAM.toString();
            }
            case REGULATION: {
                return EffectType.REGULATION.toString();
            }
        }
        throw new RuntimeException("Unknown gene region for effect type: '" + (Object)((Object)this.effectType) + "'");
    }

    public Intron getIntron() {
        if (this.marker != null) {
            if (this.marker instanceof Intron) {
                return (Intron)this.marker;
            }
            return (Intron)this.marker.findParent(Intron.class);
        }
        return null;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public SeqChange getSeqChange() {
        return this.seqChange;
    }

    public Transcript getTranscript() {
        if (this.marker != null) {
            if (this.marker instanceof Transcript) {
                return (Transcript)this.marker;
            }
            return (Transcript)this.marker.findParent(Transcript.class);
        }
        return null;
    }

    public String getWarning() {
        return this.warning;
    }

    public boolean hasWarning() {
        return this.warning != null && !this.warning.isEmpty();
    }

    public String header() {
        return "Warnings\tGene_ID\tGene_name\tBio_type\tTrancript_ID\tExon_ID\tExon_Rank\tEffect\told_AA/new_AA\tOld_codon/New_codon\tCodon_Num(CDS)\tCodon_Degeneracy\tCDS_size\tCodons_around\tAAs_around\tCustom_interval_ID";
    }

    public boolean isCustom() {
        return this.effectType == EffectType.CUSTOM;
    }

    public boolean isDownstream() {
        return this.effectType == EffectType.DOWNSTREAM;
    }

    public boolean isExon() {
        return this.marker instanceof Exon || this.effectType == EffectType.EXON_DELETED;
    }

    public boolean isFrameShift() {
        return this.effectType == EffectType.FRAME_SHIFT;
    }

    public boolean isIntergenic() {
        return this.effectType == EffectType.INTERGENIC || this.effectType == EffectType.INTERGENIC_CONSERVED;
    }

    public boolean isIntron() {
        return this.effectType == EffectType.INTRON;
    }

    public boolean isRegulation() {
        return this.effectType == EffectType.REGULATION;
    }

    public boolean isSpliceSite() {
        return this.effectType == EffectType.SPLICE_SITE_DONOR || this.effectType == EffectType.SPLICE_SITE_ACCEPTOR || this.effectType == EffectType.SPLICE_SITE_BRANCH || this.effectType == EffectType.SPLICE_SITE_BRANCH_U12;
    }

    public boolean isStartGained() {
        return this.effectType == EffectType.START_GAINED;
    }

    public boolean isUpstream() {
        return this.effectType == EffectType.UPSTREAM || this.effectType == EffectType.START_GAINED;
    }

    public boolean isUtr() {
        return this.effectType == EffectType.UTR_5_PRIME || this.effectType == EffectType.UTR_3_PRIME || this.effectType == EffectType.UTR_5_DELETED || this.effectType == EffectType.UTR_3_DELETED;
    }

    public List<ChangeEffect> newList() {
        ArrayList<ChangeEffect> list = new ArrayList<ChangeEffect>();
        list.add(this.clone());
        return list;
    }

    public void set(Marker marker, EffectType effectType, String message) {
        this.marker = marker;
        this.effectType = effectType;
        this.message = this.message + message;
    }

    public void setCodons(String codonsOld, String codonsNew, int codonNum, int codonIndex) {
        boolean indel;
        if (codonsOld.isEmpty()) {
            codonsOld = "-";
        }
        if (codonsNew.isEmpty()) {
            codonsNew = "-";
        }
        this.codonsOld = codonsOld;
        this.codonsNew = codonsNew;
        this.codonNum = codonNum;
        this.codonIndex = codonIndex;
        CodonTable codonTable = this.marker.codonTable();
        boolean bl = indel = codonsOld.length() != codonsNew.length();
        if (codonsOld.equals("-")) {
            this.aaOld = "-";
            indel = true;
        } else {
            this.aaOld = codonTable.aa(codonsOld);
            this.codonDegeneracy = codonTable.degenerate(codonsOld, codonIndex);
        }
        if (codonsNew.equals("-")) {
            this.aaNew = "-";
            indel = true;
        } else {
            this.aaNew = codonTable.aa(codonsNew);
        }
        if (!indel) {
            this.effectType = this.aaOld.equals(this.aaNew) ? (codonNum == 0 && codonTable.isStartFirst(codonsOld) ? (codonTable.isStartFirst(codonsNew) ? EffectType.SYNONYMOUS_START : EffectType.START_LOST) : (codonTable.isStop(codonsOld) ? (codonTable.isStop(codonsNew) ? EffectType.SYNONYMOUS_STOP : EffectType.STOP_LOST) : EffectType.SYNONYMOUS_CODING)) : (codonNum == 0 && codonTable.isStartFirst(codonsOld) ? (codonTable.isStartFirst(codonsNew) ? EffectType.NON_SYNONYMOUS_START : EffectType.START_LOST) : (codonTable.isStop(codonsOld) ? (codonTable.isStop(codonsNew) ? EffectType.NON_SYNONYMOUS_STOP : EffectType.STOP_LOST) : (codonTable.isStop(codonsNew) ? EffectType.STOP_GAINED : EffectType.NON_SYNONYMOUS_CODING)));
        } else if (codonNum == 0 && codonTable.isStartFirst(codonsOld) && !codonTable.isStartFirst(codonsNew)) {
            this.effectType = EffectType.START_LOST;
        } else if (codonTable.isStop(codonsOld) && !codonTable.isStop(codonsNew)) {
            this.effectType = EffectType.STOP_LOST;
        } else if (!codonTable.isStop(codonsOld) && codonTable.isStop(codonsNew)) {
            this.effectType = EffectType.STOP_GAINED;
        }
    }

    public void setCodonsAround(String codonsLeft, String codonsRight) {
        this.codonsAroundOld = codonsLeft.toLowerCase() + this.codonsOld.toUpperCase() + codonsRight.toLowerCase();
        this.codonsAroundNew = codonsLeft.toLowerCase() + this.codonsNew.toUpperCase() + codonsRight.toLowerCase();
        CodonTable codonTable = this.marker.codonTable();
        String aasLeft = codonTable.aa(codonsLeft);
        String aasRigt = codonTable.aa(codonsRight);
        this.aasAroundOld = aasLeft.toLowerCase() + this.aaOld.toUpperCase() + aasRigt.toLowerCase();
        this.aasAroundNew = aasLeft.toLowerCase() + this.aaNew.toUpperCase() + aasRigt.toLowerCase();
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public String toString() {
        String geneId = "";
        String geneName = "";
        String bioType = "";
        String transcriptId = "";
        String exonId = "";
        String customId = "";
        int exonRank = -1;
        if (this.marker != null) {
            Exon exon;
            Gene gene = this.getGene();
            Transcript tr = this.getTranscript();
            if (gene != null) {
                geneId = gene.getId();
                geneName = gene.getGeneName();
                bioType = this.getBiotype();
            }
            if (tr != null) {
                transcriptId = tr.getId();
            }
            if ((exon = this.getExon()) != null) {
                exonId = exon.getId();
                exonRank = exon.getRank();
            }
            if (this.isRegulation()) {
                bioType = ((Regulation)this.marker).getCellType();
            }
        }
        if (!this.seqChange.getId().isEmpty()) {
            customId = customId + this.seqChange.getId();
        }
        if (this.marker != null && this.marker instanceof Custom) {
            customId = customId + (customId.isEmpty() ? "" : ";") + this.marker.getId();
        }
        int cdsSize = this.getCdsLength();
        String errWarn = this.error + (this.error.isEmpty() ? "" : "|") + this.warning;
        return errWarn + "\t" + geneId + "\t" + geneName + "\t" + bioType + "\t" + transcriptId + "\t" + exonId + "\t" + (exonRank >= 0 ? Integer.valueOf(exonRank) : "") + "\t" + this.effect(false, false, false) + "\t" + (this.aaOld.length() + this.aaNew.length() > 0 ? this.aaOld + "/" + this.aaNew : "") + "\t" + (this.codonsOld.length() + this.codonsNew.length() > 0 ? this.codonsOld + "/" + this.codonsNew : "") + "\t" + (this.codonNum >= 0 ? Integer.valueOf(this.codonNum + 1) : "") + "\t" + (this.codonDegeneracy >= 0 ? this.codonDegeneracy + "" : "") + "\t" + (cdsSize >= 0 ? Integer.valueOf(cdsSize) : "") + "\t" + (this.codonsAroundOld.length() > 0 ? this.codonsAroundOld + " / " + this.codonsAroundNew : "") + "\t" + (this.aasAroundOld.length() > 0 ? this.aasAroundOld + " / " + this.aasAroundNew : "") + "\t" + customId;
    }

    public String toStringSimple(boolean shortFormat) {
        String eff;
        String transcriptId = "";
        Transcript tr = this.getTranscript();
        if (tr != null) {
            transcriptId = tr.getId();
        }
        String exonId = "";
        Exon exon = this.getExon();
        if (exon != null) {
            exonId = exon.getId();
        }
        if ((eff = this.effect(shortFormat, true, true)).length() > 0) {
            return eff;
        }
        if (exonId.length() > 0) {
            return exonId;
        }
        if (transcriptId.length() > 0) {
            return transcriptId;
        }
        return "NO EFFECT";
    }

    public static enum FunctionalClass {
        NONE,
        SILENT,
        MISSENSE,
        NONSENSE;

    }

    public static enum ErrorType {
        ERROR_CHROMOSOME_NOT_FOUND,
        ERROR_OUT_OF_CHROMOSOME_RANGE,
        ERROR_OUT_OF_EXON,
        ERROR_MISSING_CDS_SEQUENCE;

    }

    public static enum EffectType {
        NONE,
        CHROMOSOME,
        INTERGENIC,
        UPSTREAM,
        UTR_5_PRIME,
        UTR_5_DELETED,
        START_GAINED,
        SPLICE_SITE_ACCEPTOR,
        SPLICE_SITE_BRANCH,
        SPLICE_SITE_BRANCH_U12,
        SPLICE_SITE_DONOR,
        START_LOST,
        SYNONYMOUS_START,
        NON_SYNONYMOUS_START,
        CDS,
        GENE,
        GENOME,
        TRANSCRIPT,
        EXON,
        EXON_DELETED,
        NON_SYNONYMOUS_CODING,
        SYNONYMOUS_CODING,
        FRAME_SHIFT,
        CODON_CHANGE,
        CODON_INSERTION,
        CODON_CHANGE_PLUS_CODON_INSERTION,
        CODON_DELETION,
        CODON_CHANGE_PLUS_CODON_DELETION,
        RARE_AMINO_ACID,
        STOP_GAINED,
        SYNONYMOUS_STOP,
        NON_SYNONYMOUS_STOP,
        STOP_LOST,
        INTRON,
        UTR_3_PRIME,
        UTR_3_DELETED,
        DOWNSTREAM,
        INTRON_CONSERVED,
        INTERGENIC_CONSERVED,
        INTRAGENIC,
        REGULATION,
        MICRO_RNA,
        CUSTOM;

    }

    public static enum EffectImpact {
        HIGH,
        MODERATE,
        LOW,
        MODIFIER;

    }

    public static enum Coding {
        CODING,
        NON_CODING;

    }
}

