/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.sam;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.HashMap;

public class SamEntry {
    String line;
    String qname;
    int flag;
    String rname;
    int pos;
    int mapq;
    String cigar;
    String rnext;
    int pnext;
    int tlen;
    String seq;
    String qual;
    String[] tags;
    HashMap<String, String> tagsByName;

    public static String samLine2Id(String line) {
        return GprSeq.readId(line.split("\t")[0]);
    }

    public SamEntry(String line) {
        this.line = line;
        String[] recs = line.split("\t");
        this.qname = recs[0];
        this.flag = Gpr.parseIntSafe(recs[1]);
        this.rname = recs[2];
        this.pos = Gpr.parseIntSafe(recs[3]);
        this.mapq = Gpr.parseIntSafe(recs[4]);
        this.cigar = recs[5];
        this.pnext = Gpr.parseIntSafe(recs[6]);
        this.tlen = Gpr.parseIntSafe(recs[7]);
        this.rnext = recs[8];
        this.seq = recs[9];
        this.qual = recs[10];
        this.tags = new String[recs.length - 11];
        int i = 0;
        for (int j = 11; j < recs.length; ++j) {
            this.tags[i] = recs[j];
            ++i;
        }
    }

    public String findTag(String tagName) {
        if (this.tagsByName == null) {
            this.parseTags();
        }
        return this.tagsByName.get(tagName);
    }

    public String getCigar() {
        return this.cigar;
    }

    public int getFlag() {
        return this.flag;
    }

    public String getId() {
        return GprSeq.readId(this.qname);
    }

    public String getLine() {
        return this.line;
    }

    public int getMapq() {
        return this.mapq;
    }

    public int getPnext() {
        return this.pnext;
    }

    public int getPos() {
        return this.pos;
    }

    public String getQname() {
        return this.qname;
    }

    public String getQual() {
        return this.qual;
    }

    public String getRname() {
        return this.rname;
    }

    public String getRnext() {
        return this.rnext;
    }

    public String getSeq() {
        return this.seq;
    }

    public int getTlen() {
        return this.tlen;
    }

    public boolean hasMapq() {
        return this.mapq != 255;
    }

    public boolean isDuplicate() {
        return (this.flag & 0x400) != 0;
    }

    public boolean isFirstFragment() {
        return (this.flag & 0x40) != 0;
    }

    public boolean isLastFragment() {
        return (this.flag & 0x80) != 0;
    }

    public boolean isMapped() {
        return !this.isUnmapped();
    }

    public boolean isMultipleFragments() {
        return (this.flag & 1) != 0;
    }

    public boolean isMultipleHits() {
        String xa = this.findTag("XA");
        if (xa != null) {
            return true;
        }
        String xt = this.findTag("XT");
        if (xt != null && xt.equals("R")) {
            return true;
        }
        String x0 = this.findTag("X0");
        return x0 != null && !x0.equals("1");
    }

    public boolean isNextReverseWc() {
        return (this.flag & 0x20) != 0;
    }

    public boolean isNextUnmapped() {
        return (this.flag & 8) != 0;
    }

    public boolean isNotQualityControl() {
        return (this.flag & 0x200) != 0;
    }

    public boolean isProperlyAligned() {
        return (this.flag & 2) != 0;
    }

    public boolean isReverseWc() {
        return (this.flag & 0x10) != 0;
    }

    public boolean isSecondaryAlignment() {
        return (this.flag & 0x100) != 0;
    }

    public boolean isUniqueHit() {
        return !this.isMultipleHits();
    }

    public boolean isUnmapped() {
        return (this.flag & 4) != 0;
    }

    void parseTags() {
        this.tagsByName = new HashMap();
        for (String tag : this.tags) {
            String[] nv = tag.split(":");
            this.tagsByName.put(nv[0], nv[2]);
        }
    }

    public void replaceSeq(String newSeq) {
        if (newSeq.length() != this.seq.length()) {
            throw new RuntimeException("Cannot replace by a sequence with different length: Operation not supported!");
        }
        this.seq = newSeq;
        for (int i = 0; i < this.tags.length; ++i) {
            if (this.tags[i].startsWith("MD:Z:")) {
                this.tags[i] = null;
                continue;
            }
            if (!this.tags[i].startsWith("NM:i:")) continue;
            this.tags[i] = null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.qname + "\t" + this.flag + "\t" + this.rname + "\t" + this.pos + "\t" + this.mapq + "\t" + this.cigar + "\t" + this.rnext + "\t" + this.pnext + "\t" + this.tlen + "\t" + this.seq + "\t" + this.qual);
        for (int i = 0; i < this.tags.length; ++i) {
            if (this.tags[i] == null) continue;
            sb.append("\t" + this.tags[i]);
        }
        return sb.toString();
    }
}

