/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.MarkerParentId;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.List;

public class Marker
extends Interval {
    private static final long serialVersionUID = 7878886900660027549L;
    protected ChangeEffect.EffectType type = ChangeEffect.EffectType.NONE;

    protected Marker() {
        this.type = ChangeEffect.EffectType.NONE;
    }

    public Marker(Marker parent, int start, int end, int strand, String id) {
        super(parent, start, end, strand, id);
        if (parent != null && !parent.includes(this)) {
            String err = "";
            if (this.isShowWarningIfParentDoesNotInclude()) {
                err = "WARNING: " + this.getClass().getSimpleName() + " is not included in parent " + parent.getClass().getSimpleName() + ". " + "\t" + this.getClass().getSimpleName() + " '" + this.getId() + "'  [ " + this.getStart() + " , " + this.getEnd() + " ]" + "\t" + parent.getClass().getSimpleName() + " '" + parent.getId() + "' [ " + parent.getStart() + " , " + parent.getEnd() + " ]";
            }
            if (this.isAdjustIfParentDoesNotInclude(parent)) {
                parent.adjust(this);
                if (this.isShowWarningIfParentDoesNotInclude()) {
                    err = err + "\t=> Adjusting " + parent.getClass().getSimpleName() + " '" + parent.getId() + "' to [ " + parent.getStart() + " , " + parent.getEnd() + " ]";
                }
            }
            if (this.isShowWarningIfParentDoesNotInclude()) {
                System.err.println(err);
            }
        }
    }

    protected void adjust(Marker child) {
        this.start = Math.min(this.start, child.getStart());
        this.end = Math.max(this.end, child.getEnd());
    }

    @Override
    public Marker clone() {
        Marker m = (Marker)super.clone();
        if (m.getStart() != this.start) {
            throw new RuntimeException("Cloned start does not match!");
        }
        if (m.getEnd() != this.end) {
            throw new RuntimeException("Cloned end does not match!");
        }
        if (m.getStrand() != this.strand) {
            throw new RuntimeException("Cloned strand does not match!");
        }
        if (m.getParent() != this.parent) {
            throw new RuntimeException("Cloned parent does not match!");
        }
        return m;
    }

    public CodonTable codonTable() {
        return CodonTables.getInstance().getTable(this.getGenome(), this.getChromosomeName());
    }

    @Override
    public int compareTo(Interval i2) {
        Marker m2 = (Marker)i2;
        Chromosome chr1 = this.getChromosome();
        Chromosome chr2 = m2.getChromosome();
        if (chr1 != null && chr2 != null) {
            int compChromo = chr1.compareChromoName(chr2);
            if (compChromo != 0) {
                return compChromo;
            }
        } else {
            if (chr1 == null && chr2 != null) {
                return 1;
            }
            if (chr1 != null && chr2 == null) {
                return -1;
            }
        }
        if (this.start > i2.start) {
            return 1;
        }
        if (this.start < i2.start) {
            return -1;
        }
        if (this.end > i2.end) {
            return 1;
        }
        if (this.end < i2.end) {
            return -1;
        }
        if (this.id == null && i2.getId() == null) {
            return 0;
        }
        if (this.id != null && i2.getId() == null) {
            return -1;
        }
        if (this.id == null && i2.getId() != null) {
            return 1;
        }
        return this.id.compareTo(i2.getId());
    }

    public int distance(Marker interval) {
        if (!interval.getChromosomeName().equals(this.getChromosomeName())) {
            return -1;
        }
        if (this.intersects(interval)) {
            return 0;
        }
        if (this.start > interval.getEnd()) {
            return this.start - interval.getEnd();
        }
        if (interval.getStart() > this.end) {
            return interval.getStart() - this.end;
        }
        throw new RuntimeException("This should never happen!");
    }

    public Interval findParent(Class clazz) {
        if (this.getClass().equals(clazz)) {
            return this;
        }
        if (this.parent != null && this.parent instanceof Marker) {
            return ((Marker)this.parent).findParent(clazz);
        }
        return null;
    }

    public Chromosome getChromosome() {
        return (Chromosome)this.findParent(Chromosome.class);
    }

    public String getChromosomeName() {
        Chromosome chromo = (Chromosome)this.findParent(Chromosome.class);
        if (chromo != null) {
            return chromo.getId();
        }
        return "";
    }

    public double getChromosomeNum() {
        Chromosome chromo = (Chromosome)this.findParent(Chromosome.class);
        if (chromo != null) {
            return chromo.chromosomeNum;
        }
        return -1.0;
    }

    public Genome getGenome() {
        return (Genome)this.findParent(Genome.class);
    }

    public String getGenomeName() {
        Genome genome = (Genome)this.findParent(Genome.class);
        if (genome != null) {
            return genome.getId();
        }
        return "";
    }

    @Override
    public Marker getParent() {
        return (Marker)this.parent;
    }

    public ChangeEffect.EffectType getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int hashCode = this.getChromosomeName().hashCode();
        hashCode = hashCode * 31 + this.start;
        hashCode = hashCode * 31 + this.end;
        hashCode = hashCode * 31 + this.strand;
        hashCode = hashCode * 31 + this.id.hashCode();
        return hashCode;
    }

    public boolean includes(Marker interval) {
        if (!interval.getChromosomeName().equals(this.getChromosomeName())) {
            return false;
        }
        return this.start <= interval.start && interval.end <= this.end;
    }

    public Marker intersect(Marker m) {
        if (!this.getChromosomeName().equals(m.getChromosomeName())) {
            return null;
        }
        int istart = Math.max(this.start, m.getStart());
        int iend = Math.min(this.end, m.getEnd());
        if (iend < istart) {
            return null;
        }
        return new Marker(this.getParent(), istart, iend, (int)this.strand, "");
    }

    public boolean intersects(Marker interval) {
        if (!interval.getChromosomeName().equals(this.getChromosomeName())) {
            return false;
        }
        return interval.getEnd() >= this.start && interval.getStart() <= this.end;
    }

    public int intersectSize(Marker interval) {
        if (!interval.getChromosomeName().equals(this.getChromosomeName())) {
            return 0;
        }
        int start = Math.max(this.start, interval.getStart());
        int end = Math.min(this.end, interval.getEnd());
        if (end < start) {
            return 0;
        }
        return end - start + 1;
    }

    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return false;
    }

    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Markers minus(Marker interval) {
        Markers ints = new Markers();
        if (this.intersects(interval)) {
            if (interval.getStart() <= this.getStart() && this.getEnd() <= interval.getEnd()) return ints;
            if (interval.getStart() <= this.getStart() && interval.getEnd() < this.getEnd()) {
                ints.add(new Marker(this.getParent(), interval.getEnd() + 1, this.getEnd(), this.getStrand(), this.getId()));
                return ints;
            } else if (this.getStart() < interval.getStart() && this.getEnd() <= interval.getEnd()) {
                ints.add(new Marker(this.getParent(), this.getStart(), interval.getStart() - 1, this.getStrand(), this.getId()));
                return ints;
            } else {
                if (this.getStart() >= interval.getStart() || interval.getEnd() >= this.getEnd()) throw new RuntimeException("Interval intersection not analysed. This should nbever happen!");
                ints.add(new Marker(this.getParent(), this.getStart(), interval.getStart() - 1, this.getStrand(), this.getId()));
                ints.add(new Marker(this.getParent(), interval.getEnd() + 1, this.getEnd(), this.getStrand(), this.getId()));
            }
            return ints;
        } else {
            ints.add(this);
        }
        return ints;
    }

    public void readTxt(String line, int lineNum, Genome genome, int positionBase) {
        if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
            String[] fields = line.split("\\s+");
            if (fields.length >= 3) {
                Chromosome chromo = genome.getChromosome(fields[0].trim());
                if (chromo == null) {
                    System.err.println("WARNING: Chromosome '" + fields[0] + "' not found in genome '" + genome.getGenomeName() + "', version '" + genome.getVersion() + "'!\n\tLine: " + lineNum + "\t'" + line + "'");
                }
                this.parent = chromo;
                this.start = Gpr.parseIntSafe(fields[1]) - positionBase;
                this.end = Gpr.parseIntSafe(fields[2]) - positionBase;
                this.id = "";
                if (fields.length >= 4) {
                    for (int t = 3; t < fields.length; ++t) {
                        this.id = this.id + fields[t].trim() + " ";
                    }
                    this.id = this.id.trim();
                }
            } else {
                throw new RuntimeException("Error line " + lineNum + " (number of fields is " + fields.length + "):\t" + line);
            }
        }
    }

    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        if (!this.intersects(seqChange)) {
            return ChangeEffect.emptyResults();
        }
        changeEffect.set(this, this.type, "");
        return changeEffect.newList();
    }

    public void serializeParse(MarkerSerializer markerSerializer) {
        this.type = ChangeEffect.EffectType.valueOf(markerSerializer.getNextField());
        markerSerializer.getNextFieldInt();
        this.parent = new MarkerParentId(markerSerializer.getNextFieldInt());
        this.start = markerSerializer.getNextFieldInt();
        this.end = markerSerializer.getNextFieldInt();
        this.id = markerSerializer.getNextField();
        this.strand = (byte)markerSerializer.getNextFieldInt();
    }

    public String serializeSave(MarkerSerializer markerSerializer) {
        return (Object)((Object)this.type) + "\t" + markerSerializer.getIdByMarker(this) + "\t" + (this.parent != null ? markerSerializer.getIdByMarker((Marker)this.parent) : -1) + "\t" + this.start + "\t" + this.end + "\t" + this.id + "\t" + this.strand;
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + "\t" + this.start + "-" + this.end + " " + (Object)((Object)this.type) + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
    }

    public Marker union(Marker m) {
        if (!this.getChromosomeName().equals(m.getChromosomeName())) {
            return null;
        }
        int ustart = Math.min(this.start, m.getStart());
        int uend = Math.max(this.end, m.getEnd());
        return new Marker(this.getParent(), ustart, uend, (int)this.strand, "");
    }
}

