/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import edu.mayo.pipes.history.ColumnMetaData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileExistsException;

public class ColumnMetaDataOperations {
    public HashMap<String, ColumnMetaData> load(String columnPropertiesPath) throws IOException {
        String line;
        LinkedHashMap<String, ColumnMetaData> colMetaMap = new LinkedHashMap<String, ColumnMetaData>();
        BufferedReader reader = new BufferedReader(new FileReader(columnPropertiesPath));
        ArrayList<String> headerRows = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            String human;
            if (line.startsWith("#") || line.trim().length() == 0) {
                headerRows.add(line);
                continue;
            }
            String[] split = line.split("\t");
            String key = split[0].trim();
            ColumnMetaData.Type type = split.length > 1 ? ColumnMetaData.stringToType(split[1].trim()) : ColumnMetaData.Type.String;
            String count = split.length > 2 ? split[2].trim() : ".";
            String desc = split.length > 3 ? split[3].trim() : "";
            String string = human = split.length > 4 ? split[4].trim() : key;
            if (desc.equals(".")) {
                desc = "";
            }
            if (human.equals(".")) {
                human = key;
            }
            ColumnMetaData colMeta = new ColumnMetaData(key, type, count, desc, human);
            colMeta.setHeaderRows(headerRows);
            colMetaMap.put(key, colMeta);
        }
        return colMetaMap;
    }

    public void save(String columnsTsvPath, List<ColumnMetaData> colMetaList) throws IOException {
        this.save(columnsTsvPath, colMetaList, false);
    }

    public void save(String columnsTsvPath, List<ColumnMetaData> colMetaList, boolean isForceOverwrite) throws IOException {
        File columnsTsvFile = new File(columnsTsvPath);
        if (!isForceOverwrite && columnsTsvFile.exists()) {
            throw new FileExistsException(columnsTsvFile);
        }
        FileOutputStream fout = new FileOutputStream(new File(columnsTsvPath));
        List<String> headerLines = this.getDefaultColumnsTsvHeader();
        if (colMetaList.size() > 0 && colMetaList.get(0).getHeaderRows().size() > 0) {
            headerLines = colMetaList.get(0).getHeaderRows();
        }
        fout.write(this.getLinesAsString(headerLines).getBytes());
        for (ColumnMetaData colMeta : colMetaList) {
            fout.write((colMeta.toString() + "\n").getBytes());
        }
        fout.close();
    }

    public String getLinesAsString(List<String> headerLines) {
        StringBuilder str = new StringBuilder();
        for (String headerRow : headerLines) {
            str.append(headerRow + "\n");
        }
        return str.toString();
    }

    public List<String> getDefaultColumnsTsvHeader() {
        ArrayList<String> headerLines = new ArrayList<String>();
        headerLines.add("##-----------------------------------------------------");
        headerLines.add("## Catalog field definitions");
        headerLines.add("##-----------------------------------------------------");
        headerLines.add("## ColumnName = The key or column name");
        headerLines.add("## Type = The type of the object, as can be determined from parsing the VCF file or taking an educated guess based on the catalog values (Possible values: JSON, String, Integer, Float, Boolean)");
        headerLines.add("## Count = The number of values that repeatedly occur  (Possible values: 0 (Boolean), 1 (JSON,Integer,Float,String), or '.' for variable or unknown number of values.  JsonArrays will be resolved to other primitives such as String,Integer,Float, and will have a count of '.'");
        headerLines.add("## Description = The description of the ColumnName");
        headerLines.add("## HumanReadableName = A more readable name than ColumnName but typically not as long as Description.");
        headerLines.add("##------------------------------------------------------------------");
        headerLines.add("#ColumnName\tType\tCount\tDescription\tHumanReadableName");
        return headerLines;
    }

    public List<ColumnMetaData> merge(List<ColumnMetaData> colMetaListMain, List<ColumnMetaData> colMetaListAdditional) {
        HashSet<String> colNamesAlreadyAdded = new HashSet<String>();
        ArrayList<ColumnMetaData> mergedList = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData colMeta : colMetaListMain) {
            mergedList.add(colMeta);
            colNamesAlreadyAdded.add(colMeta.getColumnName());
        }
        for (ColumnMetaData colMeta : colMetaListAdditional) {
            if (colNamesAlreadyAdded.contains(colMeta.getColumnName())) continue;
            mergedList.add(colMeta);
            colNamesAlreadyAdded.add(colMeta.getColumnName());
        }
        return mergedList;
    }

    public List<String> validateContents(File catalogColumnsTsvFile) throws IllegalArgumentException, IOException {
        HashMap<String, ColumnMetaData> columnKeyToMetaMap = this.load(catalogColumnsTsvFile.getCanonicalPath());
        ArrayList<String> warningMsgs = new ArrayList<String>();
        ArrayList<String> errorMsgs = new ArrayList<String>();
        for (String key : columnKeyToMetaMap.keySet()) {
            ColumnMetaData colMeta = columnKeyToMetaMap.get(key);
            String offendingColMsg = "  Offending column: '" + key + "' in the file: " + catalogColumnsTsvFile.getCanonicalPath();
            String offendingLineMsg = "  Offending line: '" + colMeta.toString() + "' in the file: " + catalogColumnsTsvFile.getCanonicalPath();
            if (colMeta.getDescription() == null || colMeta.getDescription().length() == 0) {
                warningMsgs.add("Warning: Description not found." + offendingColMsg);
            }
            if (colMeta.getHumanReadableName() == null || colMeta.getHumanReadableName().length() == 0) {
                warningMsgs.add("Warning: HumanReadableName not found." + offendingColMsg);
            }
            if (key.equals(colMeta.getHumanReadableName())) {
                warningMsgs.add("Warning: HumanReadableName is set to the same value as the ColumnName." + offendingColMsg);
            }
            if (colMeta.getColumnName() == null || colMeta.getColumnName().trim().length() == 0) {
                errorMsgs.add("Error: The ColumnName must have a value." + offendingLineMsg);
            }
            if (colMeta.getColumnName().trim().startsWith(".")) {
                errorMsgs.add("Error: The ColumnName must not start with a dot." + offendingLineMsg);
            }
            if (colMeta.getType() == null) {
                errorMsgs.add("Error: The Type must not be null, and must be one of the accepted values." + offendingColMsg);
            }
            if (colMeta.getCount() == null || colMeta.getCount().trim().length() == 0) {
                errorMsgs.add("Error: The Count must have a value." + offendingColMsg);
            }
            if (".".equals(colMeta.getCount()) || this.isInteger(colMeta.getCount()) || "A".equalsIgnoreCase(colMeta.getCount())) continue;
            errorMsgs.add("Error: The Count must be one of these values:  a dot ('.'), an integer, or the letter 'A' (meaning there is a relationship between the count and the number of alt alleles, and these are always consistently the same)." + offendingColMsg);
        }
        if (errorMsgs.size() > 0) {
            throw new IllegalArgumentException(this.listToString(errorMsgs));
        }
        return warningMsgs;
    }

    private String listToString(List<String> errorMsgs) {
        StringBuilder str = new StringBuilder();
        for (String errorMsg : errorMsgs) {
            if (str.length() > 0) {
                str.append("\n");
            }
            str.append(errorMsg);
        }
        return str.toString();
    }

    private boolean isInteger(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

