/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.SNPEff;

import com.google.gson.JsonObject;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.SNPEff.SNPEffHelper;
import edu.mayo.bior.pipeline.SNPEff.SNPEffectHolder;
import edu.mayo.bior.pipeline.VCFProgramPipes.VCFProgram2HistoryPipe;
import edu.mayo.exec.UnixStreamCommand;
import edu.mayo.pipes.history.History;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class SNPEffPostProcessPipeline {
    private static final Logger log = Logger.getLogger(UnixStreamCommand.class);
    boolean summarizeEffect = true;
    public static final String SNPEFF_EFFECT_METADATA_DELIMITER = "[()]";
    public static final String SNPEFF_EFFECT_METADATA_SUBFIELD_DELIMITER = "\\|";
    private static String[] headers = new String[]{"Effect", "Effect_impact", "Functional_class", "Codon_change", "Amino_acid_change", "Gene_name", "Gene_bioType", "Coding", "Transcript", "Exon"};

    public SNPEffPostProcessPipeline(boolean summarizeEffect) {
        this.summarizeEffect = summarizeEffect;
    }

    public Pipe getSNPEffPostProcessPipeline(Pipe input, Pipe output) {
        TransformFunctionPipe transform = new TransformFunctionPipe((PipeFunction)new SNPEffTransformPipe(this.summarizeEffect));
        Pipeline pipe = new Pipeline(new Pipe[]{input, new VCFProgram2HistoryPipe(), transform, output});
        return pipe;
    }

    public TransformFunctionPipe getSNPEffTransformPipe(boolean showMostSignificantEffectOnly) {
        return new TransformFunctionPipe((PipeFunction)new SNPEffTransformPipe(showMostSignificantEffectOnly));
    }

    public static class SNPEffTransformPipe
    implements PipeFunction<History, History> {
        boolean showMostSignificantEffectOnly = true;

        public SNPEffTransformPipe(boolean showMostSignificantEffectOnly) {
            this.showMostSignificantEffectOnly = showMostSignificantEffectOnly;
        }

        public History compute(History history) {
            String parsedEffValue = this.parseEFFColumnData(history);
            history.add((Object)parsedEffValue);
            return history;
        }

        private String parseEFFColumnData(History history) {
            String parsedEff;
            block31: {
                String rawEff = "";
                parsedEff = "{}";
                ArrayList<SNPEffectHolder> snpEffectHolderObjs = new ArrayList<SNPEffectHolder>();
                SNPEffectHolder snpEffectHolder = null;
                String attrib_effect = "";
                try {
                    if (history.size() > 7) {
                        if (history.get(7) != null && !((String)history.get(7)).equals("")) {
                            if (((String)history.get(7)).contains("EFF=")) {
                                rawEff = (String)history.get(7);
                                String rawEffValue = rawEff.substring(rawEff.indexOf("EFF=") + 4, rawEff.length());
                                List<String> allEffects = null;
                                try {
                                    allEffects = Arrays.asList(rawEffValue.split(","));
                                }
                                catch (Exception ex) {
                                    log.error((Object)("SNPEffPostProcess Failed with message:: Effect values are not wellformed!!" + ex.getMessage()));
                                }
                                for (String effect : allEffects) {
                                    attrib_effect = effect.substring(0, effect.indexOf("("));
                                    HashMap<String, String> splitEffectCoreValues = new HashMap<String, String>();
                                    splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.EFFECT_KEY.getKeyName(), attrib_effect);
                                    String effectCoreValues = effect.substring(effect.indexOf("(") + 1, effect.indexOf(")"));
                                    String[] splitValues = effectCoreValues.split(SNPEffPostProcessPipeline.SNPEFF_EFFECT_METADATA_SUBFIELD_DELIMITER);
                                    for (int i = 0; i <= splitValues.length; ++i) {
                                        splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.IMPACT_KEY.getKeyName(), splitValues[0]);
                                        if (splitValues.length > 1) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName(), splitValues[1]);
                                        } else {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName(), "");
                                        }
                                        if (splitValues.length > 2) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.CODON_CHANGE_KEY.getKeyName(), splitValues[2]);
                                        } else {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.CODON_CHANGE_KEY.getKeyName(), "");
                                        }
                                        if (splitValues.length > 3) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.AMINO_ACID_CHANGE_KEY.getKeyName(), splitValues[3]);
                                        } else {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.AMINO_ACID_CHANGE_KEY.getKeyName(), "");
                                        }
                                        if (splitValues.length > 4) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.GENE_NAME_KEY.getKeyName(), splitValues[4]);
                                        } else {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.GENE_NAME_KEY.getKeyName(), "");
                                        }
                                        if (splitValues.length > 5) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.GENE_BIOTYPE_KEY.getKeyName(), splitValues[5]);
                                        } else {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.GENE_BIOTYPE_KEY.getKeyName(), "");
                                        }
                                        if (splitValues.length > 6) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.CODING.getKeyName(), splitValues[6]);
                                        } else {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.CODING.getKeyName(), "");
                                        }
                                        if (splitValues.length > 7) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.TRANSCRIPT_ID_KEY.getKeyName(), splitValues[7]);
                                        } else {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.TRANSCRIPT_ID_KEY.getKeyName(), "");
                                        }
                                        if (splitValues.length > 8) {
                                            splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.EXON_ID_KEY.getKeyName(), splitValues[8]);
                                            continue;
                                        }
                                        splitEffectCoreValues.put(SNPEffHelper.InfoFieldKey.EXON_ID_KEY.getKeyName(), "");
                                    }
                                    snpEffectHolder = new SNPEffectHolder(splitEffectCoreValues);
                                    snpEffectHolderObjs.add(snpEffectHolder);
                                }
                                if (this.showMostSignificantEffectOnly) {
                                    SNPEffectHolder mostSignificantEffect = SNPEffHelper.getMostSignificantEffect(snpEffectHolderObjs);
                                    parsedEff = this.jsonize(mostSignificantEffect.getAnnotationAsList());
                                } else {
                                    String outJson = "";
                                    ArrayList<String> resultsJsonStrings = new ArrayList<String>();
                                    for (SNPEffectHolder snpEffectHolderObj : snpEffectHolderObjs) {
                                        outJson = this.jsonize(snpEffectHolderObj.getAnnotationAsList());
                                        resultsJsonStrings.add(outJson);
                                    }
                                    parsedEff = this.buildJsonArray(resultsJsonStrings);
                                }
                                break block31;
                            }
                            if (history.size() > 8 && history.get(8) != null && ((String)history.get(8)).contains("SNPEFFERR=")) {
                                String message = ((String)history.get(8)).substring(((String)history.get(8)).indexOf("SNPEFFERR="), ((String)history.get(8)).length());
                                if (!message.equals("")) {
                                    JsonObject jObj = new JsonObject();
                                    jObj.addProperty("SNPEffMessage", message);
                                    jObj.addProperty("Status", "SNPEff failed to assign function to this variant");
                                    parsedEff = jObj.toString();
                                } else {
                                    log.error((Object)"SNPEffPostProcess failed with message::Cannot retrieve error message from SNPEff results!");
                                }
                            } else {
                                log.error((Object)"SNPEffPostProcess failed with message::INFO column does not have valid EFF or SNPEFFERROR to parse!");
                            }
                            break block31;
                        }
                        log.error((Object)"SNPEffPostProcess failed with message::Cannot Process SNPEff Result, INFO column not found!");
                        break block31;
                    }
                    log.error((Object)"SNPEffPostProcess failed with message::Cannot Process SNPEff Result, INFO column not found!");
                }
                catch (Exception ex) {
                    log.error((Object)("SNPEffPostProcess Failed with message::" + ex.getMessage()));
                }
            }
            return parsedEff;
        }

        private String jsonize(List<String> eff) {
            JsonObject jObj = new JsonObject();
            try {
                for (int i = 0; i < eff.size(); ++i) {
                    if (eff.get(i).length() <= 0 || headers.length < i) continue;
                    jObj.addProperty(headers[i], eff.get(i));
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage());
            }
            return jObj.toString();
        }

        private String buildJsonArray(List<String> resultsJsonStrings) {
            StringBuilder arrayOfJsons = new StringBuilder();
            arrayOfJsons.append("{");
            arrayOfJsons.append("\"");
            arrayOfJsons.append("EFF");
            arrayOfJsons.append("\"");
            arrayOfJsons.append(":");
            arrayOfJsons.append("[");
            ListIterator<String> it = resultsJsonStrings.listIterator();
            while (it.hasNext()) {
                arrayOfJsons.append(it.next());
                if (!it.hasNext()) continue;
                arrayOfJsons.append(",");
            }
            arrayOfJsons.append("]");
            arrayOfJsons.append("}");
            return arrayOfJsons.toString();
        }
    }
}

