/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.CompressPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.FieldSpecification;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class CompressCommand
implements CommandPlugin {
    private static final String DEFAULT_SEPARATOR = "|";
    private static final String DEFAULT_ESCAPE_SEPARATOR = "\\|";
    private static final char OPTION_SEPARATOR = 's';
    private static final char OPTION_ESCAPE = 'e';
    private static final char OPTION_REVERSE = 'r';
    private static final char OPTION_ALIGN = 'a';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String mOperation;

    public void init(Properties props) throws Exception {
        this.mOperation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        String fieldSpecStr = line.getArgs()[0];
        FieldSpecification.FieldDirection direction = line.hasOption('r') ? FieldSpecification.FieldDirection.RIGHT_TO_LEFT : FieldSpecification.FieldDirection.LEFT_TO_RIGHT;
        FieldSpecification fieldSpec = new FieldSpecification(fieldSpecStr, direction);
        String delimiter = DEFAULT_SEPARATOR;
        if (line.hasOption('s')) {
            delimiter = line.getOptionValue('s');
        }
        String escapeDelimiter = DEFAULT_ESCAPE_SEPARATOR;
        if (line.hasOption('e')) {
            escapeDelimiter = line.getOptionValue('e');
        }
        boolean useSetCompression = true;
        if (line.hasOption('a')) {
            useSetCompression = false;
        }
        CompressPipe compressPipe = new CompressPipe(this.mOperation, fieldSpec, delimiter, escapeDelimiter, useSetCompression);
        this.mPipeline.execute(new HistoryInPipe(compressPipe.getMetadata()), compressPipe, new HistoryOutPipe());
    }
}

