/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.FileAppenderFactory;
import org.apache.log4j.PropertyConfigurator;

public class PropertiesFileAppenderFactory
extends FileAppenderFactory {
    private static final String FILE_APPENDER_FILE_ATTR = "File";
    private Properties props = new Properties();

    public PropertiesFileAppenderFactory(URL url) throws IOException {
        FileInputStream in = new FileInputStream(url.getFile());
        this.props.load(in);
        in.close();
    }

    public boolean appenderExists(String appenderName) {
        Enumeration<Object> keySet = this.props.keys();
        while (keySet.hasMoreElements()) {
            String key = (String)keySet.nextElement();
            if (!this.isAppenderKey(key, appenderName)) continue;
            return true;
        }
        return false;
    }

    public void setAppenderFilename(String appenderName, String filename) {
        KeyValuePair kvPair = this.extractFilenameProperty(appenderName);
        if (kvPair != null) {
            this.props.setProperty(kvPair.key, filename);
        }
    }

    public String getAppenderFilename(String appenderName) {
        KeyValuePair kvPair = this.extractFilenameProperty(appenderName);
        if (kvPair != null) {
            return kvPair.value;
        }
        return null;
    }

    private KeyValuePair extractFilenameProperty(String appenderName) {
        Enumeration<Object> keySet = this.props.keys();
        while (keySet.hasMoreElements()) {
            String key = (String)keySet.nextElement();
            if (!this.isAppenderKey(key, appenderName) || !key.toLowerCase().endsWith("." + FILE_APPENDER_FILE_ATTR.toLowerCase())) continue;
            KeyValuePair kvPair = new KeyValuePair();
            kvPair.key = key;
            kvPair.value = this.props.getProperty(key);
            return kvPair;
        }
        return null;
    }

    private boolean isAppenderKey(String key, String appenderName) {
        return key.toLowerCase().startsWith(String.format("log4j.appender.%s", appenderName.toLowerCase()));
    }

    public FileAppender makeAppender(String appenderName) {
        PropertyConfigurator c = new PropertyConfigurator();
        Appender appender = c.parseAppender(this.props, appenderName);
        if (appender != null) {
            if (appender instanceof FileAppender) {
                return (FileAppender)appender;
            }
            throw new RuntimeException(String.format("LOG4J appender %s is not a file appender", appenderName));
        }
        throw new RuntimeException(String.format("LOG4J appender %s could not be parsed", appenderName));
    }

    private class KeyValuePair {
        String key;
        String value;

        private KeyValuePair() {
        }
    }
}

