/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.util;

import com.ibm.icu.lang.UCharacter;
import edu.mayo.cli.InvalidCharactersException;
import edu.mayo.cli.util.CLIConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.WordUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    public static String wrap(String str, int max_width) throws IOException {
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        StringReader sRdr = new StringReader(str);
        BufferedReader bRdr = new BufferedReader(sRdr);
        String line = bRdr.readLine();
        while (line != null) {
            line = line.trim().startsWith("<NOWRAP>") ? line.substring("<NOWRAP>".length()) : WordUtils.wrap((String)line, (int)max_width);
            pWtr.println(line);
            line = bRdr.readLine();
        }
        sWtr.close();
        String wrappedStr = sWtr.toString();
        if (wrappedStr.length() > 0) {
            wrappedStr = wrappedStr.substring(0, wrappedStr.length() - 1);
        }
        return wrappedStr;
    }

    public static String indent(String str, int numIndents) throws IOException {
        String indent = "";
        for (int i = 0; i < numIndents; ++i) {
            indent = indent + "\t";
        }
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        StringReader sRdr = new StringReader(str);
        BufferedReader bRdr = new BufferedReader(sRdr);
        String line = bRdr.readLine();
        while (line != null) {
            pWtr.print(indent);
            pWtr.println(line);
            line = bRdr.readLine();
        }
        sWtr.close();
        String indentedStr = sWtr.toString();
        if (indentedStr.length() > 0) {
            indentedStr = indentedStr.substring(0, indentedStr.length() - 1);
        }
        return indentedStr;
    }

    public static String toStringOptional(List<String> set) {
        StringBuilder str = new StringBuilder();
        for (String value : set) {
            str.append("\t");
            str.append("[");
            str.append(value.trim());
            str.append("]");
            str.append(CLIConstants.NEW_LINE);
        }
        return str.toString();
    }

    public static String toStringRequired(List<String> requiredLines, boolean isAddNewlineAfterEach) {
        StringBuilder str = new StringBuilder();
        for (String reqLine : requiredLines) {
            String eol = isAddNewlineAfterEach ? CLIConstants.NEW_LINE : "";
            str.append("\t");
            str.append(reqLine);
            str.append(eol);
        }
        return str.toString();
    }

    public static String toString(List<String> set) {
        StringBuilder sb = new StringBuilder();
        for (String value : set) {
            sb.append(value);
        }
        return sb.toString();
    }

    public static void validateASCII(String scriptName, String[] cmdArgs) throws InvalidCharactersException {
        CharsetEncoder encoder = Charset.forName("US-ASCII").newEncoder();
        StringBuilder mesg = new StringBuilder();
        ArrayList<Character> nonAsciiChars = new ArrayList<Character>();
        mesg.append(scriptName);
        mesg.append(' ');
        for (String cmdArg : cmdArgs) {
            for (char c : cmdArg.toCharArray()) {
                if (encoder.canEncode(c)) {
                    mesg.append(c);
                    continue;
                }
                mesg.append('[');
                mesg.append(c);
                mesg.append(']');
                nonAsciiChars.add(Character.valueOf(c));
            }
            mesg.append(' ');
        }
        if (nonAsciiChars.size() > 0) {
            StringWriter sWtr = new StringWriter();
            PrintWriter pWtr = new PrintWriter(sWtr);
            pWtr.println(String.format("Found non-ASCII characters.  Please correct the characters highlighted with [ ]:", new Object[0]));
            pWtr.println();
            pWtr.println("\t" + mesg.toString());
            pWtr.println();
            for (Character c : nonAsciiChars) {
                String name = UCharacter.getName((int)c.charValue());
                pWtr.println(String.format("\t[%s]  UTF-8 character \"%s\"", c.toString(), name));
            }
            pWtr.close();
            throw new InvalidCharactersException(sWtr.toString());
        }
    }
}

