/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli;

import edu.mayo.cli.CLIUsageHandler;
import edu.mayo.cli.InvalidNumberOfArgsException;
import edu.mayo.cli.util.CLIConstants;
import edu.mayo.cli.util.OptionsUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.FileAppenderFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertiesFileAppenderFactory;
import org.apache.log4j.XmlFileAppenderFactory;
import org.apache.log4j.helpers.Loader;
import org.xml.sax.SAXException;

public class CLILogHandler {
    private static String defaultLogName;
    private String logName;
    private boolean loggingTurnedOn = false;
    private FileAppenderFactory factory;

    public CLILogHandler() throws Exception {
        URL url = CLILogHandler.getLog4jConfigFileAsURL();
        if (url == null) {
            throw new Exception("Failed to locate LOG4J configuration file (log4j.properties or log4j.xml)");
        }
        this.factory = this.getAppenderFactory(url);
        if (!this.factory.appenderExists("mayo-commons-cli-log")) {
            throw new Exception(String.format("LOG4J configuration is missing appender %s", "mayo-commons-cli-log"));
        }
        defaultLogName = this.factory.getAppenderFilename("mayo-commons-cli-log");
    }

    public boolean isLoggingOn() {
        return this.loggingTurnedOn;
    }

    private FileAppender loadFileAppender(String appenderName, String logFilename) {
        this.factory.setAppenderFilename(appenderName, logFilename);
        return this.factory.makeAppender(appenderName);
    }

    public void turnOnLogging(File logFile) throws IOException {
        this.logName = logFile.getCanonicalPath();
        FileAppender fileAppender = this.loadFileAppender("mayo-commons-cli-log", this.logName);
        Logger.getRootLogger().addAppender((Appender)fileAppender);
        this.loggingTurnedOn = true;
    }

    private FileAppenderFactory getAppenderFactory(URL url) throws IOException, SAXException, ParserConfigurationException {
        if (url.getPath().endsWith(".properties")) {
            return new PropertiesFileAppenderFactory(url);
        }
        if (url.getPath().endsWith(".xml")) {
            return new XmlFileAppenderFactory(url);
        }
        throw new RuntimeException(String.format("Unsupported LOG4J config file: %s", url.getFile()));
    }

    public String getLogName() {
        return this.logName;
    }

    public String getDefaultLogName() {
        return defaultLogName;
    }

    private static URL getLog4jConfigFileAsURL() {
        URL url;
        String resource = System.getProperty("log4j.configuration");
        if (resource == null) {
            resource = "log4j.properties";
        }
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            url = Loader.getResource((String)resource);
        }
        return url;
    }

    private void testCanWriteLog(File logDir, String theLogName) throws IOException {
        if (!logDir.canWrite()) {
            throw new IOException("The directory for the log file is not writable. Unable to create and/or write to the log file: " + theLogName);
        }
    }

    private String constructCanonicalFileName(String file) throws IOException {
        if (file.startsWith("~")) {
            file = file.replaceFirst("^~", CLIConstants.USER_HOME);
        }
        String fileName = file.substring(file.lastIndexOf(CLIConstants.FILE_SEPARATOR) + 1);
        String directory = new File(file.substring(0, file.lastIndexOf(CLIConstants.FILE_SEPARATOR) + 1)).getCanonicalPath();
        fileName = directory + CLIConstants.FILE_SEPARATOR + fileName;
        return fileName;
    }

    public void processLogFlags(String[] cmdArgs, Options options, CLIUsageHandler usageHandler) throws Exception {
        File loggingDirectory = null;
        File logFile = null;
        boolean logOptionFound = false;
        boolean logFileOptionFound = false;
        if (usageHandler.isLogFlagUsed()) {
            logOptionFound = true;
            loggingDirectory = new File(CLIConstants.DEFAULT_LOG_DIRECTORY);
            logFile = new File(loggingDirectory, this.getDefaultLogName());
        }
        if (usageHandler.isLogFileFlagUsed()) {
            logFileOptionFound = true;
            Option logFileOption = OptionsUtil.getOptionByLongName(options, "logfile");
            for (int i = 0; i < cmdArgs.length; ++i) {
                if (!cmdArgs[i].equals("-" + logFileOption.getOpt()) && !cmdArgs[i].equals("--" + logFileOption.getLongOpt())) continue;
                if (i + 1 >= cmdArgs.length) {
                    throw new InvalidNumberOfArgsException(new String[0]);
                }
                String logFilename = cmdArgs[i + 1];
                logFile = new File(logFilename);
                String name = this.constructCanonicalFileName(logFilename);
                loggingDirectory = new File(name.substring(0, name.lastIndexOf(CLIConstants.FILE_SEPARATOR) + 1));
            }
        }
        if (logOptionFound && logFileOptionFound) {
            throw new Exception("Cannot specify both --log and --logfile options.");
        }
        if (loggingDirectory != null) {
            this.testCanWriteLog(loggingDirectory, logFile.getName());
            this.turnOnLogging(logFile);
        }
    }
}

