/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import edu.mayo.bior.util.FieldProcessorBase;

public class LookupProcessor
extends FieldProcessorBase {
    private String[] lookupTable;
    private int offset;
    private int max;
    private String defaultValue;

    public LookupProcessor(String[] lookupTable) {
        this(lookupTable, 0);
    }

    public LookupProcessor(String[] lookupTable, int offset) {
        this(lookupTable, offset, lookupTable == null || lookupTable.length == 0 ? null : lookupTable[0]);
    }

    public LookupProcessor(String[] lookupTable, int offset, String defaultValue) {
        this.lookupTable = lookupTable;
        this.offset = offset;
        this.defaultValue = defaultValue;
        this.max = lookupTable == null ? 0 : lookupTable.length;
    }

    @Override
    public String process(String value) {
        if (super.isBlank(value)) {
            return gCurBlankValue;
        }
        int result = 0;
        try {
            result = Integer.parseInt(value) - this.offset;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (result < 0 || result >= this.max) {
            return this.defaultValue;
        }
        return this.lookupTable[result];
    }
}

