/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class HgncFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"Approved_Name", "Ensembl_Gene_ID", "UniProt_ID"};
    private static final JsonPath PATH_GENENAME = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Filter[])new Filter[0]);
    private static final JsonPath PATH_ENSEMBLGENEID = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Filter[])new Filter[0]);
    private static final JsonPath PATH_UNIPROTID = JsonPath.compile((String)JSON_DRILL_PATHS[2], (Filter[])new Filter[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.HGNC;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("Approved_Gene_Name", "Ensembl_Gene_ID", "UniprotID");
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_GENENAME, json), FormatUtils.drill(PATH_ENSEMBLGENEID, json), FormatUtils.drill(PATH_UNIPROTID, json));
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }
}

